/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.sdk.service.kms20160120.models;

import com.aliyun.core.annotation.NameInMap;
import com.aliyun.core.annotation.Query;
import com.aliyun.core.annotation.Validation;
import com.aliyun.sdk.gateway.pop.models.Request;

public class AsymmetricVerifyRequest
extends Request {
    @Query
    @NameInMap(value="Algorithm")
    @Validation(required=true)
    private String algorithm;
    @Query
    @NameInMap(value="Digest")
    @Validation(required=true)
    private String digest;
    @Query
    @NameInMap(value="KeyId")
    @Validation(required=true)
    private String keyId;
    @Query
    @NameInMap(value="KeyVersionId")
    @Validation(required=true)
    private String keyVersionId;
    @Query
    @NameInMap(value="Value")
    @Validation(required=true)
    private String value;

    private AsymmetricVerifyRequest(Builder builder) {
        super((Request.Builder)builder);
        this.algorithm = builder.algorithm;
        this.digest = builder.digest;
        this.keyId = builder.keyId;
        this.keyVersionId = builder.keyVersionId;
        this.value = builder.value;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static AsymmetricVerifyRequest create() {
        return AsymmetricVerifyRequest.builder().build();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public String getAlgorithm() {
        return this.algorithm;
    }

    public String getDigest() {
        return this.digest;
    }

    public String getKeyId() {
        return this.keyId;
    }

    public String getKeyVersionId() {
        return this.keyVersionId;
    }

    public String getValue() {
        return this.value;
    }

    public static final class Builder
    extends Request.Builder<AsymmetricVerifyRequest, Builder> {
        private String algorithm;
        private String digest;
        private String keyId;
        private String keyVersionId;
        private String value;

        private Builder() {
        }

        private Builder(AsymmetricVerifyRequest request) {
            super((Request)request);
            this.algorithm = request.algorithm;
            this.digest = request.digest;
            this.keyId = request.keyId;
            this.keyVersionId = request.keyVersionId;
            this.value = request.value;
        }

        public Builder algorithm(String algorithm) {
            this.putQueryParameter("Algorithm", algorithm);
            this.algorithm = algorithm;
            return this;
        }

        public Builder digest(String digest) {
            this.putQueryParameter("Digest", digest);
            this.digest = digest;
            return this;
        }

        public Builder keyId(String keyId) {
            this.putQueryParameter("KeyId", keyId);
            this.keyId = keyId;
            return this;
        }

        public Builder keyVersionId(String keyVersionId) {
            this.putQueryParameter("KeyVersionId", keyVersionId);
            this.keyVersionId = keyVersionId;
            return this;
        }

        public Builder value(String value) {
            this.putQueryParameter("Value", value);
            this.value = value;
            return this;
        }

        public AsymmetricVerifyRequest build() {
            return new AsymmetricVerifyRequest(this);
        }
    }
}

