/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.registry.server.integration;

import com.alipay.sofa.registry.common.model.CommonResponse;
import com.alipay.sofa.registry.common.model.store.URL;
import com.alipay.sofa.registry.log.Logger;
import com.alipay.sofa.registry.log.LoggerFactory;
import com.alipay.sofa.registry.remoting.Channel;
import com.alipay.sofa.registry.remoting.jersey.JerseyClient;
import com.alipay.sofa.registry.server.data.DataApplication;
import com.alipay.sofa.registry.server.data.bootstrap.DataServerBootstrap;
import com.alipay.sofa.registry.server.meta.MetaApplication;
import com.alipay.sofa.registry.server.meta.bootstrap.MetaServerBootstrap;
import com.alipay.sofa.registry.server.session.SessionApplication;
import com.alipay.sofa.registry.server.session.bootstrap.SessionServerBootstrap;
import com.alipay.sofa.registry.util.PropertySplitter;
import java.util.Collection;
import org.springframework.boot.builder.SpringApplicationBuilder;
import org.springframework.context.ConfigurableApplicationContext;

public class RegistryApplication {
    private static final Logger LOGGER = LoggerFactory.getLogger(RegistryApplication.class);
    private static final String META_HTTP_SERVER_PORT = "meta.server.httpServerPort";
    private static final String DATA_HTTP_SERVER_PORT = "data.server.httpServerPort";
    private static final String SESSION_HTTP_SERVER_PORT = "session.server.httpServerPort";
    private static final String META_NODES = "nodes.metaNode";
    private static final String NODES_LOCAL_DATA_CENTER = "nodes.localDataCenter";
    private static ConfigurableApplicationContext metaApplicationContext;
    private static ConfigurableApplicationContext sessionApplicationContext;
    private static ConfigurableApplicationContext dataApplicationContext;

    public static void main(String[] args) throws Exception {
        Thread.setDefaultUncaughtExceptionHandler((t, e) -> LOGGER.error(String.format("UncaughtException in Thread(%s): %s", t.getName(), e.getMessage()), e));
        ConfigurableApplicationContext commonContext = new SpringApplicationBuilder(new Object[]{RegistryApplication.class}).run(args);
        Collection<String> serverList = RegistryApplication.getServerList(commonContext);
        metaApplicationContext = new SpringApplicationBuilder(new Object[]{MetaApplication.class}).parent(commonContext).run(new String[0]);
        RegistryApplication.waitClusterStart(serverList, Integer.parseInt(commonContext.getEnvironment().getProperty(META_HTTP_SERVER_PORT)));
        dataApplicationContext = new SpringApplicationBuilder(new Object[]{DataApplication.class}).parent(commonContext).run(new String[0]);
        RegistryApplication.waitClusterStart(serverList, Integer.parseInt(commonContext.getEnvironment().getProperty(DATA_HTTP_SERVER_PORT)));
        sessionApplicationContext = new SpringApplicationBuilder(new Object[]{SessionApplication.class}).parent(commonContext).run(new String[0]);
        RegistryApplication.waitClusterStart(serverList, Integer.parseInt(commonContext.getEnvironment().getProperty(SESSION_HTTP_SERVER_PORT)));
    }

    public static void stop() {
        if (sessionApplicationContext != null) {
            ((SessionServerBootstrap)sessionApplicationContext.getBean("sessionServerBootstrap", SessionServerBootstrap.class)).destroy();
        }
        if (dataApplicationContext != null) {
            ((DataServerBootstrap)dataApplicationContext.getBean("dataServerBootstrap", DataServerBootstrap.class)).destroy();
        }
        if (metaApplicationContext != null) {
            ((MetaServerBootstrap)metaApplicationContext.getBean("metaServerBootstrap", MetaServerBootstrap.class)).destroy();
        }
    }

    private static Collection<String> getServerList(ConfigurableApplicationContext commonContext) {
        String metaNodes = commonContext.getEnvironment().getProperty(META_NODES);
        String localDataCenter = commonContext.getEnvironment().getProperty(NODES_LOCAL_DATA_CENTER);
        return (Collection)new PropertySplitter().mapOfList(metaNodes).get(localDataCenter);
    }

    private static void waitClusterStart(Collection<String> serverList, int httpPort) throws Exception {
        block0: for (String serverAddress : serverList) {
            while (true) {
                if (RegistryApplication.nodeHealthCheck(serverAddress, httpPort)) {
                    LOGGER.info("{}:{} health check success.", (Object)serverAddress, (Object)httpPort);
                    continue block0;
                }
                LOGGER.error("{}:{} health check failed.", (Object)serverAddress, (Object)httpPort);
                Thread.sleep(1000L);
            }
        }
    }

    private static boolean nodeHealthCheck(String serverAddress, int httpPort) {
        try {
            JerseyClient jerseyClient = JerseyClient.getInstance();
            Channel channel = jerseyClient.connect(new URL(serverAddress, httpPort));
            return ((CommonResponse)channel.getWebTarget().path("health/check").request(new String[]{"application/json"}).get(CommonResponse.class)).isSuccess();
        }
        catch (Throwable t) {
            LOGGER.error("{}:{} health check failed.", new Object[]{serverAddress, httpPort, t});
            return false;
        }
    }

    public static ConfigurableApplicationContext getMetaApplicationContext() {
        return metaApplicationContext;
    }

    public static ConfigurableApplicationContext getSessionApplicationContext() {
        return sessionApplicationContext;
    }

    public static ConfigurableApplicationContext getDataApplicationContext() {
        return dataApplicationContext;
    }
}

