package com.alipay.api.domain;

import com.alipay.api.AlipayObject;
import com.alipay.api.internal.mapping.ApiField;

/**
 * 统一收单交易关闭接口
 *
 * @author auto create
 * @since 1.0, 2025-03-26 21:29:54
 */
public class AlipayTradeCloseModel extends AlipayObject {

	private static final long serialVersionUID = 2678843327447727223L;

	/**
	 * 扩展字段
	 */
	@ApiField("extend_params")
	private CloseExtendParams extendParams;

	/**
	 * 商家操作员编号 id，由商家自定义。
	 */
	@ApiField("operator_id")
	private String operatorId;

	/**
	 * 订单支付时传入的商户订单号,和支付宝交易号不能同时为空。 trade_no,out_trade_no如果同时存在优先取trade_no
	 */
	@ApiField("out_trade_no")
	private String outTradeNo;

	/**
	 * 该交易在支付宝系统中的交易流水号。最短 16 位，最长 64 位。和out_trade_no不能同时为空，如果同时传了 out_trade_no和 trade_no，则以 trade_no为准。
	 */
	@ApiField("trade_no")
	private String tradeNo;

	public CloseExtendParams getExtendParams() {
		return this.extendParams;
	}
	public void setExtendParams(CloseExtendParams extendParams) {
		this.extendParams = extendParams;
	}

	public String getOperatorId() {
		return this.operatorId;
	}
	public void setOperatorId(String operatorId) {
		this.operatorId = operatorId;
	}

	public String getOutTradeNo() {
		return this.outTradeNo;
	}
	public void setOutTradeNo(String outTradeNo) {
		this.outTradeNo = outTradeNo;
	}

	public String getTradeNo() {
		return this.tradeNo;
	}
	public void setTradeNo(String tradeNo) {
		this.tradeNo = tradeNo;
	}

}
