/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.v3.model;

import com.alipay.v3.JSON;
import com.alipay.v3.model.BoxBusinessDistrictModule;
import com.alipay.v3.model.SearchBoxAccountModule;
import com.alipay.v3.model.SearchBoxAreaKeyWordModule;
import com.alipay.v3.model.SearchBoxBasicInfoModule;
import com.alipay.v3.model.SearchBoxImageModule;
import com.alipay.v3.model.SearchBoxKeyWordModule;
import com.alipay.v3.model.SearchBoxServiceModule;
import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.annotations.SerializedName;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import javax.annotation.Nullable;

public class AlipayOpenSearchBoxQueryResponseModel {
    public static final String SERIALIZED_NAME_ACCOUNT_MODULE = "account_module";
    @SerializedName(value="account_module")
    private SearchBoxAccountModule accountModule;
    public static final String SERIALIZED_NAME_AREA_KEYWORD_MODULE = "area_keyword_module";
    @SerializedName(value="area_keyword_module")
    private SearchBoxAreaKeyWordModule areaKeywordModule;
    public static final String SERIALIZED_NAME_BASIC_INFO_MODULE = "basic_info_module";
    @SerializedName(value="basic_info_module")
    private SearchBoxBasicInfoModule basicInfoModule;
    public static final String SERIALIZED_NAME_BOX_ID = "box_id";
    @SerializedName(value="box_id")
    private String boxId;
    public static final String SERIALIZED_NAME_BOX_STATUS = "box_status";
    @SerializedName(value="box_status")
    private String boxStatus;
    public static final String SERIALIZED_NAME_BUSINESS_DISTRICT_MODULE = "business_district_module";
    @SerializedName(value="business_district_module")
    private BoxBusinessDistrictModule businessDistrictModule;
    public static final String SERIALIZED_NAME_DEFAULT_KEYWORDS = "default_keywords";
    @SerializedName(value="default_keywords")
    private List<String> defaultKeywords = null;
    public static final String SERIALIZED_NAME_KEYWORD_MODULE = "keyword_module";
    @SerializedName(value="keyword_module")
    private SearchBoxKeyWordModule keywordModule;
    public static final String SERIALIZED_NAME_LATEST_AUDIT_IMAGE = "latest_audit_image";
    @SerializedName(value="latest_audit_image")
    private SearchBoxImageModule latestAuditImage;
    public static final String SERIALIZED_NAME_SERVICE_MODULE = "service_module";
    @SerializedName(value="service_module")
    private SearchBoxServiceModule serviceModule;
    public static final String SERIALIZED_NAME_VALID_IMAGE = "valid_image";
    @SerializedName(value="valid_image")
    private SearchBoxImageModule validImage;
    public static HashSet<String> openapiFields = new HashSet();
    public static HashSet<String> openapiRequiredFields;

    public AlipayOpenSearchBoxQueryResponseModel accountModule(SearchBoxAccountModule accountModule) {
        this.accountModule = accountModule;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public SearchBoxAccountModule getAccountModule() {
        return this.accountModule;
    }

    public void setAccountModule(SearchBoxAccountModule accountModule) {
        this.accountModule = accountModule;
    }

    public AlipayOpenSearchBoxQueryResponseModel areaKeywordModule(SearchBoxAreaKeyWordModule areaKeywordModule) {
        this.areaKeywordModule = areaKeywordModule;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public SearchBoxAreaKeyWordModule getAreaKeywordModule() {
        return this.areaKeywordModule;
    }

    public void setAreaKeywordModule(SearchBoxAreaKeyWordModule areaKeywordModule) {
        this.areaKeywordModule = areaKeywordModule;
    }

    public AlipayOpenSearchBoxQueryResponseModel basicInfoModule(SearchBoxBasicInfoModule basicInfoModule) {
        this.basicInfoModule = basicInfoModule;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public SearchBoxBasicInfoModule getBasicInfoModule() {
        return this.basicInfoModule;
    }

    public void setBasicInfoModule(SearchBoxBasicInfoModule basicInfoModule) {
        this.basicInfoModule = basicInfoModule;
    }

    public AlipayOpenSearchBoxQueryResponseModel boxId(String boxId) {
        this.boxId = boxId;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="20220308000000128693", value="\u641c\u7d22\u76f4\u8fbe\u914d\u7f6eid")
    public String getBoxId() {
        return this.boxId;
    }

    public void setBoxId(String boxId) {
        this.boxId = boxId;
    }

    public AlipayOpenSearchBoxQueryResponseModel boxStatus(String boxStatus) {
        this.boxStatus = boxStatus;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="ONLINE", value="\u641c\u7d22\u76f4\u8fbe\u914d\u7f6e\u72b6\u6001\uff0cAUDIT-\u5ba1\u6838\u4e2d/ONLINE-\u5df2\u4e0a\u67b6/REJECT-\u9a73\u56de/OFFLINE-\u5df2\u4e0b\u67b6")
    public String getBoxStatus() {
        return this.boxStatus;
    }

    public void setBoxStatus(String boxStatus) {
        this.boxStatus = boxStatus;
    }

    public AlipayOpenSearchBoxQueryResponseModel businessDistrictModule(BoxBusinessDistrictModule businessDistrictModule) {
        this.businessDistrictModule = businessDistrictModule;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public BoxBusinessDistrictModule getBusinessDistrictModule() {
        return this.businessDistrictModule;
    }

    public void setBusinessDistrictModule(BoxBusinessDistrictModule businessDistrictModule) {
        this.businessDistrictModule = businessDistrictModule;
    }

    public AlipayOpenSearchBoxQueryResponseModel defaultKeywords(List<String> defaultKeywords) {
        this.defaultKeywords = defaultKeywords;
        return this;
    }

    public AlipayOpenSearchBoxQueryResponseModel addDefaultKeywordsItem(String defaultKeywordsItem) {
        if (this.defaultKeywords == null) {
            this.defaultKeywords = new ArrayList<String>();
        }
        this.defaultKeywords.add(defaultKeywordsItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(example="[\"\u9ed8\u8ba4\u89e6\u53d1\u8bcd\"]", value="\u641c\u7d22\u76f4\u8fbe\u9ed8\u8ba4\u89e6\u53d1\u8bcd\uff0c\u7531\u7cfb\u7edf\u751f\u6210\uff0c\u65e0\u6cd5\u4fee\u6539")
    public List<String> getDefaultKeywords() {
        return this.defaultKeywords;
    }

    public void setDefaultKeywords(List<String> defaultKeywords) {
        this.defaultKeywords = defaultKeywords;
    }

    public AlipayOpenSearchBoxQueryResponseModel keywordModule(SearchBoxKeyWordModule keywordModule) {
        this.keywordModule = keywordModule;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public SearchBoxKeyWordModule getKeywordModule() {
        return this.keywordModule;
    }

    public void setKeywordModule(SearchBoxKeyWordModule keywordModule) {
        this.keywordModule = keywordModule;
    }

    public AlipayOpenSearchBoxQueryResponseModel latestAuditImage(SearchBoxImageModule latestAuditImage) {
        this.latestAuditImage = latestAuditImage;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public SearchBoxImageModule getLatestAuditImage() {
        return this.latestAuditImage;
    }

    public void setLatestAuditImage(SearchBoxImageModule latestAuditImage) {
        this.latestAuditImage = latestAuditImage;
    }

    public AlipayOpenSearchBoxQueryResponseModel serviceModule(SearchBoxServiceModule serviceModule) {
        this.serviceModule = serviceModule;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public SearchBoxServiceModule getServiceModule() {
        return this.serviceModule;
    }

    public void setServiceModule(SearchBoxServiceModule serviceModule) {
        this.serviceModule = serviceModule;
    }

    public AlipayOpenSearchBoxQueryResponseModel validImage(SearchBoxImageModule validImage) {
        this.validImage = validImage;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public SearchBoxImageModule getValidImage() {
        return this.validImage;
    }

    public void setValidImage(SearchBoxImageModule validImage) {
        this.validImage = validImage;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AlipayOpenSearchBoxQueryResponseModel alipayOpenSearchBoxQueryResponseModel = (AlipayOpenSearchBoxQueryResponseModel)o;
        return Objects.equals(this.accountModule, alipayOpenSearchBoxQueryResponseModel.accountModule) && Objects.equals(this.areaKeywordModule, alipayOpenSearchBoxQueryResponseModel.areaKeywordModule) && Objects.equals(this.basicInfoModule, alipayOpenSearchBoxQueryResponseModel.basicInfoModule) && Objects.equals(this.boxId, alipayOpenSearchBoxQueryResponseModel.boxId) && Objects.equals(this.boxStatus, alipayOpenSearchBoxQueryResponseModel.boxStatus) && Objects.equals(this.businessDistrictModule, alipayOpenSearchBoxQueryResponseModel.businessDistrictModule) && Objects.equals(this.defaultKeywords, alipayOpenSearchBoxQueryResponseModel.defaultKeywords) && Objects.equals(this.keywordModule, alipayOpenSearchBoxQueryResponseModel.keywordModule) && Objects.equals(this.latestAuditImage, alipayOpenSearchBoxQueryResponseModel.latestAuditImage) && Objects.equals(this.serviceModule, alipayOpenSearchBoxQueryResponseModel.serviceModule) && Objects.equals(this.validImage, alipayOpenSearchBoxQueryResponseModel.validImage);
    }

    public int hashCode() {
        return Objects.hash(this.accountModule, this.areaKeywordModule, this.basicInfoModule, this.boxId, this.boxStatus, this.businessDistrictModule, this.defaultKeywords, this.keywordModule, this.latestAuditImage, this.serviceModule, this.validImage);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class AlipayOpenSearchBoxQueryResponseModel {\n");
        sb.append("    accountModule: ").append(this.toIndentedString(this.accountModule)).append("\n");
        sb.append("    areaKeywordModule: ").append(this.toIndentedString(this.areaKeywordModule)).append("\n");
        sb.append("    basicInfoModule: ").append(this.toIndentedString(this.basicInfoModule)).append("\n");
        sb.append("    boxId: ").append(this.toIndentedString(this.boxId)).append("\n");
        sb.append("    boxStatus: ").append(this.toIndentedString(this.boxStatus)).append("\n");
        sb.append("    businessDistrictModule: ").append(this.toIndentedString(this.businessDistrictModule)).append("\n");
        sb.append("    defaultKeywords: ").append(this.toIndentedString(this.defaultKeywords)).append("\n");
        sb.append("    keywordModule: ").append(this.toIndentedString(this.keywordModule)).append("\n");
        sb.append("    latestAuditImage: ").append(this.toIndentedString(this.latestAuditImage)).append("\n");
        sb.append("    serviceModule: ").append(this.toIndentedString(this.serviceModule)).append("\n");
        sb.append("    validImage: ").append(this.toIndentedString(this.validImage)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static void validateJsonObject(JsonObject jsonObj) throws IOException {
        if (jsonObj == null) {
            if (openapiRequiredFields.isEmpty()) {
                return;
            }
            throw new IllegalArgumentException(String.format("The required field(s) %s in AlipayOpenSearchBoxQueryResponseModel is not found in the empty JSON string", openapiRequiredFields.toString()));
        }
        Set entries = jsonObj.entrySet();
        for (Map.Entry entry : entries) {
            if (openapiFields.contains(entry.getKey())) continue;
            throw new IllegalArgumentException(String.format("The field `%s` in the JSON string is not defined in the `AlipayOpenSearchBoxQueryResponseModel` properties. JSON: %s", entry.getKey(), jsonObj.toString()));
        }
        if (jsonObj.getAsJsonObject(SERIALIZED_NAME_ACCOUNT_MODULE) != null) {
            SearchBoxAccountModule.validateJsonObject(jsonObj.getAsJsonObject(SERIALIZED_NAME_ACCOUNT_MODULE));
        }
        if (jsonObj.getAsJsonObject(SERIALIZED_NAME_AREA_KEYWORD_MODULE) != null) {
            SearchBoxAreaKeyWordModule.validateJsonObject(jsonObj.getAsJsonObject(SERIALIZED_NAME_AREA_KEYWORD_MODULE));
        }
        if (jsonObj.getAsJsonObject(SERIALIZED_NAME_BASIC_INFO_MODULE) != null) {
            SearchBoxBasicInfoModule.validateJsonObject(jsonObj.getAsJsonObject(SERIALIZED_NAME_BASIC_INFO_MODULE));
        }
        if (jsonObj.get(SERIALIZED_NAME_BOX_ID) != null && !jsonObj.get(SERIALIZED_NAME_BOX_ID).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `box_id` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_BOX_ID).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_BOX_STATUS) != null && !jsonObj.get(SERIALIZED_NAME_BOX_STATUS).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `box_status` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_BOX_STATUS).toString()));
        }
        if (jsonObj.getAsJsonObject(SERIALIZED_NAME_BUSINESS_DISTRICT_MODULE) != null) {
            BoxBusinessDistrictModule.validateJsonObject(jsonObj.getAsJsonObject(SERIALIZED_NAME_BUSINESS_DISTRICT_MODULE));
        }
        if (jsonObj.get(SERIALIZED_NAME_DEFAULT_KEYWORDS) != null && !jsonObj.get(SERIALIZED_NAME_DEFAULT_KEYWORDS).isJsonArray()) {
            throw new IllegalArgumentException(String.format("Expected the field `default_keywords` to be an array in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_DEFAULT_KEYWORDS).toString()));
        }
        if (jsonObj.getAsJsonObject(SERIALIZED_NAME_KEYWORD_MODULE) != null) {
            SearchBoxKeyWordModule.validateJsonObject(jsonObj.getAsJsonObject(SERIALIZED_NAME_KEYWORD_MODULE));
        }
        if (jsonObj.getAsJsonObject(SERIALIZED_NAME_LATEST_AUDIT_IMAGE) != null) {
            SearchBoxImageModule.validateJsonObject(jsonObj.getAsJsonObject(SERIALIZED_NAME_LATEST_AUDIT_IMAGE));
        }
        if (jsonObj.getAsJsonObject(SERIALIZED_NAME_SERVICE_MODULE) != null) {
            SearchBoxServiceModule.validateJsonObject(jsonObj.getAsJsonObject(SERIALIZED_NAME_SERVICE_MODULE));
        }
        if (jsonObj.getAsJsonObject(SERIALIZED_NAME_VALID_IMAGE) != null) {
            SearchBoxImageModule.validateJsonObject(jsonObj.getAsJsonObject(SERIALIZED_NAME_VALID_IMAGE));
        }
    }

    public static AlipayOpenSearchBoxQueryResponseModel fromJson(String jsonString) throws IOException {
        return (AlipayOpenSearchBoxQueryResponseModel)JSON.getGson().fromJson(jsonString, AlipayOpenSearchBoxQueryResponseModel.class);
    }

    public String toJson() {
        return JSON.getGson().toJson((Object)this);
    }

    static {
        openapiFields.add(SERIALIZED_NAME_ACCOUNT_MODULE);
        openapiFields.add(SERIALIZED_NAME_AREA_KEYWORD_MODULE);
        openapiFields.add(SERIALIZED_NAME_BASIC_INFO_MODULE);
        openapiFields.add(SERIALIZED_NAME_BOX_ID);
        openapiFields.add(SERIALIZED_NAME_BOX_STATUS);
        openapiFields.add(SERIALIZED_NAME_BUSINESS_DISTRICT_MODULE);
        openapiFields.add(SERIALIZED_NAME_DEFAULT_KEYWORDS);
        openapiFields.add(SERIALIZED_NAME_KEYWORD_MODULE);
        openapiFields.add(SERIALIZED_NAME_LATEST_AUDIT_IMAGE);
        openapiFields.add(SERIALIZED_NAME_SERVICE_MODULE);
        openapiFields.add(SERIALIZED_NAME_VALID_IMAGE);
        openapiRequiredFields = new HashSet();
    }

    public static class CustomTypeAdapterFactory
    implements TypeAdapterFactory {
        public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
            if (!AlipayOpenSearchBoxQueryResponseModel.class.isAssignableFrom(type.getRawType())) {
                return null;
            }
            final TypeAdapter elementAdapter = gson.getAdapter(JsonElement.class);
            final TypeAdapter thisAdapter = gson.getDelegateAdapter((TypeAdapterFactory)this, TypeToken.get(AlipayOpenSearchBoxQueryResponseModel.class));
            return new TypeAdapter<AlipayOpenSearchBoxQueryResponseModel>(){

                public void write(JsonWriter out, AlipayOpenSearchBoxQueryResponseModel value) throws IOException {
                    JsonObject obj = thisAdapter.toJsonTree((Object)value).getAsJsonObject();
                    elementAdapter.write(out, (Object)obj);
                }

                public AlipayOpenSearchBoxQueryResponseModel read(JsonReader in) throws IOException {
                    JsonObject jsonObj = ((JsonElement)elementAdapter.read(in)).getAsJsonObject();
                    AlipayOpenSearchBoxQueryResponseModel.validateJsonObject(jsonObj);
                    return (AlipayOpenSearchBoxQueryResponseModel)thisAdapter.fromJsonTree((JsonElement)jsonObj);
                }
            }.nullSafe();
        }
    }
}

