/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.v3.model;

import com.alipay.v3.JSON;
import com.alipay.v3.model.CardUserInfo;
import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.annotations.SerializedName;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import javax.annotation.Nullable;

public class AlipayMarketingCardQueryModel {
    public static final String SERIALIZED_NAME_CARD_USER_INFO = "card_user_info";
    @SerializedName(value="card_user_info")
    private CardUserInfo cardUserInfo;
    public static final String SERIALIZED_NAME_EXT_INFO = "ext_info";
    @SerializedName(value="ext_info")
    private String extInfo;
    public static final String SERIALIZED_NAME_TARGET_CARD_NO = "target_card_no";
    @SerializedName(value="target_card_no")
    private String targetCardNo;
    public static final String SERIALIZED_NAME_TARGET_CARD_NO_TYPE = "target_card_no_type";
    @SerializedName(value="target_card_no_type")
    private String targetCardNoType;
    public static HashSet<String> openapiFields = new HashSet();
    public static HashSet<String> openapiRequiredFields;

    public AlipayMarketingCardQueryModel cardUserInfo(CardUserInfo cardUserInfo) {
        this.cardUserInfo = cardUserInfo;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public CardUserInfo getCardUserInfo() {
        return this.cardUserInfo;
    }

    public void setCardUserInfo(CardUserInfo cardUserInfo) {
        this.cardUserInfo = cardUserInfo;
    }

    public AlipayMarketingCardQueryModel extInfo(String extInfo) {
        this.extInfo = extInfo;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="{\"key\":\"value\"}", value="\u6269\u5c55\u4fe1\u606f\uff0c\u6682\u65f6\u6ca1\u6709")
    public String getExtInfo() {
        return this.extInfo;
    }

    public void setExtInfo(String extInfo) {
        this.extInfo = extInfo;
    }

    public AlipayMarketingCardQueryModel targetCardNo(String targetCardNo) {
        this.targetCardNo = targetCardNo;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="0000001", value="\u64cd\u4f5c\u5361\u53f7\u3002 \u82e5target_card_no_type\u4e3a  BIZ_CARD\uff0c\u5219\u8be5\u503c\u4e3a\u4e1a\u52a1\u5361\u53f7\uff0c\u5373alipay.marketing.card.open(\u4f1a\u5458\u5361\u5f00\u5361)\u8fd4\u56de\u7ed3\u679c\u4e2d\u7684card_info#biz_card_no\u3002 \u82e5target_card_no_type\u4e3a D_QR_CODE \u6216D_BAR_CODE\uff0c\u5219\u8be5\u503c\u4e3a\u52a8\u6001\u7801\u503c\u3002 \u82e5target_card_no_type\u4e3a EXTERNAL_CARD\uff0c\u5219\u8be5\u503c\u4e3a\u5916\u90e8\u5361\u53f7\u3002")
    public String getTargetCardNo() {
        return this.targetCardNo;
    }

    public void setTargetCardNo(String targetCardNo) {
        this.targetCardNo = targetCardNo;
    }

    public AlipayMarketingCardQueryModel targetCardNoType(String targetCardNoType) {
        this.targetCardNoType = targetCardNoType;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="BIZ_CARD", value="\u5361\u53f7ID\u7c7b\u578b")
    public String getTargetCardNoType() {
        return this.targetCardNoType;
    }

    public void setTargetCardNoType(String targetCardNoType) {
        this.targetCardNoType = targetCardNoType;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AlipayMarketingCardQueryModel alipayMarketingCardQueryModel = (AlipayMarketingCardQueryModel)o;
        return Objects.equals(this.cardUserInfo, alipayMarketingCardQueryModel.cardUserInfo) && Objects.equals(this.extInfo, alipayMarketingCardQueryModel.extInfo) && Objects.equals(this.targetCardNo, alipayMarketingCardQueryModel.targetCardNo) && Objects.equals(this.targetCardNoType, alipayMarketingCardQueryModel.targetCardNoType);
    }

    public int hashCode() {
        return Objects.hash(this.cardUserInfo, this.extInfo, this.targetCardNo, this.targetCardNoType);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class AlipayMarketingCardQueryModel {\n");
        sb.append("    cardUserInfo: ").append(this.toIndentedString(this.cardUserInfo)).append("\n");
        sb.append("    extInfo: ").append(this.toIndentedString(this.extInfo)).append("\n");
        sb.append("    targetCardNo: ").append(this.toIndentedString(this.targetCardNo)).append("\n");
        sb.append("    targetCardNoType: ").append(this.toIndentedString(this.targetCardNoType)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static void validateJsonObject(JsonObject jsonObj) throws IOException {
        if (jsonObj == null) {
            if (openapiRequiredFields.isEmpty()) {
                return;
            }
            throw new IllegalArgumentException(String.format("The required field(s) %s in AlipayMarketingCardQueryModel is not found in the empty JSON string", openapiRequiredFields.toString()));
        }
        Set entries = jsonObj.entrySet();
        for (Map.Entry entry : entries) {
            if (openapiFields.contains(entry.getKey())) continue;
            throw new IllegalArgumentException(String.format("The field `%s` in the JSON string is not defined in the `AlipayMarketingCardQueryModel` properties. JSON: %s", entry.getKey(), jsonObj.toString()));
        }
        if (jsonObj.getAsJsonObject(SERIALIZED_NAME_CARD_USER_INFO) != null) {
            CardUserInfo.validateJsonObject(jsonObj.getAsJsonObject(SERIALIZED_NAME_CARD_USER_INFO));
        }
        if (jsonObj.get(SERIALIZED_NAME_EXT_INFO) != null && !jsonObj.get(SERIALIZED_NAME_EXT_INFO).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `ext_info` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_EXT_INFO).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_TARGET_CARD_NO) != null && !jsonObj.get(SERIALIZED_NAME_TARGET_CARD_NO).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `target_card_no` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_TARGET_CARD_NO).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_TARGET_CARD_NO_TYPE) != null && !jsonObj.get(SERIALIZED_NAME_TARGET_CARD_NO_TYPE).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `target_card_no_type` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_TARGET_CARD_NO_TYPE).toString()));
        }
    }

    public static AlipayMarketingCardQueryModel fromJson(String jsonString) throws IOException {
        return (AlipayMarketingCardQueryModel)JSON.getGson().fromJson(jsonString, AlipayMarketingCardQueryModel.class);
    }

    public String toJson() {
        return JSON.getGson().toJson((Object)this);
    }

    static {
        openapiFields.add(SERIALIZED_NAME_CARD_USER_INFO);
        openapiFields.add(SERIALIZED_NAME_EXT_INFO);
        openapiFields.add(SERIALIZED_NAME_TARGET_CARD_NO);
        openapiFields.add(SERIALIZED_NAME_TARGET_CARD_NO_TYPE);
        openapiRequiredFields = new HashSet();
    }

    public static class CustomTypeAdapterFactory
    implements TypeAdapterFactory {
        public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
            if (!AlipayMarketingCardQueryModel.class.isAssignableFrom(type.getRawType())) {
                return null;
            }
            final TypeAdapter elementAdapter = gson.getAdapter(JsonElement.class);
            final TypeAdapter thisAdapter = gson.getDelegateAdapter((TypeAdapterFactory)this, TypeToken.get(AlipayMarketingCardQueryModel.class));
            return new TypeAdapter<AlipayMarketingCardQueryModel>(){

                public void write(JsonWriter out, AlipayMarketingCardQueryModel value) throws IOException {
                    JsonObject obj = thisAdapter.toJsonTree((Object)value).getAsJsonObject();
                    elementAdapter.write(out, (Object)obj);
                }

                public AlipayMarketingCardQueryModel read(JsonReader in) throws IOException {
                    JsonObject jsonObj = ((JsonElement)elementAdapter.read(in)).getAsJsonObject();
                    AlipayMarketingCardQueryModel.validateJsonObject(jsonObj);
                    return (AlipayMarketingCardQueryModel)thisAdapter.fromJsonTree((JsonElement)jsonObj);
                }
            }.nullSafe();
        }
    }
}

