/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.v3.model;

import com.alipay.v3.JSON;
import com.alipay.v3.model.AuthInfo;
import com.alipay.v3.model.Participant;
import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.annotations.SerializedName;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import javax.annotation.Nullable;

public class AlipayFundTransPayModel {
    public static final String SERIALIZED_NAME_AUTH_INFO = "auth_info";
    @SerializedName(value="auth_info")
    private AuthInfo authInfo;
    public static final String SERIALIZED_NAME_BIZ_SCENE = "biz_scene";
    @SerializedName(value="biz_scene")
    private String bizScene;
    public static final String SERIALIZED_NAME_BUSINESS_PARAMS = "business_params";
    @SerializedName(value="business_params")
    private String businessParams;
    public static final String SERIALIZED_NAME_ORDER_TITLE = "order_title";
    @SerializedName(value="order_title")
    private String orderTitle;
    public static final String SERIALIZED_NAME_OUT_BIZ_NO = "out_biz_no";
    @SerializedName(value="out_biz_no")
    private String outBizNo;
    public static final String SERIALIZED_NAME_PASSBACK_PARAMS = "passback_params";
    @SerializedName(value="passback_params")
    private String passbackParams;
    public static final String SERIALIZED_NAME_PAYEE_INFO = "payee_info";
    @SerializedName(value="payee_info")
    private Participant payeeInfo;
    public static final String SERIALIZED_NAME_PAYER_INFO = "payer_info";
    @SerializedName(value="payer_info")
    private Participant payerInfo;
    public static final String SERIALIZED_NAME_PRODUCT_CODE = "product_code";
    @SerializedName(value="product_code")
    private String productCode;
    public static final String SERIALIZED_NAME_REFUND_TIME_EXPIRE = "refund_time_expire";
    @SerializedName(value="refund_time_expire")
    private String refundTimeExpire;
    public static final String SERIALIZED_NAME_REMARK = "remark";
    @SerializedName(value="remark")
    private String remark;
    public static final String SERIALIZED_NAME_TIME_EXPIRE = "time_expire";
    @SerializedName(value="time_expire")
    private String timeExpire;
    public static final String SERIALIZED_NAME_TRANS_AMOUNT = "trans_amount";
    @SerializedName(value="trans_amount")
    private String transAmount;
    public static HashSet<String> openapiFields = new HashSet();
    public static HashSet<String> openapiRequiredFields;

    public AlipayFundTransPayModel authInfo(AuthInfo authInfo) {
        this.authInfo = authInfo;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public AuthInfo getAuthInfo() {
        return this.authInfo;
    }

    public void setAuthInfo(AuthInfo authInfo) {
        this.authInfo = authInfo;
    }

    public AlipayFundTransPayModel bizScene(String bizScene) {
        this.bizScene = bizScene;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="PARTY_MEMBERSHIP_DUES", value="\u4e1a\u52a1\u573a\u666f\uff0c\u6bd4\u5982\u7fa4\u6536\u6b3e\u3001\u7ea2\u5305\u7b49")
    public String getBizScene() {
        return this.bizScene;
    }

    public void setBizScene(String bizScene) {
        this.bizScene = bizScene;
    }

    public AlipayFundTransPayModel businessParams(String businessParams) {
        this.businessParams = businessParams;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="{\"MERCHANT_PAYER_ID\":\"1234567890\",\"MERCHANT_PAYER_PHONE:\"15012341234\"}", value="JSON\u683c\u5f0f\uff0c\u4f20\u9012\u4e1a\u52a1\u6269\u5c55\u53c2\u6570\uff0c\u4f7f\u7528\u524d\u8bf7\u4e0e\u652f\u4ed8\u5b9d\u5de5\u7a0b\u5e08\u8054\u7cfb\uff01")
    public String getBusinessParams() {
        return this.businessParams;
    }

    public void setBusinessParams(String businessParams) {
        this.businessParams = businessParams;
    }

    public AlipayFundTransPayModel orderTitle(String orderTitle) {
        this.orderTitle = orderTitle;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="\u9489\u9489\u7ea2\u5305", value="\u8ba2\u5355\u7684\u6807\u9898\uff0c\u7528\u4e8e\u5728\u6536\u94f6\u53f0\u548c\u6d88\u8d39\u8bb0\u5f55\u5c55\u793a")
    public String getOrderTitle() {
        return this.orderTitle;
    }

    public void setOrderTitle(String orderTitle) {
        this.orderTitle = orderTitle;
    }

    public AlipayFundTransPayModel outBizNo(String outBizNo) {
        this.outBizNo = outBizNo;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="201806300001", value="\u5546\u6237\u7aef\u7684\u552f\u4e00\u8ba2\u5355\u53f7\uff0c\u5bf9\u4e8e\u540c\u4e00\u7b14\u8f6c\u8d26\u8bf7\u6c42\uff0c\u5546\u6237\u9700\u4fdd\u8bc1\u8be5\u8ba2\u5355\u53f7\u552f\u4e00\u3002")
    public String getOutBizNo() {
        return this.outBizNo;
    }

    public void setOutBizNo(String outBizNo) {
        this.outBizNo = outBizNo;
    }

    public AlipayFundTransPayModel passbackParams(String passbackParams) {
        this.passbackParams = passbackParams;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="{\"merchantBizType\":\"peerPay\"}", value="\u56de\u4f20\u53c2\u6570\uff0c\u5982\u679c\u8bf7\u6c42\u65f6\u4f20\u9012\u4e86\u8be5\u53c2\u6570\uff0c\u5219\u5f02\u6b65\u901a\u77e5\u5546\u6237\u65f6\u4f1a\u56de\u4f20\u8be5\u53c2\u6570\u3002")
    public String getPassbackParams() {
        return this.passbackParams;
    }

    public void setPassbackParams(String passbackParams) {
        this.passbackParams = passbackParams;
    }

    public AlipayFundTransPayModel payeeInfo(Participant payeeInfo) {
        this.payeeInfo = payeeInfo;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public Participant getPayeeInfo() {
        return this.payeeInfo;
    }

    public void setPayeeInfo(Participant payeeInfo) {
        this.payeeInfo = payeeInfo;
    }

    public AlipayFundTransPayModel payerInfo(Participant payerInfo) {
        this.payerInfo = payerInfo;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public Participant getPayerInfo() {
        return this.payerInfo;
    }

    public void setPayerInfo(Participant payerInfo) {
        this.payerInfo = payerInfo;
    }

    public AlipayFundTransPayModel productCode(String productCode) {
        this.productCode = productCode;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="STD_APP_TRANSFER", value="\u9500\u552e\u4ea7\u54c1\u7801\uff0c\u5546\u5bb6\u548c\u652f\u4ed8\u5b9d\u7b7e\u7ea6\u7684\u4ea7\u54c1\u7801")
    public String getProductCode() {
        return this.productCode;
    }

    public void setProductCode(String productCode) {
        this.productCode = productCode;
    }

    public AlipayFundTransPayModel refundTimeExpire(String refundTimeExpire) {
        this.refundTimeExpire = refundTimeExpire;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="2018-11-08 10:00", value="\u9000\u6b3e\u8d85\u65f6\u65f6\u95f4\uff0c\u683c\u5f0fyyyy-MM-dd HH:mm\u3002\u5230\u6307\u5b9a\u65f6\u95f4\u540e\uff0c\u7cfb\u7edf\u4f1a\u81ea\u52a8\u89e6\u53d1\u9000\u6b3e\uff0c\u5e76\u539f\u8def\u9000\u56de\u5230\u4ed8\u6b3e\u8d26\u6237\u3002\u5982\u679c\u6307\u5b9a\u4e86\u9000\u6b3e\u65f6\u95f4\uff0c\u5fc5\u987b\u65e9\u4e8e\u9500\u552e\u65b9\u6848\u91cc\u8bbe\u7f6e\u7684\u6700\u665a\u9000\u6b3e\u65f6\u95f4\u3002")
    public String getRefundTimeExpire() {
        return this.refundTimeExpire;
    }

    public void setRefundTimeExpire(String refundTimeExpire) {
        this.refundTimeExpire = refundTimeExpire;
    }

    public AlipayFundTransPayModel remark(String remark) {
        this.remark = remark;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="\u62a5\u9500\u4ed8\u6b3e", value="\u5907\u6ce8")
    public String getRemark() {
        return this.remark;
    }

    public void setRemark(String remark) {
        this.remark = remark;
    }

    public AlipayFundTransPayModel timeExpire(String timeExpire) {
        this.timeExpire = timeExpire;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="2018-03-23 19:15", value="\u7edd\u5bf9\u8d85\u65f6\u65f6\u95f4\uff0c\u683c\u5f0f\u4e3ayyyy-MM-dd HH:mm")
    public String getTimeExpire() {
        return this.timeExpire;
    }

    public void setTimeExpire(String timeExpire) {
        this.timeExpire = timeExpire;
    }

    public AlipayFundTransPayModel transAmount(String transAmount) {
        this.transAmount = transAmount;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="8.88", value="\u8ba2\u5355\u603b\u91d1\u989d\uff0c\u5355\u4f4d\u4e3a\u5143\uff0c\u7cbe\u786e\u5230\u5c0f\u6570\u70b9\u540e\u4e24\u4f4d\uff0c\u53d6\u503c\u8303\u56f4[0.01,100000000]")
    public String getTransAmount() {
        return this.transAmount;
    }

    public void setTransAmount(String transAmount) {
        this.transAmount = transAmount;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AlipayFundTransPayModel alipayFundTransPayModel = (AlipayFundTransPayModel)o;
        return Objects.equals(this.authInfo, alipayFundTransPayModel.authInfo) && Objects.equals(this.bizScene, alipayFundTransPayModel.bizScene) && Objects.equals(this.businessParams, alipayFundTransPayModel.businessParams) && Objects.equals(this.orderTitle, alipayFundTransPayModel.orderTitle) && Objects.equals(this.outBizNo, alipayFundTransPayModel.outBizNo) && Objects.equals(this.passbackParams, alipayFundTransPayModel.passbackParams) && Objects.equals(this.payeeInfo, alipayFundTransPayModel.payeeInfo) && Objects.equals(this.payerInfo, alipayFundTransPayModel.payerInfo) && Objects.equals(this.productCode, alipayFundTransPayModel.productCode) && Objects.equals(this.refundTimeExpire, alipayFundTransPayModel.refundTimeExpire) && Objects.equals(this.remark, alipayFundTransPayModel.remark) && Objects.equals(this.timeExpire, alipayFundTransPayModel.timeExpire) && Objects.equals(this.transAmount, alipayFundTransPayModel.transAmount);
    }

    public int hashCode() {
        return Objects.hash(this.authInfo, this.bizScene, this.businessParams, this.orderTitle, this.outBizNo, this.passbackParams, this.payeeInfo, this.payerInfo, this.productCode, this.refundTimeExpire, this.remark, this.timeExpire, this.transAmount);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class AlipayFundTransPayModel {\n");
        sb.append("    authInfo: ").append(this.toIndentedString(this.authInfo)).append("\n");
        sb.append("    bizScene: ").append(this.toIndentedString(this.bizScene)).append("\n");
        sb.append("    businessParams: ").append(this.toIndentedString(this.businessParams)).append("\n");
        sb.append("    orderTitle: ").append(this.toIndentedString(this.orderTitle)).append("\n");
        sb.append("    outBizNo: ").append(this.toIndentedString(this.outBizNo)).append("\n");
        sb.append("    passbackParams: ").append(this.toIndentedString(this.passbackParams)).append("\n");
        sb.append("    payeeInfo: ").append(this.toIndentedString(this.payeeInfo)).append("\n");
        sb.append("    payerInfo: ").append(this.toIndentedString(this.payerInfo)).append("\n");
        sb.append("    productCode: ").append(this.toIndentedString(this.productCode)).append("\n");
        sb.append("    refundTimeExpire: ").append(this.toIndentedString(this.refundTimeExpire)).append("\n");
        sb.append("    remark: ").append(this.toIndentedString(this.remark)).append("\n");
        sb.append("    timeExpire: ").append(this.toIndentedString(this.timeExpire)).append("\n");
        sb.append("    transAmount: ").append(this.toIndentedString(this.transAmount)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static void validateJsonObject(JsonObject jsonObj) throws IOException {
        if (jsonObj == null) {
            if (openapiRequiredFields.isEmpty()) {
                return;
            }
            throw new IllegalArgumentException(String.format("The required field(s) %s in AlipayFundTransPayModel is not found in the empty JSON string", openapiRequiredFields.toString()));
        }
        Set entries = jsonObj.entrySet();
        for (Map.Entry entry : entries) {
            if (openapiFields.contains(entry.getKey())) continue;
            throw new IllegalArgumentException(String.format("The field `%s` in the JSON string is not defined in the `AlipayFundTransPayModel` properties. JSON: %s", entry.getKey(), jsonObj.toString()));
        }
        if (jsonObj.getAsJsonObject(SERIALIZED_NAME_AUTH_INFO) != null) {
            AuthInfo.validateJsonObject(jsonObj.getAsJsonObject(SERIALIZED_NAME_AUTH_INFO));
        }
        if (jsonObj.get(SERIALIZED_NAME_BIZ_SCENE) != null && !jsonObj.get(SERIALIZED_NAME_BIZ_SCENE).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `biz_scene` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_BIZ_SCENE).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_BUSINESS_PARAMS) != null && !jsonObj.get(SERIALIZED_NAME_BUSINESS_PARAMS).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `business_params` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_BUSINESS_PARAMS).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_ORDER_TITLE) != null && !jsonObj.get(SERIALIZED_NAME_ORDER_TITLE).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `order_title` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_ORDER_TITLE).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_OUT_BIZ_NO) != null && !jsonObj.get(SERIALIZED_NAME_OUT_BIZ_NO).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `out_biz_no` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_OUT_BIZ_NO).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_PASSBACK_PARAMS) != null && !jsonObj.get(SERIALIZED_NAME_PASSBACK_PARAMS).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `passback_params` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_PASSBACK_PARAMS).toString()));
        }
        if (jsonObj.getAsJsonObject(SERIALIZED_NAME_PAYEE_INFO) != null) {
            Participant.validateJsonObject(jsonObj.getAsJsonObject(SERIALIZED_NAME_PAYEE_INFO));
        }
        if (jsonObj.getAsJsonObject(SERIALIZED_NAME_PAYER_INFO) != null) {
            Participant.validateJsonObject(jsonObj.getAsJsonObject(SERIALIZED_NAME_PAYER_INFO));
        }
        if (jsonObj.get(SERIALIZED_NAME_PRODUCT_CODE) != null && !jsonObj.get(SERIALIZED_NAME_PRODUCT_CODE).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `product_code` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_PRODUCT_CODE).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_REFUND_TIME_EXPIRE) != null && !jsonObj.get(SERIALIZED_NAME_REFUND_TIME_EXPIRE).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `refund_time_expire` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_REFUND_TIME_EXPIRE).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_REMARK) != null && !jsonObj.get(SERIALIZED_NAME_REMARK).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `remark` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_REMARK).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_TIME_EXPIRE) != null && !jsonObj.get(SERIALIZED_NAME_TIME_EXPIRE).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `time_expire` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_TIME_EXPIRE).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_TRANS_AMOUNT) != null && !jsonObj.get(SERIALIZED_NAME_TRANS_AMOUNT).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `trans_amount` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_TRANS_AMOUNT).toString()));
        }
    }

    public static AlipayFundTransPayModel fromJson(String jsonString) throws IOException {
        return (AlipayFundTransPayModel)JSON.getGson().fromJson(jsonString, AlipayFundTransPayModel.class);
    }

    public String toJson() {
        return JSON.getGson().toJson((Object)this);
    }

    static {
        openapiFields.add(SERIALIZED_NAME_AUTH_INFO);
        openapiFields.add(SERIALIZED_NAME_BIZ_SCENE);
        openapiFields.add(SERIALIZED_NAME_BUSINESS_PARAMS);
        openapiFields.add(SERIALIZED_NAME_ORDER_TITLE);
        openapiFields.add(SERIALIZED_NAME_OUT_BIZ_NO);
        openapiFields.add(SERIALIZED_NAME_PASSBACK_PARAMS);
        openapiFields.add(SERIALIZED_NAME_PAYEE_INFO);
        openapiFields.add(SERIALIZED_NAME_PAYER_INFO);
        openapiFields.add(SERIALIZED_NAME_PRODUCT_CODE);
        openapiFields.add(SERIALIZED_NAME_REFUND_TIME_EXPIRE);
        openapiFields.add(SERIALIZED_NAME_REMARK);
        openapiFields.add(SERIALIZED_NAME_TIME_EXPIRE);
        openapiFields.add(SERIALIZED_NAME_TRANS_AMOUNT);
        openapiRequiredFields = new HashSet();
    }

    public static class CustomTypeAdapterFactory
    implements TypeAdapterFactory {
        public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
            if (!AlipayFundTransPayModel.class.isAssignableFrom(type.getRawType())) {
                return null;
            }
            final TypeAdapter elementAdapter = gson.getAdapter(JsonElement.class);
            final TypeAdapter thisAdapter = gson.getDelegateAdapter((TypeAdapterFactory)this, TypeToken.get(AlipayFundTransPayModel.class));
            return new TypeAdapter<AlipayFundTransPayModel>(){

                public void write(JsonWriter out, AlipayFundTransPayModel value) throws IOException {
                    JsonObject obj = thisAdapter.toJsonTree((Object)value).getAsJsonObject();
                    elementAdapter.write(out, (Object)obj);
                }

                public AlipayFundTransPayModel read(JsonReader in) throws IOException {
                    JsonObject jsonObj = ((JsonElement)elementAdapter.read(in)).getAsJsonObject();
                    AlipayFundTransPayModel.validateJsonObject(jsonObj);
                    return (AlipayFundTransPayModel)thisAdapter.fromJsonTree((JsonElement)jsonObj);
                }
            }.nullSafe();
        }
    }
}

