/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.v3.model;

import com.alipay.v3.JSON;
import com.alipay.v3.model.PostPayment;
import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.annotations.SerializedName;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import javax.annotation.Nullable;

public class AlipayFundAuthOrderFreezeModel {
    public static final String SERIALIZED_NAME_AMOUNT = "amount";
    @SerializedName(value="amount")
    private String amount;
    public static final String SERIALIZED_NAME_AUTH_CODE = "auth_code";
    @SerializedName(value="auth_code")
    private String authCode;
    public static final String SERIALIZED_NAME_AUTH_CODE_TYPE = "auth_code_type";
    @SerializedName(value="auth_code_type")
    private String authCodeType;
    public static final String SERIALIZED_NAME_BUSINESS_PARAMS = "business_params";
    @SerializedName(value="business_params")
    private String businessParams;
    public static final String SERIALIZED_NAME_DEPOSIT_PRODUCT_MODE = "deposit_product_mode";
    @SerializedName(value="deposit_product_mode")
    private String depositProductMode;
    public static final String SERIALIZED_NAME_DISABLE_PAY_CHANNELS = "disable_pay_channels";
    @SerializedName(value="disable_pay_channels")
    private String disablePayChannels;
    public static final String SERIALIZED_NAME_ENABLE_PAY_CHANNELS = "enable_pay_channels";
    @SerializedName(value="enable_pay_channels")
    private String enablePayChannels;
    public static final String SERIALIZED_NAME_EXTRA_PARAM = "extra_param";
    @SerializedName(value="extra_param")
    private String extraParam;
    public static final String SERIALIZED_NAME_IDENTITY_PARAMS = "identity_params";
    @SerializedName(value="identity_params")
    private String identityParams;
    public static final String SERIALIZED_NAME_NOTIFY_URL = "notify_url";
    @SerializedName(value="notify_url")
    private String notifyUrl;
    public static final String SERIALIZED_NAME_ORDER_TITLE = "order_title";
    @SerializedName(value="order_title")
    private String orderTitle;
    public static final String SERIALIZED_NAME_OUT_ORDER_NO = "out_order_no";
    @SerializedName(value="out_order_no")
    private String outOrderNo;
    public static final String SERIALIZED_NAME_OUT_REQUEST_NO = "out_request_no";
    @SerializedName(value="out_request_no")
    private String outRequestNo;
    public static final String SERIALIZED_NAME_PAY_TIMEOUT = "pay_timeout";
    @SerializedName(value="pay_timeout")
    private String payTimeout;
    public static final String SERIALIZED_NAME_PAYEE_LOGON_ID = "payee_logon_id";
    @SerializedName(value="payee_logon_id")
    private String payeeLogonId;
    public static final String SERIALIZED_NAME_PAYEE_USER_ID = "payee_user_id";
    @SerializedName(value="payee_user_id")
    private String payeeUserId;
    public static final String SERIALIZED_NAME_POST_PAYMENTS = "post_payments";
    @SerializedName(value="post_payments")
    private List<PostPayment> postPayments = null;
    public static final String SERIALIZED_NAME_PRODUCT_CODE = "product_code";
    @SerializedName(value="product_code")
    private String productCode;
    public static final String SERIALIZED_NAME_SCENE_CODE = "scene_code";
    @SerializedName(value="scene_code")
    private String sceneCode;
    public static final String SERIALIZED_NAME_SETTLE_CURRENCY = "settle_currency";
    @SerializedName(value="settle_currency")
    private String settleCurrency;
    public static final String SERIALIZED_NAME_TERMINAL_PARAMS = "terminal_params";
    @SerializedName(value="terminal_params")
    private String terminalParams;
    public static final String SERIALIZED_NAME_TIMEOUT_EXPRESS = "timeout_express";
    @SerializedName(value="timeout_express")
    private String timeoutExpress;
    public static final String SERIALIZED_NAME_TRANS_CURRENCY = "trans_currency";
    @SerializedName(value="trans_currency")
    private String transCurrency;
    public static HashSet<String> openapiFields = new HashSet();
    public static HashSet<String> openapiRequiredFields;

    public AlipayFundAuthOrderFreezeModel amount(String amount) {
        this.amount = amount;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="0.01", value="\u9700\u8981\u51bb\u7ed3\u7684\u91d1\u989d\uff0c\u5355\u4f4d\u4e3a\uff1a\u5143\uff08\u4eba\u6c11\u5e01\uff09\uff0c\u7cbe\u786e\u5230\u5c0f\u6570\u70b9\u540e\u4e24\u4f4d\u3002 \u53d6\u503c\u8303\u56f4\uff1a[0.01,100000000.00]")
    public String getAmount() {
        return this.amount;
    }

    public void setAmount(String amount) {
        this.amount = amount;
    }

    public AlipayFundAuthOrderFreezeModel authCode(String authCode) {
        this.authCode = authCode;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="\u4ed8\u6b3e\u7801\u573a\u666f\uff1a28763443825664394\uff0c \u5237\u8138\u573a\u666f1)\u793a\u4f8b\uff1afp1394da8bfc3e299a2128b8bda17456h84", value="\u7528\u6237\u4ed8\u6b3e\u7801\u3002 1.\u6761\u7801\u573a\u666f\uff1a25~30\u5f00\u5934\u7684\u957f\u5ea6\u4e3a16~24\u4f4d\u7684\u6570\u5b57\uff0c\u5b9e\u9645\u5b57\u7b26\u4e32\u957f\u5ea6\u4ee5\u5f00\u53d1\u8005\u83b7\u53d6\u7684\u4ed8\u6b3e\u7801\u957f\u5ea6\u4e3a\u51c6\uff1b 2.\u5237\u8138\u573a\u666f\uff1a 1\uff09fp\u5f00\u5934\u768435\u4f4d\u5b57\u7b26\u4e32\uff1b 2\uff09300-700\u5b57\u7b26\u7684\u968f\u673a\u5b57\u7b26\u4e32\uff1b \u6ce8\uff1a\u5237\u8138\u573a\u666f\u8003\u8651\u5230\u672a\u6765\u53ef\u80fd\u62d3\u5c55\u66f4\u591a\u683c\u5f0f\uff0c\u5efa\u8bae\u5916\u56f4\u4e0d\u5fc5\u505a\u89c4\u5219\u62e6\u622a\uff0c\u7531\u652f\u4ed8\u5b9d\u7edf\u4e00\u505a\u6709\u6548\u6027\u6821\u9a8c")
    public String getAuthCode() {
        return this.authCode;
    }

    public void setAuthCode(String authCode) {
        this.authCode = authCode;
    }

    public AlipayFundAuthOrderFreezeModel authCodeType(String authCodeType) {
        this.authCodeType = authCodeType;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="bar_code", value="\u4ed8\u6b3e\u7801\u7c7b\u578b\u3002 1.\u6761\u7801\u573a\u666f\uff1abar_code 2.\u5237\u8138\u573a\u666f\uff1asecurity_code")
    public String getAuthCodeType() {
        return this.authCodeType;
    }

    public void setAuthCodeType(String authCodeType) {
        this.authCodeType = authCodeType;
    }

    public AlipayFundAuthOrderFreezeModel businessParams(String businessParams) {
        this.businessParams = businessParams;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="{\"outRiskInfo\":\"{\\\"mcCreateTradeTime\\\":\\\"2022-03-11 12:46:09\\\",\\\"extraAccountCertnoLastSix\\\":\\\"000011\\\",\\\"mobileOperatingPlatform\\\":\\\"ios\\\",\\\"sysVersion\\\":\\\"15.4.2\\\",\\\"mcCreateTradeIp\\\":\\\"11.110.111.43\\\"}\"}", value="\u4e1a\u52a1\u53c2\u6570\uff0c\u5982\u98ce\u63a7\u53c2\u6570outRiskInfo\u7b49\u3002")
    public String getBusinessParams() {
        return this.businessParams;
    }

    public void setBusinessParams(String businessParams) {
        this.businessParams = businessParams;
    }

    public AlipayFundAuthOrderFreezeModel depositProductMode(String depositProductMode) {
        this.depositProductMode = depositProductMode;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="POSTPAY", value="\u514d\u62bc\u53d7\u7406\u53f0\u6a21\u5f0f\uff0c\u4f7f\u7528\u514d\u62bc\u4ea7\u54c1\u5fc5\u4f20\u8be5\u5b57\u6bb5\u3002\u6839\u636e\u514d\u62bc\u4e0d\u540c\u4e1a\u52a1\u6a21\u5f0f\u5c06\u5f00\u901a\u53d7\u7406\u53f0\u533a\u5206\u4e09\u79cd\u6a21\u5f0f\uff0c\u5546\u5bb6\u53ef\u6839\u636e\u8c03\u7528\u9884\u6388\u6743\u51bb\u7ed3\u63a5\u53e3\u4f20\u5165\u7684\u53c2\u6570\u51b3\u5b9a\u8be5\u7b14\u514d\u62bc\u8ba2\u5355\u9009\u62e9\u54ea\u79cd\u53d7\u7406\u53f0\u6a21\u5f0f\u3002\u4e0d\u540c\u53d7\u7406\u53f0\u6a21\u5f0f\u9700\u8981\u4f20\u5165\u4e0d\u540c\u53c2\u6570\uff0c\u5176\u4e2d\uff1aPOSTPAY \u8868\u793a\u540e\u4ed8\u91d1\u989d\u5df2\u77e5\uff0cPOSTPAY_UNCERTAIN \u8868\u793a\u540e\u4ed8\u91d1\u989d\u672a\u77e5\uff0cDEPOSIT_ONLY \u8868\u793a\u7eaf\u514d\u62bc\u3002 \u5177\u4f53\u89c4\u5219\u53c2\u8003\u6587\u6863\uff1ahttps://opendocs.alipay.com/b/08tf3t?pathHash=d67d7545")
    public String getDepositProductMode() {
        return this.depositProductMode;
    }

    public void setDepositProductMode(String depositProductMode) {
        this.depositProductMode = depositProductMode;
    }

    public AlipayFundAuthOrderFreezeModel disablePayChannels(String disablePayChannels) {
        this.disablePayChannels = disablePayChannels;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="[{\"payChannelType\":\"OPTIMIZED_MOTO\"},{\"payChannelType\":\"BIGAMOUNT_CREDIT_CARTOON\"}]", value="\u65e0\u7279\u6b8a\u9700\u8981\u8bf7\u52ff\u4f20\u5165\uff1b\u5546\u6237\u53ef\u7528\u8be5\u53c2\u6570\u7981\u7528\u652f\u4ed8\u6e20\u9053\u3002 \u4f20\u5165\u540e\u7528\u6237\u4e0d\u53ef\u4f7f\u7528\u5217\u8868\u4e2d\u7684\u6e20\u9053\u8fdb\u884c\u652f\u4ed8\uff0c\u76ee\u524d\u652f\u6301\u4e24\u79cd\u7981\u7528\u6e20\u9053\uff1a\u4fe1\u7528\u5361\u5feb\u6377\uff08OPTIMIZED_MOTO\uff09\u3001\u4fe1\u7528\u5361\u5361\u901a\uff08BIGAMOUNT_CREDIT_CARTOON\uff09\u3002\u4e0e\u53ef\u7528\u652f\u4ed8\u6e20\u9053\u4e0d\u80fd\u540c\u65f6\u4f20\u5165")
    public String getDisablePayChannels() {
        return this.disablePayChannels;
    }

    public void setDisablePayChannels(String disablePayChannels) {
        this.disablePayChannels = disablePayChannels;
    }

    public AlipayFundAuthOrderFreezeModel enablePayChannels(String enablePayChannels) {
        this.enablePayChannels = enablePayChannels;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="[{\"payChannelType\":\"PCREDIT_PAY\"},{\"payChannelType\":\"MONEY_FUND\"}]", value="\u65e0\u7279\u6b8a\u9700\u8981\u8bf7\u52ff\u4f20\u5165\uff1b\u5546\u6237\u53ef\u7528\u8be5\u53c2\u6570\u6307\u5b9a\u652f\u4ed8\u6e20\u9053\u3002 \u4f20\u5165\u540e\u7528\u6237\u4ec5\u80fd\u4f7f\u7528\u5217\u8868\u4e2d\u7684\u6e20\u9053\u8fdb\u884c\u652f\u4ed8\uff0c\u76ee\u524d\u652f\u6301\u4e09\u79cd\u6e20\u9053\uff0c\u4f59\u989d\u5b9d\uff08MONEY_FUND\uff09\u3001\u82b1\u5457\uff08PCREDIT_PAY\uff09\u4ee5\u53ca\u829d\u9ebb\u4fe1\u7528\uff08CREDITZHIMA\uff09\u3002\u4e0e\u7981\u7528\u652f\u4ed8\u6e20\u9053\u4e0d\u53ef\u540c\u65f6\u4f20\u5165")
    public String getEnablePayChannels() {
        return this.enablePayChannels;
    }

    public void setEnablePayChannels(String enablePayChannels) {
        this.enablePayChannels = enablePayChannels;
    }

    public AlipayFundAuthOrderFreezeModel extraParam(String extraParam) {
        this.extraParam = extraParam;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="{\"category\":\"CHARGE_PILE_CAR\",\"serviceId\":\"2020042800000000000001450466\"}", value="\u4e1a\u52a1\u6269\u5c55\u53c2\u6570\uff0c\u7528\u4e8e\u7279\u5b9a\u4e1a\u52a1\u4fe1\u606f\u7684\u4f20\u9012\uff0cjson\u683c\u5f0f\uff0ckey\u503c\u5982\u4e0b\uff1a 1\u3001category\uff0c\u4fe1\u7528\u7c7b\u76ee\uff0c\u4fe1\u7528\u9884\u6388\u6743\u573a\u666f\u5fc5\u4f20\uff0c\u5177\u4f53\u7c7b\u76ee\u4fe1\u606f\u89c1https://opendocs.alipay.com/open/10719 2\u3001serviceId\uff0c\u4fe1\u7528\u670d\u52a1id\uff0c\u4fe1\u7528\u9884\u6388\u6743\u573a\u666f\u5fc5\u4f20\uff0c\u9700\u8981\u8054\u7cfb\u829d\u9ebb\u5ba2\u670d\u83b7\u53d6\uff0chttps://cshall.alipay.com/enterprise/index.htm?sourceId=pc_zhima\uff08\u53f3\u4e0a\u89d2\u201c\u6709\u95ee\u9898\u70b9\u6211\u201d\u8fdb\u5165\u54a8\u8be2\uff09 3\u3001creditExtInfo\uff0c\u4fe1\u7528\u53c2\u6570\uff0c\u5982\u6709\u9700\u8981\u8bf7\u4e0e\u829d\u9ebb\u7ea6\u5b9a\u540e\u4f20\u5165\uff0c\u4fe1\u7528\u670d\u52a1\u8bf4\u660e\u89c1https://opendocs.alipay.com/open/11157/qlsxya")
    public String getExtraParam() {
        return this.extraParam;
    }

    public void setExtraParam(String extraParam) {
        this.extraParam = extraParam;
    }

    public AlipayFundAuthOrderFreezeModel identityParams(String identityParams) {
        this.identityParams = identityParams;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="{\"identity_hash\":\"ABCDEFDxxxxxx\",\"alipay_user_id\":\"2088xxx\"}", value="\u7528\u6237\u5b9e\u540d\u4fe1\u606f\u53c2\u6570\uff0c\u5305\u542b\uff1a\u59d3\u540d+\u8eab\u4efd\u8bc1\u53f7\u7684hash\u503c\u3001\u6307\u5b9a\u7528\u6237\u7684uid\u3002\u5546\u6237\u4f20\u5165\u7528\u6237\u5b9e\u540d\u4fe1\u606f\u53c2\u6570\uff0c\u652f\u4ed8\u5b9d\u4f1a\u5bf9\u6bd4\u7528\u6237\u5728\u652f\u4ed8\u5b9d\u7aef\u7684\u5b9e\u540d\u4fe1\u606f\u3002 \u59d3\u540d+\u8eab\u4efd\u8bc1\u53f7hash\u503c\u4f7f\u7528SHA256\u6458\u8981\u65b9\u5f0f\u4e0eUTF8\u7f16\u7801,\u8fd4\u56de\u5341\u516d\u8fdb\u5236\u7684\u5b57\u7b26\u4e32\u3002 identity_hash\u548calipay_user_id\u90fd\u662f\u53ef\u9009\u7684\uff0c\u5982\u679c\u4e24\u4e2a\u90fd\u4f20\uff0c\u5219\u4f1a\u5148\u6821\u9a8cidentity_hash\uff0c\u7136\u540e\u6821\u9a8calipay_user_id\u3002\u5176\u4e2didentity_hash\u7684\u5f85\u52a0\u5bc6\u5b57\u6837\u5982\"\u5f20\u4e094566498798498498498498\"")
    public String getIdentityParams() {
        return this.identityParams;
    }

    public void setIdentityParams(String identityParams) {
        this.identityParams = identityParams;
    }

    public AlipayFundAuthOrderFreezeModel notifyUrl(String notifyUrl) {
        this.notifyUrl = notifyUrl;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="\u901a\u77e5\u5730\u5740")
    public String getNotifyUrl() {
        return this.notifyUrl;
    }

    public void setNotifyUrl(String notifyUrl) {
        this.notifyUrl = notifyUrl;
    }

    public AlipayFundAuthOrderFreezeModel orderTitle(String orderTitle) {
        this.orderTitle = orderTitle;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="XX\u79df\u8f66\u62bc\u91d1", value="\u8ba2\u5355\u6807\u9898\u3002 \u4e1a\u52a1\u8ba2\u5355\u7684\u7b80\u5355\u63cf\u8ff0\uff0c\u5982\u5546\u54c1\u540d\u79f0\u7b49")
    public String getOrderTitle() {
        return this.orderTitle;
    }

    public void setOrderTitle(String orderTitle) {
        this.orderTitle = orderTitle;
    }

    public AlipayFundAuthOrderFreezeModel outOrderNo(String outOrderNo) {
        this.outOrderNo = outOrderNo;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="8077735255938023", value="\u5546\u6237\u6388\u6743\u8d44\u91d1\u8ba2\u5355\u53f7\u3002 \u5546\u5bb6\u81ea\u5b9a\u4e49\u9700\u4fdd\u8bc1\u5728\u5546\u6237\u7aef\u4e0d\u91cd\u590d\u3002\u4ec5\u652f\u6301\u5b57\u6bcd\u3001\u6570\u5b57\u3001\u4e0b\u5212\u7ebf\u3002")
    public String getOutOrderNo() {
        return this.outOrderNo;
    }

    public void setOutOrderNo(String outOrderNo) {
        this.outOrderNo = outOrderNo;
    }

    public AlipayFundAuthOrderFreezeModel outRequestNo(String outRequestNo) {
        this.outRequestNo = outRequestNo;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="8077735255938032", value="\u5546\u6237\u672c\u6b21\u8d44\u91d1\u64cd\u4f5c\u7684\u8bf7\u6c42\u6d41\u6c34\u53f7\uff0c\u7528\u4e8e\u6807\u793a\u8bf7\u6c42\u6d41\u6c34\u7684\u552f\u4e00\u6027\u3002 \u53ef\u4e0eout_order_no\u76f8\u540c\uff0c\u4ec5\u652f\u6301\u5b57\u6bcd\u3001\u6570\u5b57\u3001\u4e0b\u5212\u7ebf\u3002")
    public String getOutRequestNo() {
        return this.outRequestNo;
    }

    public void setOutRequestNo(String outRequestNo) {
        this.outRequestNo = outRequestNo;
    }

    public AlipayFundAuthOrderFreezeModel payTimeout(String payTimeout) {
        this.payTimeout = payTimeout;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="2d", value="\u9884\u6388\u6743\u8ba2\u5355\u76f8\u5bf9\u8d85\u65f6\u65f6\u95f4\uff0c\u4ece\u5546\u6237\u8bf7\u6c42\u65f6\u95f4\u5f00\u59cb\u8ba1\u7b97\u3002 \u9884\u6388\u6743\u8ba2\u5355\u5141\u8bb8\u7684\u6700\u665a\u6388\u6743\u65f6\u95f4\uff0c\u903e\u671f\u5c06\u5173\u95ed\u8be5\u7b14\u8ba2\u5355\u3002\u53d6\u503c\u8303\u56f4\uff1a1m\uff5e15d\u3002m-\u5206\u949f\uff0ch-\u5c0f\u65f6\uff0cd-\u5929\u3002 \u8be5\u53c2\u6570\u6570\u503c\u4e0d\u63a5\u53d7\u5c0f\u6570\u70b9\uff0c \u5982 1.5h\uff0c\u53ef\u8f6c\u6362\u4e3a90m\u3002 \u9ed8\u8ba4\u4e3a15m\u3002")
    public String getPayTimeout() {
        return this.payTimeout;
    }

    public void setPayTimeout(String payTimeout) {
        this.payTimeout = payTimeout;
    }

    public AlipayFundAuthOrderFreezeModel payeeLogonId(String payeeLogonId) {
        this.payeeLogonId = payeeLogonId;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="159****5620", value="\u6536\u6b3e\u8d26\u6237\u7684\u652f\u4ed8\u5b9d\u767b\u5f55\u53f7\uff08email\u6216\u624b\u673a\u53f7\uff09\u3002 \u5982\u679c\u4f20\u5165\u5219\u4f1a\u6821\u9a8c\u8be5\u767b\u5f55\u53f7\u5bf9\u5e94\u7684\u8d26\u53f7\u662f\u5426\u5177\u5907\u5f53\u524d\u5546\u6237\u6536\u6b3e\u6743\u9650\uff0c\u5982\u679c\u5546\u6237\u5e0c\u671b\u7528\u6237\u80fd\u591f\u4f7f\u7528\u82b1\u5457\uff0c\u5219\u7528\u6237\u53f7(payee_user_id)\u548c\u767b\u5f55\u53f7(payee_logon_id)\u4e24\u8005\u5fc5\u987b\u4f20\u5165\u5176\u4e00")
    public String getPayeeLogonId() {
        return this.payeeLogonId;
    }

    public void setPayeeLogonId(String payeeLogonId) {
        this.payeeLogonId = payeeLogonId;
    }

    public AlipayFundAuthOrderFreezeModel payeeUserId(String payeeUserId) {
        this.payeeUserId = payeeUserId;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="2088102000275795", value="\u6536\u6b3e\u8d26\u6237\u7684\u652f\u4ed8\u5b9d\u7528\u6237\u53f7\u3002 \u4ee52088\u5f00\u5934\u768416\u4f4d\u7eaf\u6570\u5b57\uff0c\u5982\u679c\u4f20\u5165\u5219\u4f1a\u6821\u9a8c\u8be5\u8d26\u53f7\u662f\u5426\u5177\u5907\u5f53\u524d\u5546\u6237\u6536\u6b3e\u6743\u9650\uff0c\u5982\u679c\u5546\u6237\u5e0c\u671b\u7528\u6237\u80fd\u591f\u4f7f\u7528\u82b1\u5457\uff0c\u5219\u7528\u6237\u53f7(payee_user_id)\u548c\u767b\u5f55\u53f7(payee_logon_id)\u4e24\u8005\u5fc5\u987b\u4f20\u5165\u5176\u4e00")
    public String getPayeeUserId() {
        return this.payeeUserId;
    }

    public void setPayeeUserId(String payeeUserId) {
        this.payeeUserId = payeeUserId;
    }

    public AlipayFundAuthOrderFreezeModel postPayments(List<PostPayment> postPayments) {
        this.postPayments = postPayments;
        return this;
    }

    public AlipayFundAuthOrderFreezeModel addPostPaymentsItem(PostPayment postPaymentsItem) {
        if (this.postPayments == null) {
            this.postPayments = new ArrayList<PostPayment>();
        }
        this.postPayments.add(postPaymentsItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="\u540e\u4ed8\u8d39\u9879\u76ee\uff0c \u6709\u4ed8\u8d39\u9879\u76ee\u65f6\u9700\u8981\u4f20\u5165\u8be5\u5b57\u6bb5\u3002\u4e0d\u540c\u53d7\u7406\u53f0\u6a21\u5f0f\u9700\u8981\u4f20\u5165\u4e0d\u540c\u53c2\u6570\uff0c\u540e\u4ed8\u8d39\u9879\u76ee\u540d\u79f0\u548c\u8ba1\u8d39\u8bf4\u660e\u9700\u8981\u901a\u8fc7\u6821\u9a8c\u89c4\u5219\uff0c\u540c\u65f6\u8ba1\u8d39\u8bf4\u660e\u5c06\u5c55\u793a\u5728\u5f00\u901a\u53d7\u7406\u53f0\u4e0a\u3002\u5f53\u53d7\u7406\u53f0\u6a21\u5f0f\uff08deposit_product_mode\uff09\u4f20\u5165POSTPAY \u65f6\uff0c\u540e\u4ed8\u8d39\u9879\u76ee\u540d\u79f0\uff08name\uff09\u3001\u91d1\u989d\uff08amount\uff09\u5fc5\u4f20\uff0c\u8ba1\u8d39\u8bf4\u660e\uff08description\uff09\u9009\u4f20\uff1b\u5f53\u4f20\u5165 POSTPAY_UNCERTAIN \u65f6\uff0c\u540e\u4ed8\u8d39\u9879\u76ee\u540d\u79f0\uff08name\uff09\u3001\u8ba1\u8d39\u8bf4\u660e\uff08description\uff09\u5fc5\u4f20\uff0c\u91d1\u989d\uff08amount\uff09\u4e0d\u4f20\u3002 \u5177\u4f53\u89c4\u5219\u53c2\u8003\u6587\u6863\uff1ahttps://opendocs.alipay.com/b/08tf3t?pathHash=d67d7545")
    public List<PostPayment> getPostPayments() {
        return this.postPayments;
    }

    public void setPostPayments(List<PostPayment> postPayments) {
        this.postPayments = postPayments;
    }

    public AlipayFundAuthOrderFreezeModel productCode(String productCode) {
        this.productCode = productCode;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="PRE_AUTH", value="\u9500\u552e\u4ea7\u54c1\u7801\u3002 \u5f53\u9762\u8d44\u91d1\u9884\u6388\u6743\u56fa\u5b9a\u4e3a PRE_AUTH")
    public String getProductCode() {
        return this.productCode;
    }

    public void setProductCode(String productCode) {
        this.productCode = productCode;
    }

    public AlipayFundAuthOrderFreezeModel sceneCode(String sceneCode) {
        this.sceneCode = sceneCode;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="HOTEL", value="\u573a\u666f\u7801\u3002 \u5237\u8138\u573a\u666f\u4e0b\u4f20\u5165HOTEL\uff0c\u5176\u4ed6\u60c5\u51b5\u4e0b\u65e0\u9700\u4f20\u5165")
    public String getSceneCode() {
        return this.sceneCode;
    }

    public void setSceneCode(String sceneCode) {
        this.sceneCode = sceneCode;
    }

    public AlipayFundAuthOrderFreezeModel settleCurrency(String settleCurrency) {
        this.settleCurrency = settleCurrency;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="USD", value="\u5546\u6237\u6307\u5b9a\u7684\u7ed3\u7b97\u5e01\u79cd\u3002\u652f\u6301\u6fb3\u5143\uff1aAUD, \u65b0\u897f\u5170\u5143\uff1aNZD, \u53f0\u5e01\uff1aTWD, \u7f8e\u5143\uff1aUSD, \u6b27\u5143\uff1aEUR, \u82f1\u9551\uff1aGBP")
    public String getSettleCurrency() {
        return this.settleCurrency;
    }

    public void setSettleCurrency(String settleCurrency) {
        this.settleCurrency = settleCurrency;
    }

    public AlipayFundAuthOrderFreezeModel terminalParams(String terminalParams) {
        this.terminalParams = terminalParams;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="{\"terminalType\":\"IOT\",\"signature\":\"QIIAX8DqbFbNf2oe97FI1RSL\",\"apdidToken\":\"xPA3ptuArwYc3F6Va\",\"signedKeys\":\"auth,apdidToken\"}", value="\u673a\u5177\u7ba1\u63a7sdk\u52a0\u7b7e\u53c2\u6570\uff0c\u53c2\u6570\u793a\u4f8b \"terminal_params\":\"{\"terminalType\":\"IOT\",\"signature\":\"QIIAX8DqbFbNf2oe97FI1RSLAycC/tU4GVjer3bN8K4qLtAB\",\"apdidToken\":\"xPA3ptuArwYc3F6Va_pjVwv7Qx7Tg5TJdrA_Jb_moYte9AqGZgEAAA==\",\"hardToken\":\"\",\"time\":\"1539847253\",\"bizCode\":\"11000200040004000121\",\"bizTid\":\"010100F01i1XyacMgpOinHerfdBw1xA9dNDocctlnqhLD8lfODr1A7Q\",\"signedKeys\":\"authCode,totalAmount,apdidToken,hardToken,time,bizCode,bizTid\"}\"")
    public String getTerminalParams() {
        return this.terminalParams;
    }

    public void setTerminalParams(String terminalParams) {
        this.terminalParams = terminalParams;
    }

    public AlipayFundAuthOrderFreezeModel timeoutExpress(String timeoutExpress) {
        this.timeoutExpress = timeoutExpress;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="2d", value="\u9884\u6388\u6743\u8ba2\u5355\u76f8\u5bf9\u8d85\u65f6\u65f6\u95f4\uff0c\u4ece\u5546\u6237\u8bf7\u6c42\u65f6\u95f4\u5f00\u59cb\u8ba1\u7b97\u3002 \u9884\u6388\u6743\u8ba2\u5355\u5141\u8bb8\u7684\u6700\u665a\u6388\u6743\u65f6\u95f4\uff0c\u903e\u671f\u5c06\u5173\u95ed\u8be5\u7b14\u8ba2\u5355\u3002\u53d6\u503c\u8303\u56f4\uff1a1m\uff5e15d\u3002m-\u5206\u949f\uff0ch-\u5c0f\u65f6\uff0cd-\u5929\u3002 \u8be5\u53c2\u6570\u6570\u503c\u4e0d\u63a5\u53d7\u5c0f\u6570\u70b9\uff0c \u5982 1.5h\uff0c\u53ef\u8f6c\u6362\u4e3a90m\u3002 \u9ed8\u8ba4\u4e3a15m\u3002")
    public String getTimeoutExpress() {
        return this.timeoutExpress;
    }

    public void setTimeoutExpress(String timeoutExpress) {
        this.timeoutExpress = timeoutExpress;
    }

    public AlipayFundAuthOrderFreezeModel transCurrency(String transCurrency) {
        this.transCurrency = transCurrency;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="USD", value="\u6807\u4ef7\u5e01\u79cd,  amount \u5bf9\u5e94\u7684\u5e01\u79cd\u5355\u4f4d\u3002\u652f\u6301\u6fb3\u5143\uff1aAUD, \u65b0\u897f\u5170\u5143\uff1aNZD, \u53f0\u5e01\uff1aTWD, \u7f8e\u5143\uff1aUSD, \u6b27\u5143\uff1aEUR, \u82f1\u9551\uff1aGBP")
    public String getTransCurrency() {
        return this.transCurrency;
    }

    public void setTransCurrency(String transCurrency) {
        this.transCurrency = transCurrency;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AlipayFundAuthOrderFreezeModel alipayFundAuthOrderFreezeModel = (AlipayFundAuthOrderFreezeModel)o;
        return Objects.equals(this.amount, alipayFundAuthOrderFreezeModel.amount) && Objects.equals(this.authCode, alipayFundAuthOrderFreezeModel.authCode) && Objects.equals(this.authCodeType, alipayFundAuthOrderFreezeModel.authCodeType) && Objects.equals(this.businessParams, alipayFundAuthOrderFreezeModel.businessParams) && Objects.equals(this.depositProductMode, alipayFundAuthOrderFreezeModel.depositProductMode) && Objects.equals(this.disablePayChannels, alipayFundAuthOrderFreezeModel.disablePayChannels) && Objects.equals(this.enablePayChannels, alipayFundAuthOrderFreezeModel.enablePayChannels) && Objects.equals(this.extraParam, alipayFundAuthOrderFreezeModel.extraParam) && Objects.equals(this.identityParams, alipayFundAuthOrderFreezeModel.identityParams) && Objects.equals(this.notifyUrl, alipayFundAuthOrderFreezeModel.notifyUrl) && Objects.equals(this.orderTitle, alipayFundAuthOrderFreezeModel.orderTitle) && Objects.equals(this.outOrderNo, alipayFundAuthOrderFreezeModel.outOrderNo) && Objects.equals(this.outRequestNo, alipayFundAuthOrderFreezeModel.outRequestNo) && Objects.equals(this.payTimeout, alipayFundAuthOrderFreezeModel.payTimeout) && Objects.equals(this.payeeLogonId, alipayFundAuthOrderFreezeModel.payeeLogonId) && Objects.equals(this.payeeUserId, alipayFundAuthOrderFreezeModel.payeeUserId) && Objects.equals(this.postPayments, alipayFundAuthOrderFreezeModel.postPayments) && Objects.equals(this.productCode, alipayFundAuthOrderFreezeModel.productCode) && Objects.equals(this.sceneCode, alipayFundAuthOrderFreezeModel.sceneCode) && Objects.equals(this.settleCurrency, alipayFundAuthOrderFreezeModel.settleCurrency) && Objects.equals(this.terminalParams, alipayFundAuthOrderFreezeModel.terminalParams) && Objects.equals(this.timeoutExpress, alipayFundAuthOrderFreezeModel.timeoutExpress) && Objects.equals(this.transCurrency, alipayFundAuthOrderFreezeModel.transCurrency);
    }

    public int hashCode() {
        return Objects.hash(this.amount, this.authCode, this.authCodeType, this.businessParams, this.depositProductMode, this.disablePayChannels, this.enablePayChannels, this.extraParam, this.identityParams, this.notifyUrl, this.orderTitle, this.outOrderNo, this.outRequestNo, this.payTimeout, this.payeeLogonId, this.payeeUserId, this.postPayments, this.productCode, this.sceneCode, this.settleCurrency, this.terminalParams, this.timeoutExpress, this.transCurrency);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class AlipayFundAuthOrderFreezeModel {\n");
        sb.append("    amount: ").append(this.toIndentedString(this.amount)).append("\n");
        sb.append("    authCode: ").append(this.toIndentedString(this.authCode)).append("\n");
        sb.append("    authCodeType: ").append(this.toIndentedString(this.authCodeType)).append("\n");
        sb.append("    businessParams: ").append(this.toIndentedString(this.businessParams)).append("\n");
        sb.append("    depositProductMode: ").append(this.toIndentedString(this.depositProductMode)).append("\n");
        sb.append("    disablePayChannels: ").append(this.toIndentedString(this.disablePayChannels)).append("\n");
        sb.append("    enablePayChannels: ").append(this.toIndentedString(this.enablePayChannels)).append("\n");
        sb.append("    extraParam: ").append(this.toIndentedString(this.extraParam)).append("\n");
        sb.append("    identityParams: ").append(this.toIndentedString(this.identityParams)).append("\n");
        sb.append("    notifyUrl: ").append(this.toIndentedString(this.notifyUrl)).append("\n");
        sb.append("    orderTitle: ").append(this.toIndentedString(this.orderTitle)).append("\n");
        sb.append("    outOrderNo: ").append(this.toIndentedString(this.outOrderNo)).append("\n");
        sb.append("    outRequestNo: ").append(this.toIndentedString(this.outRequestNo)).append("\n");
        sb.append("    payTimeout: ").append(this.toIndentedString(this.payTimeout)).append("\n");
        sb.append("    payeeLogonId: ").append(this.toIndentedString(this.payeeLogonId)).append("\n");
        sb.append("    payeeUserId: ").append(this.toIndentedString(this.payeeUserId)).append("\n");
        sb.append("    postPayments: ").append(this.toIndentedString(this.postPayments)).append("\n");
        sb.append("    productCode: ").append(this.toIndentedString(this.productCode)).append("\n");
        sb.append("    sceneCode: ").append(this.toIndentedString(this.sceneCode)).append("\n");
        sb.append("    settleCurrency: ").append(this.toIndentedString(this.settleCurrency)).append("\n");
        sb.append("    terminalParams: ").append(this.toIndentedString(this.terminalParams)).append("\n");
        sb.append("    timeoutExpress: ").append(this.toIndentedString(this.timeoutExpress)).append("\n");
        sb.append("    transCurrency: ").append(this.toIndentedString(this.transCurrency)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static void validateJsonObject(JsonObject jsonObj) throws IOException {
        if (jsonObj == null) {
            if (openapiRequiredFields.isEmpty()) {
                return;
            }
            throw new IllegalArgumentException(String.format("The required field(s) %s in AlipayFundAuthOrderFreezeModel is not found in the empty JSON string", openapiRequiredFields.toString()));
        }
        Set entries = jsonObj.entrySet();
        for (Map.Entry entry : entries) {
            if (openapiFields.contains(entry.getKey())) continue;
            throw new IllegalArgumentException(String.format("The field `%s` in the JSON string is not defined in the `AlipayFundAuthOrderFreezeModel` properties. JSON: %s", entry.getKey(), jsonObj.toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_AMOUNT) != null && !jsonObj.get(SERIALIZED_NAME_AMOUNT).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `amount` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_AMOUNT).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_AUTH_CODE) != null && !jsonObj.get(SERIALIZED_NAME_AUTH_CODE).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `auth_code` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_AUTH_CODE).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_AUTH_CODE_TYPE) != null && !jsonObj.get(SERIALIZED_NAME_AUTH_CODE_TYPE).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `auth_code_type` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_AUTH_CODE_TYPE).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_BUSINESS_PARAMS) != null && !jsonObj.get(SERIALIZED_NAME_BUSINESS_PARAMS).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `business_params` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_BUSINESS_PARAMS).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_DEPOSIT_PRODUCT_MODE) != null && !jsonObj.get(SERIALIZED_NAME_DEPOSIT_PRODUCT_MODE).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `deposit_product_mode` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_DEPOSIT_PRODUCT_MODE).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_DISABLE_PAY_CHANNELS) != null && !jsonObj.get(SERIALIZED_NAME_DISABLE_PAY_CHANNELS).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `disable_pay_channels` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_DISABLE_PAY_CHANNELS).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_ENABLE_PAY_CHANNELS) != null && !jsonObj.get(SERIALIZED_NAME_ENABLE_PAY_CHANNELS).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `enable_pay_channels` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_ENABLE_PAY_CHANNELS).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_EXTRA_PARAM) != null && !jsonObj.get(SERIALIZED_NAME_EXTRA_PARAM).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `extra_param` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_EXTRA_PARAM).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_IDENTITY_PARAMS) != null && !jsonObj.get(SERIALIZED_NAME_IDENTITY_PARAMS).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `identity_params` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_IDENTITY_PARAMS).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_NOTIFY_URL) != null && !jsonObj.get(SERIALIZED_NAME_NOTIFY_URL).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `notify_url` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_NOTIFY_URL).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_ORDER_TITLE) != null && !jsonObj.get(SERIALIZED_NAME_ORDER_TITLE).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `order_title` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_ORDER_TITLE).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_OUT_ORDER_NO) != null && !jsonObj.get(SERIALIZED_NAME_OUT_ORDER_NO).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `out_order_no` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_OUT_ORDER_NO).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_OUT_REQUEST_NO) != null && !jsonObj.get(SERIALIZED_NAME_OUT_REQUEST_NO).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `out_request_no` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_OUT_REQUEST_NO).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_PAY_TIMEOUT) != null && !jsonObj.get(SERIALIZED_NAME_PAY_TIMEOUT).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `pay_timeout` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_PAY_TIMEOUT).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_PAYEE_LOGON_ID) != null && !jsonObj.get(SERIALIZED_NAME_PAYEE_LOGON_ID).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `payee_logon_id` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_PAYEE_LOGON_ID).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_PAYEE_USER_ID) != null && !jsonObj.get(SERIALIZED_NAME_PAYEE_USER_ID).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `payee_user_id` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_PAYEE_USER_ID).toString()));
        }
        JsonArray jsonArraypostPayments = jsonObj.getAsJsonArray(SERIALIZED_NAME_POST_PAYMENTS);
        if (jsonArraypostPayments != null) {
            if (!jsonObj.get(SERIALIZED_NAME_POST_PAYMENTS).isJsonArray()) {
                throw new IllegalArgumentException(String.format("Expected the field `post_payments` to be an array in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_POST_PAYMENTS).toString()));
            }
            for (int i = 0; i < jsonArraypostPayments.size(); ++i) {
                PostPayment.validateJsonObject(jsonArraypostPayments.get(i).getAsJsonObject());
            }
        }
        if (jsonObj.get(SERIALIZED_NAME_PRODUCT_CODE) != null && !jsonObj.get(SERIALIZED_NAME_PRODUCT_CODE).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `product_code` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_PRODUCT_CODE).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_SCENE_CODE) != null && !jsonObj.get(SERIALIZED_NAME_SCENE_CODE).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `scene_code` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_SCENE_CODE).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_SETTLE_CURRENCY) != null && !jsonObj.get(SERIALIZED_NAME_SETTLE_CURRENCY).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `settle_currency` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_SETTLE_CURRENCY).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_TERMINAL_PARAMS) != null && !jsonObj.get(SERIALIZED_NAME_TERMINAL_PARAMS).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `terminal_params` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_TERMINAL_PARAMS).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_TIMEOUT_EXPRESS) != null && !jsonObj.get(SERIALIZED_NAME_TIMEOUT_EXPRESS).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `timeout_express` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_TIMEOUT_EXPRESS).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_TRANS_CURRENCY) != null && !jsonObj.get(SERIALIZED_NAME_TRANS_CURRENCY).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `trans_currency` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_TRANS_CURRENCY).toString()));
        }
    }

    public static AlipayFundAuthOrderFreezeModel fromJson(String jsonString) throws IOException {
        return (AlipayFundAuthOrderFreezeModel)JSON.getGson().fromJson(jsonString, AlipayFundAuthOrderFreezeModel.class);
    }

    public String toJson() {
        return JSON.getGson().toJson((Object)this);
    }

    static {
        openapiFields.add(SERIALIZED_NAME_AMOUNT);
        openapiFields.add(SERIALIZED_NAME_AUTH_CODE);
        openapiFields.add(SERIALIZED_NAME_AUTH_CODE_TYPE);
        openapiFields.add(SERIALIZED_NAME_BUSINESS_PARAMS);
        openapiFields.add(SERIALIZED_NAME_DEPOSIT_PRODUCT_MODE);
        openapiFields.add(SERIALIZED_NAME_DISABLE_PAY_CHANNELS);
        openapiFields.add(SERIALIZED_NAME_ENABLE_PAY_CHANNELS);
        openapiFields.add(SERIALIZED_NAME_EXTRA_PARAM);
        openapiFields.add(SERIALIZED_NAME_IDENTITY_PARAMS);
        openapiFields.add(SERIALIZED_NAME_NOTIFY_URL);
        openapiFields.add(SERIALIZED_NAME_ORDER_TITLE);
        openapiFields.add(SERIALIZED_NAME_OUT_ORDER_NO);
        openapiFields.add(SERIALIZED_NAME_OUT_REQUEST_NO);
        openapiFields.add(SERIALIZED_NAME_PAY_TIMEOUT);
        openapiFields.add(SERIALIZED_NAME_PAYEE_LOGON_ID);
        openapiFields.add(SERIALIZED_NAME_PAYEE_USER_ID);
        openapiFields.add(SERIALIZED_NAME_POST_PAYMENTS);
        openapiFields.add(SERIALIZED_NAME_PRODUCT_CODE);
        openapiFields.add(SERIALIZED_NAME_SCENE_CODE);
        openapiFields.add(SERIALIZED_NAME_SETTLE_CURRENCY);
        openapiFields.add(SERIALIZED_NAME_TERMINAL_PARAMS);
        openapiFields.add(SERIALIZED_NAME_TIMEOUT_EXPRESS);
        openapiFields.add(SERIALIZED_NAME_TRANS_CURRENCY);
        openapiRequiredFields = new HashSet();
    }

    public static class CustomTypeAdapterFactory
    implements TypeAdapterFactory {
        public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
            if (!AlipayFundAuthOrderFreezeModel.class.isAssignableFrom(type.getRawType())) {
                return null;
            }
            final TypeAdapter elementAdapter = gson.getAdapter(JsonElement.class);
            final TypeAdapter thisAdapter = gson.getDelegateAdapter((TypeAdapterFactory)this, TypeToken.get(AlipayFundAuthOrderFreezeModel.class));
            return new TypeAdapter<AlipayFundAuthOrderFreezeModel>(){

                public void write(JsonWriter out, AlipayFundAuthOrderFreezeModel value) throws IOException {
                    JsonObject obj = thisAdapter.toJsonTree((Object)value).getAsJsonObject();
                    elementAdapter.write(out, (Object)obj);
                }

                public AlipayFundAuthOrderFreezeModel read(JsonReader in) throws IOException {
                    JsonObject jsonObj = ((JsonElement)elementAdapter.read(in)).getAsJsonObject();
                    AlipayFundAuthOrderFreezeModel.validateJsonObject(jsonObj);
                    return (AlipayFundAuthOrderFreezeModel)thisAdapter.fromJsonTree((JsonElement)jsonObj);
                }
            }.nullSafe();
        }
    }
}

