/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.v3.api;

import com.alipay.v3.ApiCallback;
import com.alipay.v3.ApiClient;
import com.alipay.v3.ApiException;
import com.alipay.v3.ApiResponse;
import com.alipay.v3.Configuration;
import com.alipay.v3.JSON;
import com.alipay.v3.Pair;
import com.alipay.v3.model.AbstractOpenApiSchema;
import com.alipay.v3.model.AlipayOpenPublicMessageContentCreateDefaultResponse;
import com.alipay.v3.model.AlipayOpenPublicMessageContentCreateModel;
import com.alipay.v3.model.AlipayOpenPublicMessageContentCreateResponseModel;
import com.alipay.v3.model.AlipayOpenPublicMessageContentModifyDefaultResponse;
import com.alipay.v3.model.AlipayOpenPublicMessageContentModifyModel;
import com.alipay.v3.model.AlipayOpenPublicMessageContentModifyResponseModel;
import com.alipay.v3.util.AlipayLogger;
import com.alipay.v3.util.model.CustomizedParams;
import com.google.common.base.Strings;
import com.google.gson.reflect.TypeToken;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import okhttp3.Call;

public class AlipayOpenPublicMessageContentApi {
    private ApiClient localVarApiClient;
    private int localHostIndex;
    private String localCustomBaseUrl;

    public AlipayOpenPublicMessageContentApi() {
        this(Configuration.getDefaultApiClient());
    }

    public AlipayOpenPublicMessageContentApi(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.localVarApiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    public int getHostIndex() {
        return this.localHostIndex;
    }

    public void setHostIndex(int hostIndex) {
        this.localHostIndex = hostIndex;
    }

    public String getCustomBaseUrl() {
        return this.localCustomBaseUrl;
    }

    public void setCustomBaseUrl(String customBaseUrl) {
        this.localCustomBaseUrl = customBaseUrl;
    }

    public Call createCall(AlipayOpenPublicMessageContentCreateModel alipayOpenPublicMessageContentCreateModel, ApiCallback _callback, CustomizedParams customizedParams) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        AlipayOpenPublicMessageContentCreateModel localVarPostBody = customizedParams != null && !Strings.isNullOrEmpty((String)customizedParams.getBodyContent()) ? customizedParams.getBodyContent() : alipayOpenPublicMessageContentCreateModel;
        String localVarPath = "/v3/alipay/open/public/message/content/create";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        if (customizedParams != null) {
            if (customizedParams.getQueryParams() != null && customizedParams.getQueryParams().size() > 0) {
                for (Map.Entry<String, String> entry : customizedParams.getQueryParams().entrySet()) {
                    localVarQueryParams.addAll(this.localVarApiClient.parameterToPair(entry.getKey(), entry.getValue()));
                }
            }
            if (!Strings.isNullOrEmpty((String)customizedParams.getAppAuthToken())) {
                localVarHeaderParams.put("alipay-app-auth-token", customizedParams.getAppAuthToken());
            }
            if (customizedParams.getHeaderParams() != null && customizedParams.getHeaderParams().size() > 0) {
                localVarHeaderParams.putAll(customizedParams.getHeaderParams());
            }
        }
        String[] localVarAuthNames = new String[]{};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call createValidateBeforeCall(AlipayOpenPublicMessageContentCreateModel alipayOpenPublicMessageContentCreateModel, ApiCallback _callback, CustomizedParams customizedParams) throws ApiException {
        Call localVarCall = this.createCall(alipayOpenPublicMessageContentCreateModel, _callback, customizedParams);
        return localVarCall;
    }

    public AlipayOpenPublicMessageContentCreateResponseModel create(AlipayOpenPublicMessageContentCreateModel alipayOpenPublicMessageContentCreateModel) throws ApiException {
        ApiResponse<AlipayOpenPublicMessageContentCreateResponseModel> localVarResp = this.createWithHttpInfo(alipayOpenPublicMessageContentCreateModel, null);
        return localVarResp.getData();
    }

    public AlipayOpenPublicMessageContentCreateResponseModel create(AlipayOpenPublicMessageContentCreateModel alipayOpenPublicMessageContentCreateModel, CustomizedParams customizedParams) throws ApiException {
        ApiResponse<AlipayOpenPublicMessageContentCreateResponseModel> localVarResp = this.createWithHttpInfo(alipayOpenPublicMessageContentCreateModel, customizedParams);
        return localVarResp.getData();
    }

    public ApiResponse<AlipayOpenPublicMessageContentCreateResponseModel> createWithHttpInfo(AlipayOpenPublicMessageContentCreateModel alipayOpenPublicMessageContentCreateModel, CustomizedParams customizedParams) throws ApiException {
        Call localVarCall = this.createValidateBeforeCall(alipayOpenPublicMessageContentCreateModel, null, customizedParams);
        try {
            Type localVarReturnType = new TypeToken<AlipayOpenPublicMessageContentCreateResponseModel>(){}.getType();
            return this.localVarApiClient.execute(localVarCall, localVarReturnType);
        }
        catch (ApiException e) {
            try {
                this.localVarApiClient.getJSON();
                e.setErrorObject((AbstractOpenApiSchema)JSON.getGson().fromJson(e.getResponseBody(), new TypeToken<AlipayOpenPublicMessageContentCreateDefaultResponse>(){}.getType()));
            }
            catch (Exception ex) {
                AlipayLogger.logBizWarn(ex);
            }
            throw e;
        }
    }

    public Call createAsync(AlipayOpenPublicMessageContentCreateModel alipayOpenPublicMessageContentCreateModel, ApiCallback<AlipayOpenPublicMessageContentCreateResponseModel> _callback) throws ApiException {
        Call localVarCall = this.createValidateBeforeCall(alipayOpenPublicMessageContentCreateModel, _callback, null);
        Type localVarReturnType = new TypeToken<AlipayOpenPublicMessageContentCreateResponseModel>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call createAsync(AlipayOpenPublicMessageContentCreateModel alipayOpenPublicMessageContentCreateModel, ApiCallback<AlipayOpenPublicMessageContentCreateResponseModel> _callback, CustomizedParams customizedParams) throws ApiException {
        Call localVarCall = this.createValidateBeforeCall(alipayOpenPublicMessageContentCreateModel, _callback, customizedParams);
        Type localVarReturnType = new TypeToken<AlipayOpenPublicMessageContentCreateResponseModel>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call modifyCall(AlipayOpenPublicMessageContentModifyModel alipayOpenPublicMessageContentModifyModel, ApiCallback _callback, CustomizedParams customizedParams) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        AlipayOpenPublicMessageContentModifyModel localVarPostBody = customizedParams != null && !Strings.isNullOrEmpty((String)customizedParams.getBodyContent()) ? customizedParams.getBodyContent() : alipayOpenPublicMessageContentModifyModel;
        String localVarPath = "/v3/alipay/open/public/message/content/modify";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        if (customizedParams != null) {
            if (customizedParams.getQueryParams() != null && customizedParams.getQueryParams().size() > 0) {
                for (Map.Entry<String, String> entry : customizedParams.getQueryParams().entrySet()) {
                    localVarQueryParams.addAll(this.localVarApiClient.parameterToPair(entry.getKey(), entry.getValue()));
                }
            }
            if (!Strings.isNullOrEmpty((String)customizedParams.getAppAuthToken())) {
                localVarHeaderParams.put("alipay-app-auth-token", customizedParams.getAppAuthToken());
            }
            if (customizedParams.getHeaderParams() != null && customizedParams.getHeaderParams().size() > 0) {
                localVarHeaderParams.putAll(customizedParams.getHeaderParams());
            }
        }
        String[] localVarAuthNames = new String[]{};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call modifyValidateBeforeCall(AlipayOpenPublicMessageContentModifyModel alipayOpenPublicMessageContentModifyModel, ApiCallback _callback, CustomizedParams customizedParams) throws ApiException {
        Call localVarCall = this.modifyCall(alipayOpenPublicMessageContentModifyModel, _callback, customizedParams);
        return localVarCall;
    }

    public AlipayOpenPublicMessageContentModifyResponseModel modify(AlipayOpenPublicMessageContentModifyModel alipayOpenPublicMessageContentModifyModel) throws ApiException {
        ApiResponse<AlipayOpenPublicMessageContentModifyResponseModel> localVarResp = this.modifyWithHttpInfo(alipayOpenPublicMessageContentModifyModel, null);
        return localVarResp.getData();
    }

    public AlipayOpenPublicMessageContentModifyResponseModel modify(AlipayOpenPublicMessageContentModifyModel alipayOpenPublicMessageContentModifyModel, CustomizedParams customizedParams) throws ApiException {
        ApiResponse<AlipayOpenPublicMessageContentModifyResponseModel> localVarResp = this.modifyWithHttpInfo(alipayOpenPublicMessageContentModifyModel, customizedParams);
        return localVarResp.getData();
    }

    public ApiResponse<AlipayOpenPublicMessageContentModifyResponseModel> modifyWithHttpInfo(AlipayOpenPublicMessageContentModifyModel alipayOpenPublicMessageContentModifyModel, CustomizedParams customizedParams) throws ApiException {
        Call localVarCall = this.modifyValidateBeforeCall(alipayOpenPublicMessageContentModifyModel, null, customizedParams);
        try {
            Type localVarReturnType = new TypeToken<AlipayOpenPublicMessageContentModifyResponseModel>(){}.getType();
            return this.localVarApiClient.execute(localVarCall, localVarReturnType);
        }
        catch (ApiException e) {
            try {
                this.localVarApiClient.getJSON();
                e.setErrorObject((AbstractOpenApiSchema)JSON.getGson().fromJson(e.getResponseBody(), new TypeToken<AlipayOpenPublicMessageContentModifyDefaultResponse>(){}.getType()));
            }
            catch (Exception ex) {
                AlipayLogger.logBizWarn(ex);
            }
            throw e;
        }
    }

    public Call modifyAsync(AlipayOpenPublicMessageContentModifyModel alipayOpenPublicMessageContentModifyModel, ApiCallback<AlipayOpenPublicMessageContentModifyResponseModel> _callback) throws ApiException {
        Call localVarCall = this.modifyValidateBeforeCall(alipayOpenPublicMessageContentModifyModel, _callback, null);
        Type localVarReturnType = new TypeToken<AlipayOpenPublicMessageContentModifyResponseModel>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call modifyAsync(AlipayOpenPublicMessageContentModifyModel alipayOpenPublicMessageContentModifyModel, ApiCallback<AlipayOpenPublicMessageContentModifyResponseModel> _callback, CustomizedParams customizedParams) throws ApiException {
        Call localVarCall = this.modifyValidateBeforeCall(alipayOpenPublicMessageContentModifyModel, _callback, customizedParams);
        Type localVarReturnType = new TypeToken<AlipayOpenPublicMessageContentModifyResponseModel>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
}

