/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.v3.api;

import com.alipay.v3.ApiCallback;
import com.alipay.v3.ApiClient;
import com.alipay.v3.ApiException;
import com.alipay.v3.ApiResponse;
import com.alipay.v3.Configuration;
import com.alipay.v3.JSON;
import com.alipay.v3.Pair;
import com.alipay.v3.model.AbstractOpenApiSchema;
import com.alipay.v3.model.AlipayOpenMiniInnerversionInfoDeleteDefaultResponse;
import com.alipay.v3.model.AlipayOpenMiniInnerversionInfoQueryDefaultResponse;
import com.alipay.v3.model.AlipayOpenMiniInnerversionInfoQueryResponseModel;
import com.alipay.v3.util.AlipayLogger;
import com.alipay.v3.util.model.CustomizedParams;
import com.google.common.base.Strings;
import com.google.gson.reflect.TypeToken;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import okhttp3.Call;

public class AlipayOpenMiniInnerversionInfoApi {
    private ApiClient localVarApiClient;
    private int localHostIndex;
    private String localCustomBaseUrl;

    public AlipayOpenMiniInnerversionInfoApi() {
        this(Configuration.getDefaultApiClient());
    }

    public AlipayOpenMiniInnerversionInfoApi(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.localVarApiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    public int getHostIndex() {
        return this.localHostIndex;
    }

    public void setHostIndex(int hostIndex) {
        this.localHostIndex = hostIndex;
    }

    public String getCustomBaseUrl() {
        return this.localCustomBaseUrl;
    }

    public void setCustomBaseUrl(String customBaseUrl) {
        this.localCustomBaseUrl = customBaseUrl;
    }

    public Call deleteCall(String miniAppId, String appOrigin, String bundleId, String appVersion, String pid, String instCode, ApiCallback _callback, CustomizedParams customizedParams) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/v3/alipay/open/mini/innerversion/info/delete";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (miniAppId != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("mini_app_id", miniAppId));
        }
        if (appOrigin != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("app_origin", appOrigin));
        }
        if (bundleId != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("bundle_id", bundleId));
        }
        if (appVersion != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("app_version", appVersion));
        }
        if (pid != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("pid", pid));
        }
        if (instCode != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("inst_code", instCode));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        if (customizedParams != null) {
            if (customizedParams.getQueryParams() != null && customizedParams.getQueryParams().size() > 0) {
                for (Map.Entry<String, String> entry : customizedParams.getQueryParams().entrySet()) {
                    localVarQueryParams.addAll(this.localVarApiClient.parameterToPair(entry.getKey(), entry.getValue()));
                }
            }
            if (!Strings.isNullOrEmpty((String)customizedParams.getAppAuthToken())) {
                localVarHeaderParams.put("alipay-app-auth-token", customizedParams.getAppAuthToken());
            }
            if (customizedParams.getHeaderParams() != null && customizedParams.getHeaderParams().size() > 0) {
                localVarHeaderParams.putAll(customizedParams.getHeaderParams());
            }
        }
        String[] localVarAuthNames = new String[]{};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call deleteValidateBeforeCall(String miniAppId, String appOrigin, String bundleId, String appVersion, String pid, String instCode, ApiCallback _callback, CustomizedParams customizedParams) throws ApiException {
        Call localVarCall = this.deleteCall(miniAppId, appOrigin, bundleId, appVersion, pid, instCode, _callback, customizedParams);
        return localVarCall;
    }

    public Object delete(String miniAppId, String appOrigin, String bundleId, String appVersion, String pid, String instCode) throws ApiException {
        ApiResponse<Object> localVarResp = this.deleteWithHttpInfo(miniAppId, appOrigin, bundleId, appVersion, pid, instCode, null);
        return localVarResp.getData();
    }

    public Object delete(String miniAppId, String appOrigin, String bundleId, String appVersion, String pid, String instCode, CustomizedParams customizedParams) throws ApiException {
        ApiResponse<Object> localVarResp = this.deleteWithHttpInfo(miniAppId, appOrigin, bundleId, appVersion, pid, instCode, customizedParams);
        return localVarResp.getData();
    }

    public ApiResponse<Object> deleteWithHttpInfo(String miniAppId, String appOrigin, String bundleId, String appVersion, String pid, String instCode, CustomizedParams customizedParams) throws ApiException {
        Call localVarCall = this.deleteValidateBeforeCall(miniAppId, appOrigin, bundleId, appVersion, pid, instCode, null, customizedParams);
        try {
            Type localVarReturnType = new TypeToken<Object>(){}.getType();
            return this.localVarApiClient.execute(localVarCall, localVarReturnType);
        }
        catch (ApiException e) {
            try {
                this.localVarApiClient.getJSON();
                e.setErrorObject((AbstractOpenApiSchema)JSON.getGson().fromJson(e.getResponseBody(), new TypeToken<AlipayOpenMiniInnerversionInfoDeleteDefaultResponse>(){}.getType()));
            }
            catch (Exception ex) {
                AlipayLogger.logBizWarn(ex);
            }
            throw e;
        }
    }

    public Call deleteAsync(String miniAppId, String appOrigin, String bundleId, String appVersion, String pid, String instCode, ApiCallback<Object> _callback) throws ApiException {
        Call localVarCall = this.deleteValidateBeforeCall(miniAppId, appOrigin, bundleId, appVersion, pid, instCode, _callback, null);
        Type localVarReturnType = new TypeToken<Object>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call deleteAsync(String miniAppId, String appOrigin, String bundleId, String appVersion, String pid, String instCode, ApiCallback<Object> _callback, CustomizedParams customizedParams) throws ApiException {
        Call localVarCall = this.deleteValidateBeforeCall(miniAppId, appOrigin, bundleId, appVersion, pid, instCode, _callback, customizedParams);
        Type localVarReturnType = new TypeToken<Object>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call queryCall(String bundleId, String miniAppId, String appVersion, String appOrigin, ApiCallback _callback, CustomizedParams customizedParams) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/v3/alipay/open/mini/innerversion/info/query";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (bundleId != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("bundle_id", bundleId));
        }
        if (miniAppId != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("mini_app_id", miniAppId));
        }
        if (appVersion != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("app_version", appVersion));
        }
        if (appOrigin != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("app_origin", appOrigin));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        if (customizedParams != null) {
            if (customizedParams.getQueryParams() != null && customizedParams.getQueryParams().size() > 0) {
                for (Map.Entry<String, String> entry : customizedParams.getQueryParams().entrySet()) {
                    localVarQueryParams.addAll(this.localVarApiClient.parameterToPair(entry.getKey(), entry.getValue()));
                }
            }
            if (!Strings.isNullOrEmpty((String)customizedParams.getAppAuthToken())) {
                localVarHeaderParams.put("alipay-app-auth-token", customizedParams.getAppAuthToken());
            }
            if (customizedParams.getHeaderParams() != null && customizedParams.getHeaderParams().size() > 0) {
                localVarHeaderParams.putAll(customizedParams.getHeaderParams());
            }
        }
        String[] localVarAuthNames = new String[]{};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call queryValidateBeforeCall(String bundleId, String miniAppId, String appVersion, String appOrigin, ApiCallback _callback, CustomizedParams customizedParams) throws ApiException {
        Call localVarCall = this.queryCall(bundleId, miniAppId, appVersion, appOrigin, _callback, customizedParams);
        return localVarCall;
    }

    public AlipayOpenMiniInnerversionInfoQueryResponseModel query(String bundleId, String miniAppId, String appVersion, String appOrigin) throws ApiException {
        ApiResponse<AlipayOpenMiniInnerversionInfoQueryResponseModel> localVarResp = this.queryWithHttpInfo(bundleId, miniAppId, appVersion, appOrigin, null);
        return localVarResp.getData();
    }

    public AlipayOpenMiniInnerversionInfoQueryResponseModel query(String bundleId, String miniAppId, String appVersion, String appOrigin, CustomizedParams customizedParams) throws ApiException {
        ApiResponse<AlipayOpenMiniInnerversionInfoQueryResponseModel> localVarResp = this.queryWithHttpInfo(bundleId, miniAppId, appVersion, appOrigin, customizedParams);
        return localVarResp.getData();
    }

    public ApiResponse<AlipayOpenMiniInnerversionInfoQueryResponseModel> queryWithHttpInfo(String bundleId, String miniAppId, String appVersion, String appOrigin, CustomizedParams customizedParams) throws ApiException {
        Call localVarCall = this.queryValidateBeforeCall(bundleId, miniAppId, appVersion, appOrigin, null, customizedParams);
        try {
            Type localVarReturnType = new TypeToken<AlipayOpenMiniInnerversionInfoQueryResponseModel>(){}.getType();
            return this.localVarApiClient.execute(localVarCall, localVarReturnType);
        }
        catch (ApiException e) {
            try {
                this.localVarApiClient.getJSON();
                e.setErrorObject((AbstractOpenApiSchema)JSON.getGson().fromJson(e.getResponseBody(), new TypeToken<AlipayOpenMiniInnerversionInfoQueryDefaultResponse>(){}.getType()));
            }
            catch (Exception ex) {
                AlipayLogger.logBizWarn(ex);
            }
            throw e;
        }
    }

    public Call queryAsync(String bundleId, String miniAppId, String appVersion, String appOrigin, ApiCallback<AlipayOpenMiniInnerversionInfoQueryResponseModel> _callback) throws ApiException {
        Call localVarCall = this.queryValidateBeforeCall(bundleId, miniAppId, appVersion, appOrigin, _callback, null);
        Type localVarReturnType = new TypeToken<AlipayOpenMiniInnerversionInfoQueryResponseModel>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call queryAsync(String bundleId, String miniAppId, String appVersion, String appOrigin, ApiCallback<AlipayOpenMiniInnerversionInfoQueryResponseModel> _callback, CustomizedParams customizedParams) throws ApiException {
        Call localVarCall = this.queryValidateBeforeCall(bundleId, miniAppId, appVersion, appOrigin, _callback, customizedParams);
        Type localVarReturnType = new TypeToken<AlipayOpenMiniInnerversionInfoQueryResponseModel>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
}

