/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.testable.processor.translator;

import com.alibaba.testable.processor.generator.PrivateAccessStatementGenerator;
import com.alibaba.testable.processor.model.MemberRecord;
import com.alibaba.testable.processor.model.MemberType;
import com.alibaba.testable.processor.model.Parameters;
import com.alibaba.testable.processor.model.TestableContext;
import com.alibaba.testable.processor.translator.BaseTranslator;
import com.alibaba.testable.processor.translator.PrivateAccessChecker;
import com.alibaba.testable.processor.util.PathUtil;
import com.sun.tools.javac.code.Symbol;
import com.sun.tools.javac.tree.JCTree;
import com.sun.tools.javac.util.ListBuffer;
import com.sun.tools.javac.util.Name;
import java.io.File;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class EnablePrivateAccessTranslator
extends BaseTranslator {
    private static final String IDEA_PATHS_SELECTOR = "idea.paths.selector";
    private static final String USER_DIR = "user.dir";
    private static final String GRADLE_CLASS_FOLDER = "/build/classes/java/main/";
    private static final String MAVEN_CLASS_FOLDER = "/target/classes/";
    private final Name sourceClassName;
    private final ListBuffer<Name> sourceClassIns = new ListBuffer();
    private final MemberRecord memberRecord = new MemberRecord();
    private final PrivateAccessStatementGenerator privateAccessStatementGenerator;
    private final PrivateAccessChecker privateAccessChecker;

    public EnablePrivateAccessTranslator(TestableContext cx, Symbol.ClassSymbol clazz, Parameters p) {
        String sourceClassFullName;
        if (p.sourceClassName == null) {
            String testClassFullName = clazz.fullname.toString();
            sourceClassFullName = testClassFullName.substring(0, testClassFullName.length() - "Test".length());
        } else {
            sourceClassFullName = p.sourceClassName;
        }
        String sourceClassShortName = sourceClassFullName.substring(sourceClassFullName.lastIndexOf(46) + 1);
        this.privateAccessStatementGenerator = new PrivateAccessStatementGenerator(cx);
        this.sourceClassName = cx.names.fromString(sourceClassShortName);
        try {
            Class<?> cls = this.getSourceClass(clazz, sourceClassFullName);
            if (cls == null) {
                cx.logger.fatal("Failed to load source class \"" + sourceClassFullName + "\"");
            } else {
                this.findAllPrivateMembers(cls);
            }
        }
        catch (Exception e) {
            cx.logger.fatal("Failed to load source class \"" + sourceClassFullName + "\": " + e);
        }
        this.privateAccessChecker = p.verifyTargetExistence == null || p.verifyTargetExistence != false ? new PrivateAccessChecker(cx, sourceClassShortName, this.memberRecord) : null;
    }

    @Override
    public void visitVarDef(JCTree.JCVariableDecl jcVariableDecl) {
        jcVariableDecl.init = this.checkAndExchange(jcVariableDecl.init);
        super.visitVarDef(jcVariableDecl);
        if (jcVariableDecl.vartype instanceof JCTree.JCIdent && ((JCTree.JCIdent)jcVariableDecl.vartype).name.equals(this.sourceClassName)) {
            this.sourceClassIns.add(jcVariableDecl.name);
        }
    }

    @Override
    public void visitExec(JCTree.JCExpressionStatement jcExpressionStatement) {
        if (jcExpressionStatement.expr instanceof JCTree.JCAssign) {
            MemberType memberType = this.checkSetterType((JCTree.JCAssign)jcExpressionStatement.expr);
            if (memberType.equals((Object)MemberType.PRIVATE_OR_FINAL)) {
                jcExpressionStatement.expr = this.privateAccessStatementGenerator.fetchSetterStatement((JCTree.JCAssign)jcExpressionStatement.expr);
            } else if (memberType.equals((Object)MemberType.STATIC_PRIVATE)) {
                jcExpressionStatement.expr = this.privateAccessStatementGenerator.fetchStaticSetterStatement((JCTree.JCAssign)jcExpressionStatement.expr);
            }
        }
        jcExpressionStatement.expr = this.checkAndExchange(jcExpressionStatement.expr);
        super.visitExec(jcExpressionStatement);
    }

    @Override
    public void visitApply(JCTree.JCMethodInvocation tree) {
        tree.args = this.checkAndExchange(tree.args);
        super.visitApply(tree);
    }

    @Override
    public void visitAssign(JCTree.JCAssign jcAssign) {
        super.visitAssign(jcAssign);
    }

    @Override
    public void visitSelect(JCTree.JCFieldAccess jcFieldAccess) {
        super.visitSelect(jcFieldAccess);
    }

    @Override
    protected JCTree.JCExpression checkAndExchange(JCTree.JCExpression expr) {
        if (expr instanceof JCTree.JCFieldAccess) {
            MemberType memberType = this.checkGetterType((JCTree.JCFieldAccess)expr);
            if (memberType.equals((Object)MemberType.PRIVATE_OR_FINAL)) {
                expr = this.privateAccessStatementGenerator.fetchGetterStatement((JCTree.JCFieldAccess)expr);
            } else if (memberType.equals((Object)MemberType.STATIC_PRIVATE)) {
                expr = this.privateAccessStatementGenerator.fetchStaticGetterStatement((JCTree.JCFieldAccess)expr);
            }
        }
        if (expr instanceof JCTree.JCMethodInvocation) {
            JCTree.JCMethodInvocation invocation = (JCTree.JCMethodInvocation)expr;
            MemberType memberType = this.checkInvokeType(invocation);
            if (memberType.equals((Object)MemberType.PRIVATE_OR_FINAL)) {
                expr = this.privateAccessStatementGenerator.fetchInvokeStatement(invocation);
            } else if (memberType.equals((Object)MemberType.STATIC_PRIVATE)) {
                expr = this.privateAccessStatementGenerator.fetchStaticInvokeStatement(invocation);
            }
            if (this.privateAccessChecker != null) {
                this.privateAccessChecker.validate((JCTree.JCMethodInvocation)expr);
            }
        }
        if (expr instanceof JCTree.JCTypeCast) {
            JCTree.JCTypeCast typeCast = (JCTree.JCTypeCast)expr;
            typeCast.expr = this.checkAndExchange(typeCast.expr);
        }
        return expr;
    }

    private Class<?> getSourceClass(Symbol.ClassSymbol clazz, String sourceClassFullName) throws MalformedURLException, ClassNotFoundException {
        Class<?> cls;
        try {
            cls = Class.forName(sourceClassFullName);
        }
        catch (ClassNotFoundException e) {
            if (System.getProperty(IDEA_PATHS_SELECTOR) != null) {
                String sourceFileWrapperString = clazz.sourcefile.toString();
                String sourceFilePath = sourceFileWrapperString.substring(sourceFileWrapperString.lastIndexOf("[") + 1, sourceFileWrapperString.indexOf("]"));
                int indexOfSrc = sourceFilePath.lastIndexOf(File.separator + "src" + File.separator);
                String basePath = sourceFilePath.substring(0, indexOfSrc);
                try {
                    String targetFolderPath = PathUtil.fitPathString(basePath + MAVEN_CLASS_FOLDER);
                    cls = this.loadClass(targetFolderPath, sourceClassFullName);
                }
                catch (ClassNotFoundException e2) {
                    String buildFolderPath = PathUtil.fitPathString(basePath + GRADLE_CLASS_FOLDER);
                    cls = this.loadClass(buildFolderPath, sourceClassFullName);
                }
            }
            String path = PathUtil.fitPathString("file:" + System.getProperty(USER_DIR) + GRADLE_CLASS_FOLDER);
            cls = this.loadClass(path, sourceClassFullName);
        }
        return cls;
    }

    private Class<?> loadClass(String targetFolderPath, String sourceClassFullName) throws ClassNotFoundException, MalformedURLException {
        return new URLClassLoader(new URL[]{new URL(targetFolderPath)}).loadClass(sourceClassFullName);
    }

    private void findAllPrivateMembers(Class<?> cls) {
        Method[] methods;
        Field[] fields;
        for (Field f : fields = cls.getDeclaredFields()) {
            if (Modifier.isFinal(f.getModifiers()) || Modifier.isPrivate(f.getModifiers()) || Modifier.isProtected(f.getModifiers())) {
                this.memberRecord.privateOrFinalFields.add(f.getName());
                continue;
            }
            this.memberRecord.nonPrivateNorFinalFields.add(f.getName());
        }
        for (Method m : methods = cls.getDeclaredMethods()) {
            if (Modifier.isPrivate(m.getModifiers()) || Modifier.isProtected(m.getModifiers())) {
                this.checkAndAdd(this.memberRecord.privateMethods, m.getName(), this.getParameterLength(m));
                continue;
            }
            this.checkAndAdd(this.memberRecord.nonPrivateMethods, m.getName(), this.getParameterLength(m));
        }
        if (cls.getSuperclass() != null) {
            this.findAllPrivateMembers(cls.getSuperclass());
        }
    }

    private void checkAndAdd(Map<String, List<Integer>> map, String key, final int value) {
        if (map.containsKey(key)) {
            map.get(key).add(value);
        } else {
            map.put(key, (List<Integer>)new ArrayList<Integer>(){
                {
                    this.add(value);
                }
            });
        }
    }

    private int getParameterLength(Method m) {
        int length = m.getParameterTypes().length;
        if (length == 0) {
            return 0;
        }
        if (m.getParameterTypes()[length - 1].getName().startsWith("[")) {
            return -(length - 1);
        }
        return length;
    }

    private MemberType checkGetterType(JCTree.JCFieldAccess access) {
        if (access.selected instanceof JCTree.JCIdent && this.memberRecord.privateOrFinalFields.contains(access.name.toString())) {
            return this.checkSourceClassOrIns(((JCTree.JCIdent)access.selected).name);
        }
        return MemberType.NON_PRIVATE;
    }

    private MemberType checkSetterType(JCTree.JCAssign assign) {
        if (assign.lhs instanceof JCTree.JCFieldAccess && ((JCTree.JCFieldAccess)assign.lhs).selected instanceof JCTree.JCIdent && this.memberRecord.privateOrFinalFields.contains(((JCTree.JCFieldAccess)assign.lhs).name.toString())) {
            return this.checkSourceClassOrIns(((JCTree.JCIdent)((JCTree.JCFieldAccess)assign.lhs).selected).name);
        }
        return MemberType.NON_PRIVATE;
    }

    private MemberType checkInvokeType(JCTree.JCMethodInvocation expr) {
        if (expr.meth instanceof JCTree.JCFieldAccess && ((JCTree.JCFieldAccess)expr.meth).selected instanceof JCTree.JCIdent && this.memberRecord.privateMethods.containsKey(((JCTree.JCFieldAccess)expr.meth).name.toString())) {
            return this.checkSourceClassOrIns(((JCTree.JCIdent)((JCTree.JCFieldAccess)expr.meth).selected).name);
        }
        return MemberType.NON_PRIVATE;
    }

    private MemberType checkSourceClassOrIns(Name name) {
        if (this.sourceClassName.equals(name)) {
            return MemberType.STATIC_PRIVATE;
        }
        if (this.sourceClassIns.contains(name)) {
            return MemberType.PRIVATE_OR_FINAL;
        }
        return MemberType.NON_PRIVATE;
    }
}

