/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.client.utils;

import com.alibaba.nacos.client.env.NacosClientProperties;
import com.alibaba.nacos.client.utils.LogUtils;
import com.alibaba.nacos.common.utils.MD5Utils;
import com.alibaba.nacos.common.utils.StringUtils;
import org.slf4j.Logger;

public class ParamUtil {
    private static final Logger LOGGER = LogUtils.logger(ParamUtil.class);
    private static int connectTimeout = ParamUtil.initConnectionTimeout();
    private static int readTimeout;
    private static double perTaskConfigSize;
    private static final String NACOS_CONNECT_TIMEOUT_KEY = "NACOS.CONNECT.TIMEOUT";
    private static final String NACOS_READ_TIMEOUT_KEY = "NACOS.READ.TIMEOUT";
    private static final String DEFAULT_NACOS_CONNECT_TIMEOUT = "1000";
    private static final String DEFAULT_NACOS_READ_TIMEOUT = "3000";
    private static final String PER_TASK_CONFIG_SIZE_KEY = "PER_TASK_CONFIG_SIZE";
    private static final String DEFAULT_PER_TASK_CONFIG_SIZE_KEY = "3000";
    public static final int MAX_ENV_NAME_LENGTH = 50;

    private static int initConnectionTimeout() {
        String tmp = DEFAULT_NACOS_CONNECT_TIMEOUT;
        try {
            tmp = NacosClientProperties.PROTOTYPE.getProperty(NACOS_CONNECT_TIMEOUT_KEY, DEFAULT_NACOS_CONNECT_TIMEOUT);
            return Integer.parseInt(tmp);
        }
        catch (NumberFormatException e) {
            String msg = "[http-client] invalid connect timeout:" + tmp;
            LOGGER.error("[settings] " + msg, (Throwable)e);
            throw new IllegalArgumentException(msg, e);
        }
    }

    private static int initReadTimeout() {
        String tmp = "3000";
        try {
            tmp = NacosClientProperties.PROTOTYPE.getProperty(NACOS_READ_TIMEOUT_KEY, "3000");
            return Integer.parseInt(tmp);
        }
        catch (NumberFormatException e) {
            String msg = "[http-client] invalid read timeout:" + tmp;
            LOGGER.error("[settings] " + msg, (Throwable)e);
            throw new IllegalArgumentException(msg, e);
        }
    }

    private static double initPerTaskConfigSize() {
        try {
            return Double.parseDouble(NacosClientProperties.PROTOTYPE.getProperty(PER_TASK_CONFIG_SIZE_KEY, "3000"));
        }
        catch (NumberFormatException e) {
            LOGGER.error("[PER_TASK_CONFIG_SIZE] PER_TASK_CONFIG_SIZE invalid", (Throwable)e);
            throw new IllegalArgumentException("invalid PER_TASK_CONFIG_SIZE, expected value type double", e);
        }
    }

    public static int getConnectTimeout() {
        return connectTimeout;
    }

    public static void setConnectTimeout(int connectTimeout) {
        ParamUtil.connectTimeout = connectTimeout;
    }

    public static int getReadTimeout() {
        return readTimeout;
    }

    public static void setReadTimeout(int readTimeout) {
        ParamUtil.readTimeout = readTimeout;
    }

    public static double getPerTaskConfigSize() {
        return perTaskConfigSize;
    }

    public static void setPerTaskConfigSize(double perTaskConfigSize) {
        ParamUtil.perTaskConfigSize = perTaskConfigSize;
    }

    public static String simplyEnvNameIfOverLimit(String envName) {
        if (StringUtils.isNotBlank(envName) && envName.length() > 50) {
            return envName.substring(0, 50) + MD5Utils.md5Hex(envName, "UTF-8");
        }
        return envName;
    }

    static {
        LOGGER.info("[settings] [http-client] connect timeout:{}", (Object)connectTimeout);
        readTimeout = ParamUtil.initReadTimeout();
        LOGGER.info("[settings] [http-client] read timeout:{}", (Object)readTimeout);
        perTaskConfigSize = ParamUtil.initPerTaskConfigSize();
        LOGGER.info("PER_TASK_CONFIG_SIZE: {}", (Object)perTaskConfigSize);
    }
}

