/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.client.logger.option;

import ch.qos.logback.classic.encoder.PatternLayoutEncoder;
import ch.qos.logback.core.Appender;
import ch.qos.logback.core.Context;
import ch.qos.logback.core.FileAppender;
import ch.qos.logback.core.encoder.Encoder;
import ch.qos.logback.core.rolling.FixedWindowRollingPolicy;
import ch.qos.logback.core.rolling.RollingFileAppender;
import ch.qos.logback.core.rolling.RollingPolicy;
import ch.qos.logback.core.rolling.SizeAndTimeBasedFNATP;
import ch.qos.logback.core.rolling.SizeBasedTriggeringPolicy;
import ch.qos.logback.core.rolling.TimeBasedFileNamingAndTriggeringPolicy;
import ch.qos.logback.core.rolling.TimeBasedRollingPolicy;
import ch.qos.logback.core.rolling.TriggeringPolicy;
import com.alibaba.nacos.client.logger.option.Logback918ActivateOption;
import com.alibaba.nacos.client.logger.option.LogbackLoggerContextUtil;
import com.alibaba.nacos.client.logger.support.LoggerHelper;
import java.io.File;
import java.nio.charset.Charset;

public class LogbackActivateOption
extends Logback918ActivateOption {
    public LogbackActivateOption(Object logger) {
        super(logger);
    }

    @Override
    protected Appender getLogbackDailyRollingFileAppender(String productName, String file, String encoding) {
        RollingFileAppender appender = new RollingFileAppender();
        appender.setContext((Context)LogbackLoggerContextUtil.getLoggerContext());
        appender.setName(productName + "." + file.replace(File.separatorChar, '.') + ".Appender");
        appender.setAppend(true);
        appender.setFile(LoggerHelper.getLogFile(productName, file));
        TimeBasedRollingPolicy rolling = new TimeBasedRollingPolicy();
        rolling.setParent((FileAppender)appender);
        rolling.setFileNamePattern(LoggerHelper.getLogFile(productName, file) + ".%d{yyyy-MM-dd}");
        rolling.setContext((Context)LogbackLoggerContextUtil.getLoggerContext());
        rolling.start();
        appender.setRollingPolicy((RollingPolicy)rolling);
        PatternLayoutEncoder layout = new PatternLayoutEncoder();
        layout.setPattern(LoggerHelper.getPattern(productName));
        layout.setCharset(Charset.forName(encoding));
        appender.setEncoder((Encoder)layout);
        layout.setContext((Context)LogbackLoggerContextUtil.getLoggerContext());
        layout.start();
        appender.start();
        return appender;
    }

    @Override
    protected Appender getLogbackDailyAndSizeRollingFileAppender(String productName, String file, String encoding, String size) {
        return this.getLogbackDailyAndSizeRollingFileAppender(productName, file, encoding, size, "yyyy-MM-dd", -1);
    }

    @Override
    protected Appender getLogbackDailyAndSizeRollingFileAppender(String productName, String file, String encoding, String size, String datePattern, int maxBackupIndex) {
        RollingFileAppender appender = new RollingFileAppender();
        appender.setContext((Context)LogbackLoggerContextUtil.getLoggerContext());
        appender.setName(productName + "." + file.replace(File.separatorChar, '.') + ".Appender");
        appender.setAppend(true);
        appender.setFile(LoggerHelper.getLogFile(productName, file));
        TimeBasedRollingPolicy rolling = new TimeBasedRollingPolicy();
        rolling.setParent((FileAppender)appender);
        if (maxBackupIndex >= 0) {
            rolling.setMaxHistory(maxBackupIndex);
        }
        rolling.setFileNamePattern(LoggerHelper.getLogFile(productName, file) + ".%d{" + datePattern + "}.%i");
        rolling.setContext((Context)LogbackLoggerContextUtil.getLoggerContext());
        SizeAndTimeBasedFNATP fnatp = new SizeAndTimeBasedFNATP();
        this.setMaxFileSize(fnatp, size);
        fnatp.setTimeBasedRollingPolicy(rolling);
        rolling.setTimeBasedFileNamingAndTriggeringPolicy((TimeBasedFileNamingAndTriggeringPolicy)fnatp);
        rolling.start();
        appender.setRollingPolicy((RollingPolicy)rolling);
        PatternLayoutEncoder layout = new PatternLayoutEncoder();
        layout.setPattern(LoggerHelper.getPattern(productName));
        layout.setCharset(Charset.forName(encoding));
        appender.setEncoder((Encoder)layout);
        layout.setContext((Context)LogbackLoggerContextUtil.getLoggerContext());
        layout.start();
        appender.start();
        return appender;
    }

    @Override
    protected Appender getSizeRollingAppender(String productName, String file, String encoding, String size, int maxBackupIndex) {
        RollingFileAppender appender = new RollingFileAppender();
        appender.setContext((Context)LogbackLoggerContextUtil.getLoggerContext());
        appender.setName(productName + "." + file.replace(File.separatorChar, '.') + ".Appender");
        appender.setAppend(true);
        appender.setFile(LoggerHelper.getLogFile(productName, file));
        SizeBasedTriggeringPolicy triggerPolicy = new SizeBasedTriggeringPolicy();
        this.setMaxFileSize(triggerPolicy, size);
        triggerPolicy.setContext((Context)LogbackLoggerContextUtil.getLoggerContext());
        triggerPolicy.start();
        FixedWindowRollingPolicy rolling = new FixedWindowRollingPolicy();
        rolling.setContext((Context)LogbackLoggerContextUtil.getLoggerContext());
        rolling.setParent((FileAppender)appender);
        rolling.setFileNamePattern(LoggerHelper.getLogFile(productName, file) + ".%i");
        rolling.setParent((FileAppender)appender);
        if (maxBackupIndex >= 0) {
            rolling.setMaxIndex(maxBackupIndex);
        }
        rolling.start();
        appender.setRollingPolicy((RollingPolicy)rolling);
        appender.setTriggeringPolicy((TriggeringPolicy)triggerPolicy);
        PatternLayoutEncoder layout = new PatternLayoutEncoder();
        layout.setPattern(LoggerHelper.getPattern(productName));
        layout.setCharset(Charset.forName(encoding));
        appender.setEncoder((Encoder)layout);
        layout.setContext((Context)LogbackLoggerContextUtil.getLoggerContext());
        layout.start();
        appender.start();
        return appender;
    }
}

