/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.client.aliyun.auth.provider;

import com.alibaba.nacos.api.exception.NacosException;
import com.alibaba.nacos.client.aliyun.auth.ExtensionAuthPropertyKey;
import com.alibaba.nacos.client.aliyun.auth.ExtensionRamContext;
import com.alibaba.nacos.client.aliyun.auth.provider.ExtensionCredentialsProvider;
import com.alibaba.nacos.common.utils.StringUtils;
import java.util.Properties;

public class StsTokenCredentialsProvider
implements ExtensionCredentialsProvider {
    private String accessKey;
    private String secretKey;
    private String securityToken;
    private String signatureRegionId;

    @Override
    public boolean matchProvider(Properties properties) {
        String accessKey = this.getNacosProperties(properties, ExtensionAuthPropertyKey.ACCESS_KEY_ID);
        String secretKey = this.getNacosProperties(properties, ExtensionAuthPropertyKey.ACCESS_KEY_SECRET);
        String securityToken = this.getNacosProperties(properties, ExtensionAuthPropertyKey.SECURITY_TOKEN);
        return StringUtils.isNotBlank((String)accessKey) && StringUtils.isNotBlank((String)secretKey) && StringUtils.isNotBlank((String)securityToken);
    }

    @Override
    public void init(Properties properties) {
        this.accessKey = this.getNacosProperties(properties, ExtensionAuthPropertyKey.ACCESS_KEY_ID);
        this.secretKey = this.getNacosProperties(properties, ExtensionAuthPropertyKey.ACCESS_KEY_SECRET);
        this.securityToken = this.getNacosProperties(properties, ExtensionAuthPropertyKey.SECURITY_TOKEN);
        this.signatureRegionId = this.getSignatureRegionId(properties);
    }

    @Override
    public ExtensionRamContext getCredentialsForNacosClient() {
        ExtensionRamContext extensionRamContext = new ExtensionRamContext();
        extensionRamContext.setAccessKey(this.accessKey);
        extensionRamContext.setSecretKey(this.secretKey);
        extensionRamContext.setSecurityToken(this.securityToken);
        extensionRamContext.setExtensionSignatureRegionId(this.signatureRegionId);
        return extensionRamContext;
    }

    public void shutdown() throws NacosException {
    }
}

