/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.client.aliyun.auth.provider;

import com.alibaba.nacos.api.exception.NacosException;
import com.alibaba.nacos.api.utils.StringUtils;
import com.alibaba.nacos.client.aliyun.auth.ExtensionAuthPropertyKey;
import com.alibaba.nacos.client.aliyun.auth.ExtensionRamContext;
import com.alibaba.nacos.client.aliyun.auth.provider.ExtensionCredentialsProvider;
import com.aliyun.credentials.Client;
import com.aliyun.credentials.models.Config;
import com.aliyun.credentials.models.CredentialModel;
import java.lang.reflect.Field;
import java.util.Properties;

public abstract class AbstractCredentialClientProvider
implements ExtensionCredentialsProvider {
    private Client credentialsClient;
    private String signatureRegionId;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void init(Properties properties) {
        AbstractCredentialClientProvider abstractCredentialClientProvider = this;
        synchronized (abstractCredentialClientProvider) {
            if (null == this.credentialsClient) {
                Config credentialsConfig = this.generateCredentialsConfig(properties);
                this.credentialsClient = new Client(credentialsConfig);
            }
        }
        this.signatureRegionId = this.getSignatureRegionId(properties);
    }

    protected abstract Config generateCredentialsConfig(Properties var1);

    @Override
    public ExtensionRamContext getCredentialsForNacosClient() {
        ExtensionRamContext ramContext = new ExtensionRamContext();
        if (null != this.credentialsClient) {
            CredentialModel credentialModel = this.credentialsClient.getCredential();
            ramContext.setAccessKey(credentialModel.getAccessKeyId());
            ramContext.setSecretKey(credentialModel.getAccessKeySecret());
            ramContext.setSecurityToken(credentialModel.getSecurityToken());
        }
        ramContext.setExtensionSignatureRegionId(this.signatureRegionId);
        return ramContext;
    }

    public void shutdown() throws NacosException {
        if (null != this.credentialsClient) {
            this.doCloseCredentialsClient();
        }
    }

    private void doCloseCredentialsClient() {
        try {
            Field field = this.credentialsClient.getClass().getDeclaredField("credentialsProvider");
            field.setAccessible(true);
            Object innerProvider = field.get(this.credentialsClient);
            if (innerProvider instanceof AutoCloseable) {
                ((AutoCloseable)innerProvider).close();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    protected Config injectCommonBasicConfig(Properties properties, Config config) {
        String roleSessionExpiration;
        String policy;
        config.setAccessKeyId(this.getNacosProperties(properties, ExtensionAuthPropertyKey.ACCESS_KEY_ID));
        config.setAccessKeySecret(this.getNacosProperties(properties, ExtensionAuthPropertyKey.ACCESS_KEY_SECRET));
        String securityToken = this.getNacosProperties(properties, ExtensionAuthPropertyKey.SECURITY_TOKEN);
        if (!StringUtils.isEmpty((CharSequence)securityToken)) {
            config.setSecurityToken(securityToken);
        }
        if (!StringUtils.isEmpty((CharSequence)(policy = this.getNacosProperties(properties, ExtensionAuthPropertyKey.POLICY)))) {
            config.setPolicy(policy);
        }
        if (!StringUtils.isEmpty((CharSequence)(roleSessionExpiration = this.getNacosProperties(properties, ExtensionAuthPropertyKey.ROLE_SESSION_EXPIRATION)))) {
            config.setRoleSessionExpiration(Integer.valueOf(Integer.parseInt(roleSessionExpiration)));
        }
        return config;
    }
}

