/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.fastjson2.support.redission;

import com.alibaba.fastjson2.JSONException;
import com.alibaba.fastjson2.JSONFactory;
import com.alibaba.fastjson2.JSONObject;
import com.alibaba.fastjson2.JSONReader;
import com.alibaba.fastjson2.JSONWriter;
import com.alibaba.fastjson2.writer.ObjectWriter;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.netty.buffer.ByteBufInputStream;
import io.netty.buffer.ByteBufOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Type;
import org.redisson.client.codec.BaseCodec;
import org.redisson.client.handler.State;
import org.redisson.client.protocol.Decoder;
import org.redisson.client.protocol.Encoder;

public class JSONBCodec
extends BaseCodec {
    final JSONEncoder encoder;
    final JSONDecoder decoder;

    public JSONBCodec(Type valueType) {
        this(JSONFactory.createWriteContext(), JSONFactory.createReadContext(), valueType);
    }

    public JSONBCodec(JSONWriter.Context writerContext, JSONReader.Context readerContext) {
        this(writerContext, readerContext, null);
    }

    public JSONBCodec(JSONWriter.Context writerContext, JSONReader.Context readerContext, Type valueType) {
        this(new JSONEncoder(writerContext), new JSONDecoder(readerContext, valueType));
    }

    public JSONBCodec(JSONEncoder encoder, JSONDecoder decoder) {
        this.encoder = encoder;
        this.decoder = decoder;
    }

    public Decoder<Object> getValueDecoder() {
        return this.decoder;
    }

    public Encoder getValueEncoder() {
        return this.encoder;
    }

    public static class JSONEncoder
    implements Encoder {
        final JSONWriter.Context context;

        public JSONEncoder(JSONWriter.Context context) {
            this.context = context;
        }

        public ByteBuf encode(Object object) throws IOException {
            ByteBuf byteBuf;
            block12: {
                JSONWriter writer = JSONWriter.ofJSONB((JSONWriter.Context)this.context);
                try {
                    if (object == null) {
                        writer.writeNull();
                    } else {
                        writer.setRootObject(object);
                        Class<?> valueClass = object.getClass();
                        if (valueClass == JSONObject.class && this.context.getFeatures() == 0L) {
                            writer.write((JSONObject)object);
                        } else {
                            ObjectWriter objectWriter = this.context.getObjectWriter(valueClass, valueClass);
                            objectWriter.write(writer, object, null, null, 0L);
                        }
                    }
                    int size = writer.size();
                    ByteBuf out = ByteBufAllocator.DEFAULT.buffer(size);
                    ByteBufOutputStream baos = new ByteBufOutputStream(out);
                    writer.flushTo((OutputStream)baos);
                    byteBuf = baos.buffer();
                    if (writer == null) break block12;
                }
                catch (Throwable throwable) {
                    try {
                        if (writer != null) {
                            try {
                                writer.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (NullPointerException | NumberFormatException e) {
                        throw new JSONException("JSON#toJSONString cannot serialize '" + object + "'", (Throwable)e);
                    }
                }
                writer.close();
            }
            return byteBuf;
        }
    }

    public static class JSONDecoder
    implements Decoder<Object> {
        final JSONReader.Context context;
        final Type valueType;

        public JSONDecoder(JSONReader.Context context, Type valueType) {
            this.context = context;
            this.valueType = valueType;
        }

        public Object decode(ByteBuf buf, State state) throws IOException {
            Object value;
            try (JSONReader jsonReader = JSONReader.ofJSONB((InputStream)new ByteBufInputStream(buf), (JSONReader.Context)this.context);){
                value = this.valueType == null || this.valueType == Object.class ? jsonReader.readAny() : jsonReader.read(this.valueType);
            }
            return value;
        }
    }
}

