/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.edas.acm;

import com.alibaba.edas.acm.exception.ConfigException;
import com.alibaba.edas.acm.listener.ConfigChangeListenerAdapter;
import com.alibaba.middleware.tls.util.TlsUtil;
import com.taobao.diamond.client.impl.DiamondEnvRepo;
import com.taobao.diamond.client.impl.ServerHttpAgent;
import com.taobao.diamond.client.impl.TenantUtil;
import com.taobao.diamond.exception.DiamondException;
import com.taobao.diamond.identify.CredentialService;
import com.taobao.diamond.utils.JSONUtils;
import com.taobao.diamond.utils.StringUtils;
import java.io.IOException;
import java.io.StringReader;
import java.util.Arrays;
import java.util.Properties;

public class ConfigService {
    public static void init(String domain, String namespace, String accessKey, String secretKey) {
        String isEnableStr = System.getProperty("tls.enable");
        if (StringUtils.isBlank(isEnableStr)) {
            TlsUtil.changeTlsEnable(true);
        }
        if (StringUtils.isNotEmpty(domain)) {
            ServerHttpAgent.domainName = domain;
        }
        if (StringUtils.isNotEmpty(namespace)) {
            TenantUtil.setUserTenant(namespace);
        }
        if (StringUtils.isNotEmpty(accessKey)) {
            CredentialService.getInstance().getCredential().setAccessKey(accessKey);
        }
        if (StringUtils.isNotEmpty(secretKey)) {
            CredentialService.getInstance().getCredential().setSecretKey(secretKey);
        }
    }

    public static void init() {
        String isEnableStr = System.getProperty("tls.enable");
        if (StringUtils.isBlank(isEnableStr)) {
            TlsUtil.changeTlsEnable(true);
        }
    }

    public static void addListener(String dataId, String group, ConfigChangeListenerAdapter listener) {
        DiamondEnvRepo.getDefaultEnv().addTenantListeners(dataId, group, Arrays.asList(listener));
    }

    public static void addGlobalListener(String dataId, String group, ConfigChangeListenerAdapter listener) {
        DiamondEnvRepo.getDefaultEnv().addListeners(dataId, group, Arrays.asList(listener));
    }

    public static String getConfig(String dataId, String group, long timeoutMs) throws ConfigException {
        try {
            return DiamondEnvRepo.getDefaultEnv().getTenantConfig(dataId, group, timeoutMs);
        }
        catch (DiamondException e) {
            throw new ConfigException(e.getErrCode(), e.getMessage());
        }
    }

    public static Properties getConfig2Properties(String dataId, String group, long timeoutMs) throws ConfigException {
        Properties properties = new Properties();
        try {
            String content = DiamondEnvRepo.getDefaultEnv().getTenantConfig(dataId, group, timeoutMs);
            try {
                properties.load(new StringReader(content));
            }
            catch (IOException e) {
                throw new ConfigException(e.getMessage());
            }
        }
        catch (DiamondException diamondException) {
            throw new ConfigException(diamondException.getErrCode(), diamondException.getMessage());
        }
        return properties;
    }

    public static Object getConfig(String dataId, String group, long timeoutMs, Class<?> clazz) throws ConfigException {
        try {
            String jsonStr = DiamondEnvRepo.getDefaultEnv().getTenantConfig(dataId, group, timeoutMs);
            Object result = JSONUtils.deserializeObject(jsonStr, clazz);
            return result;
        }
        catch (IOException e) {
            throw new ConfigException(e.getMessage());
        }
        catch (DiamondException diamondException) {
            throw new ConfigException(diamondException.getErrCode(), diamondException.getMessage());
        }
    }
}

