/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.dashscope.rerank;

import com.alibaba.dashscope.base.HalfDuplexServiceParam;
import com.alibaba.dashscope.exception.InputRequiredException;
import com.alibaba.dashscope.utils.JsonUtils;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class TextReRankParam
extends HalfDuplexServiceParam {
    private String query;
    private List<String> documents;
    private Integer topN;
    private Boolean returnDocuments;
    private String instruct;

    @Override
    public JsonObject getHttpBody() {
        JsonObject requestObject = new JsonObject();
        requestObject.addProperty("model", this.getModel());
        requestObject.add("input", (JsonElement)this.getInput());
        Map<String, Object> params = this.getParameters();
        if (params != null && !params.isEmpty()) {
            requestObject.add("parameters", (JsonElement)JsonUtils.parametersToJsonObject(params));
        }
        return requestObject;
    }

    public JsonObject getInput() {
        JsonObject jsonObject = new JsonObject();
        jsonObject.addProperty("query", this.query);
        jsonObject.add("documents", (JsonElement)JsonUtils.toJsonArray(this.documents));
        return jsonObject;
    }

    @Override
    public Map<String, Object> getParameters() {
        HashMap<String, Object> params = new HashMap<String, Object>();
        if (this.topN != null) {
            params.put("top_n", this.topN);
        }
        if (this.returnDocuments != null) {
            params.put("return_documents", this.returnDocuments);
        }
        if (this.instruct != null) {
            params.put("instruct", this.instruct);
        }
        params.putAll(this.parameters);
        return params;
    }

    @Override
    public ByteBuffer getBinaryData() {
        return null;
    }

    @Override
    public void validate() throws InputRequiredException {
        if (this.query == null || this.query.trim().isEmpty()) {
            throw new InputRequiredException("Query must not be null or empty!");
        }
        if (this.documents == null || this.documents.isEmpty()) {
            throw new InputRequiredException("Documents must not be null or empty!");
        }
    }

    protected TextReRankParam(TextReRankParamBuilder<?, ?> b) {
        super((HalfDuplexServiceParam.HalfDuplexServiceParamBuilder<?, ?>)b);
        List<Object> documents;
        this.query = ((TextReRankParamBuilder)b).query;
        switch (((TextReRankParamBuilder)b).documents == null ? 0 : ((TextReRankParamBuilder)b).documents.size()) {
            case 0: {
                documents = Collections.emptyList();
                break;
            }
            case 1: {
                documents = Collections.singletonList(((TextReRankParamBuilder)b).documents.get(0));
                break;
            }
            default: {
                documents = Collections.unmodifiableList(new ArrayList(((TextReRankParamBuilder)b).documents));
            }
        }
        this.documents = documents;
        this.topN = ((TextReRankParamBuilder)b).topN;
        this.returnDocuments = ((TextReRankParamBuilder)b).returnDocuments;
        this.instruct = ((TextReRankParamBuilder)b).instruct;
    }

    public static TextReRankParamBuilder<?, ?> builder() {
        return new TextReRankParamBuilderImpl();
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof TextReRankParam)) {
            return false;
        }
        TextReRankParam other = (TextReRankParam)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        Integer this$topN = this.getTopN();
        Integer other$topN = other.getTopN();
        if (this$topN == null ? other$topN != null : !((Object)this$topN).equals(other$topN)) {
            return false;
        }
        Boolean this$returnDocuments = this.getReturnDocuments();
        Boolean other$returnDocuments = other.getReturnDocuments();
        if (this$returnDocuments == null ? other$returnDocuments != null : !((Object)this$returnDocuments).equals(other$returnDocuments)) {
            return false;
        }
        String this$query = this.getQuery();
        String other$query = other.getQuery();
        if (this$query == null ? other$query != null : !this$query.equals(other$query)) {
            return false;
        }
        List<String> this$documents = this.getDocuments();
        List<String> other$documents = other.getDocuments();
        if (this$documents == null ? other$documents != null : !((Object)this$documents).equals(other$documents)) {
            return false;
        }
        String this$instruct = this.getInstruct();
        String other$instruct = other.getInstruct();
        return !(this$instruct == null ? other$instruct != null : !this$instruct.equals(other$instruct));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof TextReRankParam;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        Integer $topN = this.getTopN();
        result = result * 59 + ($topN == null ? 43 : ((Object)$topN).hashCode());
        Boolean $returnDocuments = this.getReturnDocuments();
        result = result * 59 + ($returnDocuments == null ? 43 : ((Object)$returnDocuments).hashCode());
        String $query = this.getQuery();
        result = result * 59 + ($query == null ? 43 : $query.hashCode());
        List<String> $documents = this.getDocuments();
        result = result * 59 + ($documents == null ? 43 : ((Object)$documents).hashCode());
        String $instruct = this.getInstruct();
        result = result * 59 + ($instruct == null ? 43 : $instruct.hashCode());
        return result;
    }

    public String getQuery() {
        return this.query;
    }

    public List<String> getDocuments() {
        return this.documents;
    }

    public Integer getTopN() {
        return this.topN;
    }

    public Boolean getReturnDocuments() {
        return this.returnDocuments;
    }

    public String getInstruct() {
        return this.instruct;
    }

    public void setQuery(String query) {
        this.query = query;
    }

    public void setDocuments(List<String> documents) {
        this.documents = documents;
    }

    public void setTopN(Integer topN) {
        this.topN = topN;
    }

    public void setReturnDocuments(Boolean returnDocuments) {
        this.returnDocuments = returnDocuments;
    }

    public void setInstruct(String instruct) {
        this.instruct = instruct;
    }

    @Override
    public String toString() {
        return "TextReRankParam(query=" + this.getQuery() + ", documents=" + this.getDocuments() + ", topN=" + this.getTopN() + ", returnDocuments=" + this.getReturnDocuments() + ", instruct=" + this.getInstruct() + ")";
    }

    private static final class TextReRankParamBuilderImpl
    extends TextReRankParamBuilder<TextReRankParam, TextReRankParamBuilderImpl> {
        private TextReRankParamBuilderImpl() {
        }

        @Override
        protected TextReRankParamBuilderImpl self() {
            return this;
        }

        @Override
        public TextReRankParam build() {
            return new TextReRankParam(this);
        }
    }

    public static abstract class TextReRankParamBuilder<C extends TextReRankParam, B extends TextReRankParamBuilder<C, B>>
    extends HalfDuplexServiceParam.HalfDuplexServiceParamBuilder<C, B> {
        private String query;
        private ArrayList<String> documents;
        private Integer topN;
        private Boolean returnDocuments;
        private String instruct;

        public B query(String query) {
            this.query = query;
            return (B)this.self();
        }

        public B document(String document) {
            if (this.documents == null) {
                this.documents = new ArrayList();
            }
            this.documents.add(document);
            return (B)this.self();
        }

        public B documents(Collection<? extends String> documents) {
            if (documents == null) {
                throw new NullPointerException("documents cannot be null");
            }
            if (this.documents == null) {
                this.documents = new ArrayList();
            }
            this.documents.addAll(documents);
            return (B)this.self();
        }

        public B clearDocuments() {
            if (this.documents != null) {
                this.documents.clear();
            }
            return (B)this.self();
        }

        public B topN(Integer topN) {
            this.topN = topN;
            return (B)this.self();
        }

        public B returnDocuments(Boolean returnDocuments) {
            this.returnDocuments = returnDocuments;
            return (B)this.self();
        }

        public B instruct(String instruct) {
            this.instruct = instruct;
            return (B)this.self();
        }

        @Override
        protected abstract B self();

        @Override
        public abstract C build();

        @Override
        public String toString() {
            return "TextReRankParam.TextReRankParamBuilder(super=" + super.toString() + ", query=" + this.query + ", documents=" + this.documents + ", topN=" + this.topN + ", returnDocuments=" + this.returnDocuments + ", instruct=" + this.instruct + ")";
        }
    }
}

