/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.csp.sentinel.command;

import com.alibaba.csp.sentinel.command.CommandHandler;
import com.alibaba.csp.sentinel.command.annotation.CommandMapping;
import com.alibaba.csp.sentinel.util.StringUtil;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.ServiceLoader;

public class CommandHandlerProvider
implements Iterable<CommandHandler> {
    private final ServiceLoader<CommandHandler> serviceLoader = ServiceLoader.load(CommandHandler.class);
    private static final CommandHandlerProvider INSTANCE = new CommandHandlerProvider();

    public Map<String, CommandHandler> namedHandlers() {
        HashMap<String, CommandHandler> map = new HashMap<String, CommandHandler>();
        for (CommandHandler handler : this.serviceLoader) {
            String name = this.parseCommandName(handler);
            if (StringUtil.isEmpty((String)name)) continue;
            map.put(name, handler);
        }
        return map;
    }

    private String parseCommandName(CommandHandler handler) {
        CommandMapping commandMapping = handler.getClass().getAnnotation(CommandMapping.class);
        if (commandMapping != null) {
            return commandMapping.name();
        }
        return null;
    }

    @Override
    public Iterator<CommandHandler> iterator() {
        return this.serviceLoader.iterator();
    }

    public static CommandHandlerProvider getInstance() {
        return INSTANCE;
    }
}

