/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.csp.sentinel.cluster.flow.statistic.limit;

import com.alibaba.csp.sentinel.slots.statistic.base.LeapArray;
import com.alibaba.csp.sentinel.slots.statistic.base.UnaryLeapArray;
import com.alibaba.csp.sentinel.util.AssertUtil;
import java.util.List;
import java.util.concurrent.atomic.LongAdder;

public class RequestLimiter {
    private double qpsAllowed;
    private final LeapArray<LongAdder> data;

    public RequestLimiter(double qpsAllowed) {
        this((LeapArray<LongAdder>)new UnaryLeapArray(10, 1000), qpsAllowed);
    }

    RequestLimiter(LeapArray<LongAdder> data, double qpsAllowed) {
        AssertUtil.isTrue((qpsAllowed >= 0.0 ? 1 : 0) != 0, (String)"max allowed QPS should > 0");
        this.data = data;
        this.qpsAllowed = qpsAllowed;
    }

    public void increment() {
        ((LongAdder)this.data.currentWindow().value()).increment();
    }

    public void add(int x) {
        ((LongAdder)this.data.currentWindow().value()).add(x);
    }

    public long getSum() {
        this.data.currentWindow();
        long success = 0L;
        List list = this.data.values();
        for (LongAdder window : list) {
            success += window.sum();
        }
        return success;
    }

    public double getQps() {
        return (double)this.getSum() / this.data.getIntervalInSecond();
    }

    public double getQpsAllowed() {
        return this.qpsAllowed;
    }

    public boolean canPass() {
        return this.getQps() + 1.0 <= this.qpsAllowed;
    }

    public RequestLimiter setQpsAllowed(double qpsAllowed) {
        this.qpsAllowed = qpsAllowed;
        return this;
    }

    public boolean tryPass() {
        if (this.canPass()) {
            this.add(1);
            return true;
        }
        return false;
    }
}

