/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.cloud.sentinel.datasource.config;

import com.alibaba.cloud.sentinel.datasource.config.AbstractDataSourceProperties;
import com.alibaba.cloud.sentinel.datasource.config.ApolloDataSourceProperties;
import com.alibaba.cloud.sentinel.datasource.config.FileDataSourceProperties;
import com.alibaba.cloud.sentinel.datasource.config.NacosDataSourceProperties;
import com.alibaba.cloud.sentinel.datasource.config.ZookeeperDataSourceProperties;
import com.fasterxml.jackson.annotation.JsonIgnore;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;
import javax.validation.Valid;
import org.springframework.util.ObjectUtils;

public class DataSourcePropertiesConfiguration {
    @Valid
    private FileDataSourceProperties file;
    @Valid
    private NacosDataSourceProperties nacos;
    @Valid
    private ZookeeperDataSourceProperties zk;
    @Valid
    private ApolloDataSourceProperties apollo;

    public DataSourcePropertiesConfiguration() {
    }

    public DataSourcePropertiesConfiguration(FileDataSourceProperties file) {
        this.file = file;
    }

    public DataSourcePropertiesConfiguration(NacosDataSourceProperties nacos) {
        this.nacos = nacos;
    }

    public DataSourcePropertiesConfiguration(ZookeeperDataSourceProperties zk) {
        this.zk = zk;
    }

    public DataSourcePropertiesConfiguration(ApolloDataSourceProperties apollo) {
        this.apollo = apollo;
    }

    public FileDataSourceProperties getFile() {
        return this.file;
    }

    public void setFile(FileDataSourceProperties file) {
        this.file = file;
    }

    public NacosDataSourceProperties getNacos() {
        return this.nacos;
    }

    public void setNacos(NacosDataSourceProperties nacos) {
        this.nacos = nacos;
    }

    public ZookeeperDataSourceProperties getZk() {
        return this.zk;
    }

    public void setZk(ZookeeperDataSourceProperties zk) {
        this.zk = zk;
    }

    public ApolloDataSourceProperties getApollo() {
        return this.apollo;
    }

    public void setApollo(ApolloDataSourceProperties apollo) {
        this.apollo = apollo;
    }

    @JsonIgnore
    public List<String> getValidField() {
        ArrayList<String> fieldList = new ArrayList<String>();
        for (Field field : this.getClass().getDeclaredFields()) {
            try {
                if (ObjectUtils.isEmpty((Object)field.get(this))) continue;
                fieldList.add(field.getName());
            }
            catch (IllegalAccessException illegalAccessException) {
                // empty catch block
            }
        }
        return fieldList;
    }

    @JsonIgnore
    public AbstractDataSourceProperties getValidDataSourceProperties() {
        List<String> invalidFields = this.getValidField();
        if (invalidFields.size() == 1) {
            try {
                this.getClass().getDeclaredField(invalidFields.get(0)).setAccessible(true);
                return (AbstractDataSourceProperties)this.getClass().getDeclaredField(invalidFields.get(0)).get(this);
            }
            catch (IllegalAccessException illegalAccessException) {
            }
            catch (NoSuchFieldException noSuchFieldException) {
                // empty catch block
            }
        }
        return null;
    }
}

