/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.cloud.ai.toolcalling.weather;

import cn.hutool.extra.pinyin.PinyinUtil;
import com.alibaba.cloud.ai.toolcalling.common.CommonToolCallUtils;
import com.alibaba.cloud.ai.toolcalling.common.JsonParseTool;
import com.alibaba.cloud.ai.toolcalling.common.WebClientTool;
import com.fasterxml.jackson.annotation.JsonClassDescription;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.core.type.TypeReference;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.MultiValueMap;
import org.springframework.util.StringUtils;

public class WeatherService
implements Function<Request, Response> {
    private static final Logger logger = LoggerFactory.getLogger(WeatherService.class);
    private final WebClientTool webClientTool;
    private final JsonParseTool jsonParseTool;

    public WeatherService(WebClientTool webClientTool, JsonParseTool jsonParseTool) {
        this.webClientTool = webClientTool;
        this.jsonParseTool = jsonParseTool;
    }

    public static Response fromJson(Map<String, Object> json) {
        Map location = (Map)json.get("location");
        Map current = (Map)json.get("current");
        Map forecast = (Map)json.get("forecast");
        List forecastDays = (List)forecast.get("forecastday");
        String city = (String)location.get("name");
        return new Response(city, current, forecastDays);
    }

    @Override
    public Response apply(Request request) {
        if (request == null || !StringUtils.hasText((String)request.city())) {
            logger.error("Invalid request: city is required.");
            return null;
        }
        String location = this.preprocessLocation(request.city());
        try {
            String path = "v1/forecast.json";
            MultiValueMap params = CommonToolCallUtils.multiValueMapBuilder().add((Object)"q", (Object)location).add((Object)"days", (Object)String.valueOf(request.days())).build();
            String jsonResponse = (String)this.webClientTool.get(path, params).block();
            Response response = WeatherService.fromJson((Map)this.jsonParseTool.jsonToObject(jsonResponse, (TypeReference)new TypeReference<Map<String, Object>>(){}));
            logger.info("Weather data fetched successfully for city: {}", (Object)response.city());
            return response;
        }
        catch (Exception e) {
            logger.error("Failed to fetch weather data: {}", (Object)e.getMessage());
            return null;
        }
    }

    private String preprocessLocation(String location) {
        if (this.containsChinese(location)) {
            return PinyinUtil.getPinyin((String)location, (String)"");
        }
        return location;
    }

    private boolean containsChinese(String str) {
        return str.matches(".*[\u4e00-\u9fa5].*");
    }

    @JsonClassDescription(value="Weather Service API response")
    public record Response(String city, Map<String, Object> current, List<Map<String, Object>> forecastDays) {
    }

    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonClassDescription(value="Weather Service API request")
    public record Request(@JsonProperty(required=true, value="city") @JsonPropertyDescription(value="THE CITY OF INQUIRY") String city, @JsonProperty(required=false, value="days") @JsonPropertyDescription(value="The number of days for which the weather is forecasted") int days) {
    }
}

