/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.cloud.ai.toolcalling.tavily;

import com.alibaba.cloud.ai.toolcalling.common.CommonToolCallProperties;
import com.alibaba.cloud.ai.toolcalling.common.JsonParseTool;
import com.alibaba.cloud.ai.toolcalling.common.WebClientTool;
import com.alibaba.cloud.ai.toolcalling.tavily.TavilySearchProperties;
import com.alibaba.cloud.ai.toolcalling.tavily.TavilySearchService;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Description;

@Configuration
@EnableConfigurationProperties(value={TavilySearchProperties.class})
@ConditionalOnClass(value={TavilySearchService.class})
@ConditionalOnProperty(prefix="spring.ai.alibaba.toolcalling.tavilysearch", name={"enabled"}, havingValue="true", matchIfMissing=true)
public class TavilySearchAutoConfiguration {
    @Bean(name={"tavilySearch"})
    @ConditionalOnMissingBean
    @Description(value="Provides a TavilySearchService bean for performing searches using the Tavily search engine.")
    public TavilySearchService tavilySearch(TavilySearchProperties properties, JsonParseTool jsonParseTool) {
        WebClientTool webClientTool = WebClientTool.builder((JsonParseTool)jsonParseTool, (CommonToolCallProperties)properties).httpHeadersConsumer(httpHeaders -> {
            httpHeaders.add("Authorization", "Bearer " + properties.getApiKey());
            httpHeaders.add("Content-Type", "application/json");
        }).build();
        return new TavilySearchService(jsonParseTool, webClientTool);
    }
}

