/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.cloud.ai.toolcalling.baidutranslate;

import com.alibaba.cloud.ai.toolcalling.baidutranslate.BaiduTranslateProperties;
import com.alibaba.cloud.ai.toolcalling.baidutranslate.BaiduTranslateService;
import com.alibaba.cloud.ai.toolcalling.common.CommonToolCallProperties;
import com.alibaba.cloud.ai.toolcalling.common.JsonParseTool;
import com.alibaba.cloud.ai.toolcalling.common.RestClientTool;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Description;

@Configuration
@EnableConfigurationProperties(value={BaiduTranslateProperties.class})
@ConditionalOnProperty(prefix="spring.ai.alibaba.toolcalling.baidu.translate", name={"enabled"}, havingValue="true", matchIfMissing=true)
public class BaiduTranslateAutoConfiguration {
    @Bean(name={"baiduTranslate"})
    @ConditionalOnMissingBean
    @Description(value="Baidu translation function for general text translation")
    public BaiduTranslateService baiduTranslate(BaiduTranslateProperties properties, JsonParseTool jsonParseTool) {
        return new BaiduTranslateService(properties, RestClientTool.builder((JsonParseTool)jsonParseTool, (CommonToolCallProperties)properties).build(), jsonParseTool);
    }
}

