/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.cloud.ai.toolcalling.baidumap;

import com.alibaba.cloud.ai.toolcalling.baidumap.BaiDuMapProperties;
import java.net.URI;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;

public class MapTools {
    private final String baseUrl = "https://api.map.baidu.com";
    private final BaiDuMapProperties baiDuMapProperties;
    private final HttpClient httpClient;

    public MapTools(BaiDuMapProperties baiDuMapProperties) {
        this.baiDuMapProperties = baiDuMapProperties;
        this.httpClient = HttpClient.newBuilder().version(HttpClient.Version.HTTP_2).build();
        if (Objects.isNull(baiDuMapProperties.getWebApiKey())) {
            throw new RuntimeException("Please configure your BaiDuMap API key in the application.yml file.");
        }
    }

    public String getAddressCityCode(String address) {
        String path = String.format("/api_region_search/v1/?ak=%s&keyword=%s&sub_admin=0&extensions_code=1", this.baiDuMapProperties.getWebApiKey(), address);
        HttpRequest httpRequest = this.createGetRequest(path);
        CompletableFuture<HttpResponse<String>> responseFuture = this.httpClient.sendAsync(httpRequest, HttpResponse.BodyHandlers.ofString());
        HttpResponse<String> response = responseFuture.join();
        if (response.statusCode() != 200) {
            throw new RuntimeException("Failed to get address city code");
        }
        return response.body();
    }

    public String getWeather(String cityCode) {
        String path = String.format("/weather/v1/?ak=%s&district_id=%s&data_type=%s", this.baiDuMapProperties.getWebApiKey(), cityCode, "all");
        HttpRequest httpRequest = this.createGetRequest(path);
        CompletableFuture<HttpResponse<String>> responseFuture = this.httpClient.sendAsync(httpRequest, HttpResponse.BodyHandlers.ofString());
        HttpResponse<String> response = responseFuture.join();
        if (response.statusCode() != 200) {
            throw new RuntimeException("Failed to get weather information");
        }
        return response.body();
    }

    public String getFacilityInformation(String address, String facilityType) {
        String path = String.format("/place/v2/search?query=%s&region=%s&output=json&ak=%s", facilityType, address, this.baiDuMapProperties.getWebApiKey());
        HttpRequest httpRequest = this.createGetRequest(path);
        CompletableFuture<HttpResponse<String>> responseFuture = this.httpClient.sendAsync(httpRequest, HttpResponse.BodyHandlers.ofString());
        HttpResponse<String> response = responseFuture.join();
        if (response.statusCode() != 200) {
            throw new RuntimeException("Failed to get facility information");
        }
        return response.body();
    }

    private HttpRequest createGetRequest(String path) {
        URI uri = URI.create("https://api.map.baidu.com" + path);
        return HttpRequest.newBuilder().uri(uri).GET().build();
    }
}

