/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.cloud.ai.toolcalling.baidumap;

import com.alibaba.cloud.ai.toolcalling.baidumap.BaiDuMapProperties;
import com.alibaba.cloud.ai.toolcalling.baidumap.MapTools;
import com.fasterxml.jackson.annotation.JsonClassDescription;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.JsonSyntaxException;
import java.util.function.Function;

public class MapSearchService
implements Function<Request, Response> {
    private final MapTools mapTools;

    public MapSearchService(BaiDuMapProperties baiDuMapProperties) {
        this.mapTools = new MapTools(baiDuMapProperties);
    }

    @Override
    public Response apply(Request request) {
        Gson gson = new Gson();
        try {
            JsonObject jsonObject = new JsonObject();
            String addressCityCodeResponse = this.mapTools.getAddressCityCode(request.address);
            JsonObject cityCodeJson = JsonParser.parseString((String)addressCityCodeResponse).getAsJsonObject();
            JsonElement districtsElement = cityCodeJson.get("districts");
            if (districtsElement != null && districtsElement.isJsonArray()) {
                JsonArray districtsArray = districtsElement.getAsJsonArray();
                if (districtsArray.isEmpty()) {
                    return new Response("No districts found in the response.");
                }
                for (JsonElement districtElement : districtsArray) {
                    String adcode;
                    JsonObject district = districtElement.getAsJsonObject();
                    JsonElement adcodeElement = district.get("adcode");
                    if (adcodeElement == null || adcodeElement.isJsonNull() || (adcode = adcodeElement.getAsString()).isEmpty()) continue;
                    String weather = this.mapTools.getWeather(adcode);
                    jsonObject.addProperty("weather", weather);
                }
                String facilityJsonStr = this.mapTools.getFacilityInformation(request.address, request.facilityType);
                JsonElement facilityElement = JsonParser.parseString((String)facilityJsonStr);
                JsonElement resultsElement = facilityElement.getAsJsonObject().get("results");
                if (resultsElement != null && resultsElement.isJsonArray()) {
                    jsonObject.add("facilityInformation", (JsonElement)resultsElement.getAsJsonArray());
                } else {
                    jsonObject.addProperty("facilityInformation", "No facility information found.");
                }
                return new Response(gson.toJson((JsonElement)jsonObject));
            }
            return new Response("No districts found in the response.");
        }
        catch (JsonSyntaxException e) {
            return new Response("Invalid JSON format: " + e.getMessage());
        }
        catch (Exception e) {
            return new Response("Error occurred while processing the request: " + e.getMessage());
        }
    }

    @JsonClassDescription(value="Get the weather conditions for a specified address and facility type.")
    public record Request(@JsonProperty(required=true, value="address") @JsonPropertyDescription(value="The address") String address, @JsonProperty(required=true, value="facilityType") @JsonPropertyDescription(value="The type of facility (e.g., bank, airport, restaurant)") String facilityType) {
    }

    public record Response(String message) {
    }
}

