/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.cloud.ai.vectorstore.analyticdb;

import java.util.List;
import org.springframework.ai.vectorstore.filter.Filter;
import org.springframework.ai.vectorstore.filter.converter.AbstractFilterExpressionConverter;

public class AdVectorFilterExpressionConverter
extends AbstractFilterExpressionConverter {
    protected void doExpression(Filter.Expression expression, StringBuilder context) {
        if (expression.type() == Filter.ExpressionType.IN) {
            this.handleIn(expression, context);
        } else if (expression.type() == Filter.ExpressionType.NIN) {
            this.handleNotIn(expression, context);
        } else {
            this.convertOperand(expression.left(), context);
            context.append(this.getOperationSymbol(expression));
            this.convertOperand(expression.right(), context);
        }
    }

    private void handleIn(Filter.Expression expression, StringBuilder context) {
        context.append("(");
        this.convertToConditions(expression, context);
        context.append(")");
    }

    private void convertToConditions(Filter.Expression expression, StringBuilder context) {
        Filter.Value right = (Filter.Value)expression.right();
        Object value = right.value();
        if (!(value instanceof List)) {
            throw new IllegalArgumentException("Expected a List, but got: " + value.getClass().getSimpleName());
        }
        List values = (List)value;
        for (int i = 0; i < values.size(); ++i) {
            this.convertOperand(expression.left(), context);
            context.append(" == ");
            this.doSingleValue(values.get(i), context);
            if (i >= values.size() - 1) continue;
            context.append(" || ");
        }
    }

    private void handleNotIn(Filter.Expression expression, StringBuilder context) {
        context.append("!(");
        this.convertToConditions(expression, context);
        context.append(")");
    }

    private String getOperationSymbol(Filter.Expression exp) {
        switch (exp.type()) {
            case AND: {
                return " && ";
            }
            case OR: {
                return " || ";
            }
            case EQ: {
                return " = ";
            }
            case NE: {
                return " != ";
            }
            case LT: {
                return " < ";
            }
            case LTE: {
                return " <= ";
            }
            case GT: {
                return " > ";
            }
            case GTE: {
                return " >= ";
            }
        }
        throw new RuntimeException("Not supported expression type: " + exp.type());
    }

    protected void doKey(Filter.Key key, StringBuilder context) {
        context.append("$." + key.key());
    }

    protected void doStartGroup(Filter.Group group, StringBuilder context) {
        context.append("(");
    }

    protected void doEndGroup(Filter.Group group, StringBuilder context) {
        context.append(")");
    }
}

