/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.cloud.ai.memory.jdbc;

import com.alibaba.cloud.ai.memory.jdbc.JdbcChatMemoryRepository;
import org.springframework.jdbc.core.JdbcTemplate;

public class OracleChatMemoryRepository
extends JdbcChatMemoryRepository {
    private static final String ORACLE_QUERY_ADD = "INSERT INTO ai_chat_memory (conversation_id, content, type, timestamp) VALUES (?, ?, ?, ?)";
    private static final String ORACLE_QUERY_GET = "SELECT content, type FROM ai_chat_memory WHERE conversation_id = ? ORDER BY timestamp";

    private OracleChatMemoryRepository(JdbcTemplate jdbcTemplate) {
        super(jdbcTemplate);
    }

    public static OracleBuilder oracleBuilder() {
        return new OracleBuilder();
    }

    @Override
    protected String hasTableSql(String tableName) {
        return String.format("SELECT table_name FROM all_tables WHERE table_name = UPPER('%s')", tableName);
    }

    @Override
    protected String createTableSql(String tableName) {
        return String.format("CREATE TABLE %s (id NUMBER(19) GENERATED ALWAYS AS IDENTITY PRIMARY KEY, conversation_id VARCHAR2(256) NOT NULL, content CLOB NOT NULL, type VARCHAR2(100) NOT NULL, timestamp TIMESTAMP NOT NULL, CONSTRAINT chk_message_type CHECK (type IN ('USER', 'ASSISTANT', 'SYSTEM', 'TOOL')))", tableName);
    }

    @Override
    protected String getAddSql() {
        return ORACLE_QUERY_ADD;
    }

    @Override
    protected String getGetSql() {
        return ORACLE_QUERY_GET;
    }

    public static class OracleBuilder {
        private JdbcTemplate jdbcTemplate;

        public OracleBuilder jdbcTemplate(JdbcTemplate jdbcTemplate) {
            this.jdbcTemplate = jdbcTemplate;
            return this;
        }

        public OracleChatMemoryRepository build() {
            return new OracleChatMemoryRepository(this.jdbcTemplate);
        }
    }
}

