/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.cloud.ai.observation.model;

import io.micrometer.tracing.handler.TracingObservationHandler;
import io.opentelemetry.api.trace.Span;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.lang.Nullable;

public final class OpenTelemetrySpanBridge {
    private static final Logger logger = LoggerFactory.getLogger(OpenTelemetrySpanBridge.class);
    private static Method toOtelMethod;

    @Nullable
    public static Span retrieveOtelSpan(@Nullable TracingObservationHandler.TracingContext tracingContext) {
        if (tracingContext == null) {
            return null;
        }
        io.micrometer.tracing.Span micrometerSpan = tracingContext.getSpan();
        try {
            Object otelSpanObject;
            if (toOtelMethod == null) {
                Method method = tracingContext.getSpan().getClass().getDeclaredMethod("toOtel", io.micrometer.tracing.Span.class);
                method.setAccessible(true);
                toOtelMethod = method;
            }
            if ((otelSpanObject = toOtelMethod.invoke(null, micrometerSpan)) instanceof Span) {
                Span otelSpan = (Span)otelSpanObject;
                return otelSpan;
            }
        }
        catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException ex) {
            logger.warn("Failed to retrieve the OpenTelemetry Span from Micrometer context", (Throwable)ex);
            return null;
        }
        return null;
    }
}

