/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.cloud.ai.service;

import com.alibaba.cloud.ai.connector.accessor.Accessor;
import com.alibaba.cloud.ai.connector.bo.ColumnInfoBO;
import com.alibaba.cloud.ai.connector.bo.DbQueryParameter;
import com.alibaba.cloud.ai.connector.bo.ForeignKeyInfoBO;
import com.alibaba.cloud.ai.connector.bo.TableInfoBO;
import com.alibaba.cloud.ai.connector.config.DbConfig;
import com.alibaba.cloud.ai.dashscope.api.DashScopeApi;
import com.alibaba.cloud.ai.dashscope.embedding.DashScopeEmbeddingModel;
import com.alibaba.cloud.ai.dashscope.embedding.DashScopeEmbeddingOptions;
import com.alibaba.cloud.ai.request.DeleteRequest;
import com.alibaba.cloud.ai.request.EvidenceRequest;
import com.alibaba.cloud.ai.request.SchemaInitRequest;
import com.alibaba.cloud.ai.service.VectorStoreManagementService;
import com.google.gson.Gson;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import java.util.stream.Collectors;
import org.springframework.ai.document.Document;
import org.springframework.ai.document.MetadataMode;
import org.springframework.ai.embedding.EmbeddingModel;
import org.springframework.ai.vectorstore.SearchRequest;
import org.springframework.ai.vectorstore.SimpleVectorStore;
import org.springframework.ai.vectorstore.filter.Filter;
import org.springframework.ai.vectorstore.filter.FilterExpressionBuilder;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
public class SimpleVectorStoreManagementService
implements VectorStoreManagementService {
    private final SimpleVectorStore vectorStore;
    private final Gson gson;
    private final Accessor dbAccessor;
    private final DbConfig dbConfig;

    @Autowired
    public SimpleVectorStoreManagementService(@Value(value="${spring.ai.dashscope.api-key:default_api_key}") String apiKey, Gson gson, @Qualifier(value="mysqlAccessor") Accessor dbAccessor, DbConfig dbConfig) {
        this.gson = gson;
        this.dbAccessor = dbAccessor;
        this.dbConfig = dbConfig;
        DashScopeApi dashScopeApi = DashScopeApi.builder().apiKey(apiKey).build();
        DashScopeEmbeddingModel dashScopeEmbeddingModel = new DashScopeEmbeddingModel(dashScopeApi, MetadataMode.EMBED, DashScopeEmbeddingOptions.builder().withModel(DashScopeApi.EmbeddingModel.EMBEDDING_V4.getValue()).build());
        this.vectorStore = SimpleVectorStore.builder((EmbeddingModel)dashScopeEmbeddingModel).build();
    }

    @Override
    public Boolean schema(SchemaInitRequest schemaInitRequest) throws Exception {
        DbConfig dbConfig = schemaInitRequest.getDbConfig();
        DbQueryParameter dqp = DbQueryParameter.from((DbConfig)dbConfig).setSchema(dbConfig.getSchema()).setTables(schemaInitRequest.getTables());
        DeleteRequest deleteRequest = new DeleteRequest();
        deleteRequest.setVectorType("column");
        this.deleteDocuments(deleteRequest);
        deleteRequest.setVectorType("table");
        this.deleteDocuments(deleteRequest);
        List foreignKeyInfoBOS = this.dbAccessor.showForeignKeys(dbConfig, dqp);
        Map<String, List<String>> foreignKeyMap = this.buildForeignKeyMap(foreignKeyInfoBOS);
        List tableInfoBOS = this.dbAccessor.fetchTables(dbConfig, dqp);
        for (TableInfoBO tableInfoBO : tableInfoBOS) {
            this.processTable(tableInfoBO, dqp, dbConfig);
        }
        List columnDocuments = tableInfoBOS.stream().flatMap(table -> {
            try {
                return this.dbAccessor.showColumns(dbConfig, dqp).stream().map(column -> this.convertToDocument((TableInfoBO)table, (ColumnInfoBO)column));
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }).collect(Collectors.toList());
        this.vectorStore.add(columnDocuments);
        List tableDocuments = tableInfoBOS.stream().map(this::convertTableToDocument).collect(Collectors.toList());
        this.vectorStore.add(tableDocuments);
        return true;
    }

    @Override
    public Boolean addEvidence(List<EvidenceRequest> evidenceRequests) {
        ArrayList<Document> evidences = new ArrayList<Document>();
        for (EvidenceRequest req : evidenceRequests) {
            Document doc = new Document(UUID.randomUUID().toString(), req.getContent(), Map.of("evidenceType", req.getType(), "vectorType", "evidence"));
            evidences.add(doc);
        }
        this.vectorStore.add(evidences);
        return true;
    }

    private void processTable(TableInfoBO tableInfoBO, DbQueryParameter dqp, DbConfig dbConfig) throws Exception {
        dqp.setTable(tableInfoBO.getName());
        List columnInfoBOS = this.dbAccessor.showColumns(dbConfig, dqp);
        for (ColumnInfoBO columnInfoBO : columnInfoBOS) {
            dqp.setColumn(columnInfoBO.getName());
            List<String> sampleColumn = this.dbAccessor.sampleColumn(dbConfig, dqp);
            sampleColumn = ((List)Optional.ofNullable(sampleColumn).orElse(new ArrayList())).stream().filter(Objects::nonNull).distinct().limit(3L).filter(s -> s.length() <= 100).toList();
            columnInfoBO.setTableName(tableInfoBO.getName());
            columnInfoBO.setSamples(this.gson.toJson(sampleColumn));
        }
        ColumnInfoBO primaryColumnDO = columnInfoBOS.stream().filter(ColumnInfoBO::isPrimary).findFirst().orElse(new ColumnInfoBO());
        tableInfoBO.setPrimaryKey(primaryColumnDO.getName());
        tableInfoBO.setForeignKey(String.join((CharSequence)"\u3001", this.buildForeignKeyList(tableInfoBO.getName())));
    }

    public Document convertToDocument(TableInfoBO tableInfoBO, ColumnInfoBO columnInfoBO) {
        String text = Optional.ofNullable(columnInfoBO.getDescription()).orElse(columnInfoBO.getName());
        Map<String, String> metadata = Map.of("name", columnInfoBO.getName(), "tableName", tableInfoBO.getName(), "description", Optional.ofNullable(columnInfoBO.getDescription()).orElse(""), "type", columnInfoBO.getType(), "primary", columnInfoBO.isPrimary(), "notnull", columnInfoBO.isNotnull(), "vectorType", "column");
        if (columnInfoBO.getSamples() != null) {
            metadata.put("samples", columnInfoBO.getSamples());
        }
        return new Document(columnInfoBO.getName(), text, metadata);
    }

    private List<String> buildForeignKeyList(String tableName) {
        return new ArrayList<String>();
    }

    public Document convertTableToDocument(TableInfoBO tableInfoBO) {
        String text = Optional.ofNullable(tableInfoBO.getDescription()).orElse(tableInfoBO.getName());
        Map<String, String> metadata = Map.of("schema", Optional.ofNullable(tableInfoBO.getSchema()).orElse(""), "name", tableInfoBO.getName(), "description", Optional.ofNullable(tableInfoBO.getDescription()).orElse(""), "foreignKey", Optional.ofNullable(tableInfoBO.getForeignKey()).orElse(""), "primaryKey", Optional.ofNullable(tableInfoBO.getPrimaryKey()).orElse(""), "vectorType", "table");
        return new Document(tableInfoBO.getName(), text, metadata);
    }

    private Map<String, List<String>> buildForeignKeyMap(List<ForeignKeyInfoBO> foreignKeyInfoBOS) {
        HashMap<String, List<String>> foreignKeyMap = new HashMap<String, List<String>>();
        for (ForeignKeyInfoBO fk : foreignKeyInfoBOS) {
            String key = fk.getTable() + "." + fk.getColumn() + "=" + fk.getReferencedTable() + "." + fk.getReferencedColumn();
            foreignKeyMap.computeIfAbsent(fk.getTable(), k -> new ArrayList()).add(key);
            foreignKeyMap.computeIfAbsent(fk.getReferencedTable(), k -> new ArrayList()).add(key);
        }
        return foreignKeyMap;
    }

    @Override
    public Boolean deleteDocuments(DeleteRequest deleteRequest) throws Exception {
        try {
            if (deleteRequest.getId() != null && !deleteRequest.getId().isEmpty()) {
                this.vectorStore.delete(Arrays.asList(deleteRequest.getId()));
            } else if (deleteRequest.getVectorType() != null && !deleteRequest.getVectorType().isEmpty()) {
                FilterExpressionBuilder b = new FilterExpressionBuilder();
                Filter.Expression expression = b.eq("vectorType", (Object)"column").build();
                List documents = this.vectorStore.similaritySearch(SearchRequest.builder().topK(Integer.MAX_VALUE).filterExpression(expression).build());
                this.vectorStore.delete(documents.stream().map(Document::getId).toList());
            } else {
                throw new IllegalArgumentException("Either id or vectorType must be specified.");
            }
            return true;
        }
        catch (Exception e) {
            throw new Exception("Failed to delete collection data by filterExpression: " + e.getMessage(), e);
        }
    }

    public List<Document> search(SearchRequest searchRequest) throws Exception {
        try {
            return this.vectorStore.similaritySearch(searchRequest).stream().filter(document -> document.getScore() > 0.2).toList();
        }
        catch (Exception e) {
            throw new Exception("Failed to search vector store: " + e.getMessage(), e);
        }
    }
}

