/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.cloud.ai.service;

import com.alibaba.cloud.ai.entity.BusinessKnowledge;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicLong;
import java.util.stream.Collectors;
import org.springframework.stereotype.Service;

@Service
public class BusinessKnowledgeService {
    private final Map<Long, BusinessKnowledge> knowledgeStore = new ConcurrentHashMap<Long, BusinessKnowledge>();
    private final AtomicLong idGenerator = new AtomicLong(1L);

    public BusinessKnowledgeService() {
        this.initSampleData();
    }

    private void initSampleData() {
        this.save(new BusinessKnowledge("\u5e74\u9f84\u5206\u5e03", "\u5206\u522b\u8ba1\u7b97\u52b3\u52a8\u4eba\u53e3\u5360\u6bd4\uff0c\u5c11\u5e74\u513f\u7ae5\u5360\u6bd4\uff0c\u8001\u5e74\u4eba\u53e3\u5360\u6bd4\u4e09\u4e2a\u5b57\u6bb5\u6307\u6807\u7684\u5e73\u5747\u503c", "\u5e74\u9f84\u753b\u50cf,\u5e74\u9f84\u6784\u6210,\u5e74\u9f84\u7ed3\u6784", true, "dataset_001"));
        this.save(new BusinessKnowledge("\u641c\u7d22\u4e1a\u7ee9\u53e3\u5f84", "\u5b9a\u4e49\uff1a\u8ba2\u5355/\u6d41\u91cf\u8ba1\u5165\u641c\u7d22", "\u641c\u7d22\u4e1a\u7ee9,\u641c\u7d22\u53e3\u5f84", false, "dataset_001"));
        this.save(new BusinessKnowledge("GMV", "\u5546\u54c1\u4ea4\u6613\u603b\u989d\uff0c\u5305\u542b\u4ed8\u6b3e\u548c\u672a\u4ed8\u6b3e\u7684\u8ba2\u5355\u91d1\u989d", "\u4ea4\u6613\u603b\u989d,\u6210\u4ea4\u603b\u989d", true, "dataset_002"));
    }

    public List<BusinessKnowledge> findAll() {
        return new ArrayList<BusinessKnowledge>(this.knowledgeStore.values());
    }

    public List<BusinessKnowledge> findByDatasetId(String datasetId) {
        return this.knowledgeStore.values().stream().filter(k -> Objects.equals(k.getDatasetId(), datasetId)).collect(Collectors.toList());
    }

    public BusinessKnowledge findById(Long id) {
        return this.knowledgeStore.get(id);
    }

    public BusinessKnowledge save(BusinessKnowledge knowledge) {
        if (knowledge.getId() == null) {
            knowledge.setId(this.idGenerator.getAndIncrement());
            knowledge.setCreateTime(LocalDateTime.now());
        }
        knowledge.setUpdateTime(LocalDateTime.now());
        this.knowledgeStore.put(knowledge.getId(), knowledge);
        return knowledge;
    }

    public void deleteById(Long id) {
        this.knowledgeStore.remove(id);
    }

    public List<BusinessKnowledge> search(String keyword) {
        if (keyword == null || keyword.trim().isEmpty()) {
            return this.findAll();
        }
        String lowerKeyword = keyword.toLowerCase();
        return this.knowledgeStore.values().stream().filter(k -> k.getBusinessTerm().toLowerCase().contains(lowerKeyword) || k.getDescription().toLowerCase().contains(lowerKeyword) || k.getSynonyms() != null && k.getSynonyms().toLowerCase().contains(lowerKeyword)).collect(Collectors.toList());
    }
}

