/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.cloud.ai.controller;

import com.alibaba.cloud.ai.connector.config.DbConfig;
import com.alibaba.cloud.ai.request.SchemaInitRequest;
import com.alibaba.cloud.ai.service.simple.SimpleNl2SqlService;
import com.alibaba.cloud.ai.service.simple.SimpleVectorStoreService;
import java.util.Arrays;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RestController;

@RestController
public class SimpleChatController {
    private final SimpleNl2SqlService simpleNl2SqlService;
    private final SimpleVectorStoreService simpleVectorStoreService;
    private final DbConfig dbConfig;

    public SimpleChatController(SimpleNl2SqlService simpleNl2SqlService, SimpleVectorStoreService simpleVectorStoreService, DbConfig dbConfig) {
        this.simpleNl2SqlService = simpleNl2SqlService;
        this.simpleVectorStoreService = simpleVectorStoreService;
        this.dbConfig = dbConfig;
    }

    @PostMapping(value={"/simpleChat"})
    public String simpleNl2Sql(@RequestBody String input) throws Exception {
        SchemaInitRequest schemaInitRequest = new SchemaInitRequest();
        schemaInitRequest.setDbConfig(this.dbConfig);
        schemaInitRequest.setTables(Arrays.asList("categories", "order_items", "orders", "products", "users", "product_categories"));
        this.simpleVectorStoreService.schema(schemaInitRequest);
        return this.simpleNl2SqlService.nl2sql(input);
    }
}

