/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.cloud.ai.controller;

import com.alibaba.cloud.ai.entity.AgentPresetQuestion;
import com.alibaba.cloud.ai.service.AgentPresetQuestionService;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.CrossOrigin;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/agent"})
@CrossOrigin(origins={"*"})
public class AgentPresetQuestionController {
    private static final Logger logger = LoggerFactory.getLogger(AgentPresetQuestionController.class);
    private final AgentPresetQuestionService presetQuestionService;

    public AgentPresetQuestionController(AgentPresetQuestionService presetQuestionService) {
        this.presetQuestionService = presetQuestionService;
    }

    @GetMapping(value={"/{agentId}/preset-questions"})
    public ResponseEntity<List<AgentPresetQuestion>> getPresetQuestions(@PathVariable Long agentId) {
        try {
            List<AgentPresetQuestion> questions = this.presetQuestionService.findByAgentId(agentId);
            return ResponseEntity.ok(questions);
        }
        catch (Exception e) {
            logger.error("Error getting preset questions for agent {}", (Object)agentId, (Object)e);
            return ResponseEntity.internalServerError().build();
        }
    }

    @PostMapping(value={"/{agentId}/preset-questions"})
    public ResponseEntity<Map<String, String>> savePresetQuestions(@PathVariable Long agentId, @RequestBody List<Map<String, String>> questionsData) {
        try {
            List<AgentPresetQuestion> questions = questionsData.stream().map(data -> {
                AgentPresetQuestion question = new AgentPresetQuestion();
                question.setQuestion((String)data.get("question"));
                return question;
            }).toList();
            this.presetQuestionService.batchSave(agentId, questions);
            return ResponseEntity.ok(Map.of("message", "\u9884\u8bbe\u95ee\u9898\u4fdd\u5b58\u6210\u529f"));
        }
        catch (Exception e) {
            logger.error("Error saving preset questions for agent {}", (Object)agentId, (Object)e);
            return ResponseEntity.internalServerError().body(Map.of("error", "\u4fdd\u5b58\u9884\u8bbe\u95ee\u9898\u5931\u8d25: " + e.getMessage()));
        }
    }

    @DeleteMapping(value={"/{agentId}/preset-questions/{questionId}"})
    public ResponseEntity<Map<String, String>> deletePresetQuestion(@PathVariable Long agentId, @PathVariable Long questionId) {
        try {
            this.presetQuestionService.deleteById(questionId);
            return ResponseEntity.ok(Map.of("message", "\u9884\u8bbe\u95ee\u9898\u5220\u9664\u6210\u529f"));
        }
        catch (Exception e) {
            logger.error("Error deleting preset question {} for agent {}", new Object[]{questionId, agentId, e});
            return ResponseEntity.internalServerError().body(Map.of("error", "\u5220\u9664\u9884\u8bbe\u95ee\u9898\u5931\u8d25: " + e.getMessage()));
        }
    }
}

