/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.cloud.ai.util;

import com.alibaba.cloud.ai.graph.OverAllState;
import java.util.List;
import java.util.function.Supplier;
import org.springframework.ai.document.Document;

public class StateUtils {
    public static String getStringValue(OverAllState state, String key) {
        return state.value(key).map(String.class::cast).orElseThrow(() -> new IllegalStateException("State key not found: " + key));
    }

    public static String getStringValue(OverAllState state, String key, String defaultValue) {
        return state.value(key).map(String.class::cast).orElse(defaultValue);
    }

    public static <T> List<T> getListValue(OverAllState state, String key) {
        return state.value(key).map(v -> (List)v).orElseThrow(() -> new IllegalStateException("State key not found: " + key));
    }

    public static <T> T getObjectValue(OverAllState state, String key, Class<T> type) {
        return (T)state.value(key).map(type::cast).orElseThrow(() -> new IllegalStateException("State key not found: " + key));
    }

    public static <T> T getObjectValue(OverAllState state, String key, Class<T> type, T defaultValue) {
        return (T)state.value(key).map(type::cast).orElse(defaultValue);
    }

    public static <T> T getObjectValue(OverAllState state, String key, Class<T> type, Supplier<T> defaultSupplier) {
        return (T)state.value(key).map(type::cast).orElseGet(defaultSupplier);
    }

    public static boolean hasValue(OverAllState state, String key) {
        return state.value(key).isPresent() && !((String)state.value(key).get()).equals("");
    }

    public static List<Document> getDocumentList(OverAllState state, String key) {
        return StateUtils.getListValue(state, key);
    }

    public static List<List<Document>> getDocumentListList(OverAllState state, String key) {
        return StateUtils.getListValue(state, key);
    }
}

