/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.cloud.ai.service.simple;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.ai.document.Document;
import org.springframework.ai.embedding.EmbeddingModel;
import org.springframework.ai.vectorstore.SearchRequest;
import org.springframework.ai.vectorstore.SimpleVectorStore;
import org.springframework.ai.vectorstore.filter.Filter;
import org.springframework.ai.vectorstore.filter.FilterExpressionBuilder;
import org.springframework.stereotype.Component;

@Component
public class AgentVectorStoreManager {
    private static final Logger log = LoggerFactory.getLogger(AgentVectorStoreManager.class);
    private final Map<String, SimpleVectorStore> agentStores = new ConcurrentHashMap<String, SimpleVectorStore>();
    private final EmbeddingModel embeddingModel;

    public AgentVectorStoreManager(EmbeddingModel embeddingModel) {
        this.embeddingModel = embeddingModel;
        log.info("AgentVectorStoreManager initialized with EmbeddingModel: {}", (Object)embeddingModel.getClass().getSimpleName());
    }

    public SimpleVectorStore getOrCreateVectorStore(String agentId) {
        if (agentId == null || agentId.trim().isEmpty()) {
            throw new IllegalArgumentException("Agent ID cannot be null or empty");
        }
        return this.agentStores.computeIfAbsent(agentId, id -> {
            log.info("Creating new vector store for agent: {}", id);
            return SimpleVectorStore.builder((EmbeddingModel)this.embeddingModel).build();
        });
    }

    public void addDocuments(String agentId, List<Document> documents) {
        if (documents == null || documents.isEmpty()) {
            log.warn("No documents to add for agent: {}", (Object)agentId);
            return;
        }
        SimpleVectorStore store = this.getOrCreateVectorStore(agentId);
        store.add(documents);
        log.info("Added {} documents to vector store for agent: {}", (Object)documents.size(), (Object)agentId);
    }

    public List<Document> similaritySearch(String agentId, String query, int topK) {
        SimpleVectorStore store = this.agentStores.get(agentId);
        if (store == null) {
            log.warn("No vector store found for agent: {}", (Object)agentId);
            return Collections.emptyList();
        }
        List results = store.similaritySearch(SearchRequest.builder().query(query).topK(topK).build());
        log.debug("Found {} similar documents for agent: {} with query: {}", new Object[]{results.size(), agentId, query});
        return results;
    }

    public List<Document> similaritySearchWithFilter(String agentId, String query, int topK, String vectorType) {
        SimpleVectorStore store = this.agentStores.get(agentId);
        if (store == null) {
            log.warn("No vector store found for agent: {}", (Object)agentId);
            return Collections.emptyList();
        }
        FilterExpressionBuilder builder = new FilterExpressionBuilder();
        Filter.Expression expression = builder.eq("vectorType", (Object)vectorType).build();
        List results = store.similaritySearch(SearchRequest.builder().query(query).topK(topK).filterExpression(expression).build());
        log.debug("Found {} filtered documents for agent: {} with query: {} and vectorType: {}", new Object[]{results.size(), agentId, query, vectorType});
        return results;
    }

    public void deleteAgentData(String agentId) {
        SimpleVectorStore removed = this.agentStores.remove(agentId);
        if (removed != null) {
            log.info("Deleted all vector data for agent: {}", (Object)agentId);
        } else {
            log.warn("No vector store found to delete for agent: {}", (Object)agentId);
        }
    }

    public void deleteDocuments(String agentId, List<String> documentIds) {
        SimpleVectorStore store = this.agentStores.get(agentId);
        if (store == null) {
            log.warn("No vector store found for agent: {}", (Object)agentId);
            return;
        }
        if (documentIds != null && !documentIds.isEmpty()) {
            store.delete(documentIds);
            log.info("Deleted {} documents from vector store for agent: {}", (Object)documentIds.size(), (Object)agentId);
        }
    }

    public void deleteDocumentsByType(String agentId, String vectorType) {
        SimpleVectorStore store = this.agentStores.get(agentId);
        if (store == null) {
            log.warn("No vector store found for agent: {}", (Object)agentId);
            return;
        }
        try {
            FilterExpressionBuilder builder = new FilterExpressionBuilder();
            Filter.Expression expression = builder.eq("vectorType", (Object)vectorType).build();
            List documents = store.similaritySearch(SearchRequest.builder().query("").topK(Integer.MAX_VALUE).filterExpression(expression).build());
            if (!documents.isEmpty()) {
                List<String> documentIds = documents.stream().map(Document::getId).toList();
                store.delete(documentIds);
                log.info("Deleted {} documents of type '{}' for agent: {}", new Object[]{documents.size(), vectorType, agentId});
            } else {
                log.info("No documents of type '{}' found for agent: {}", (Object)vectorType, (Object)agentId);
            }
        }
        catch (Exception e) {
            log.error("Failed to delete documents by type for agent: {}", (Object)agentId, (Object)e);
            throw new RuntimeException("Failed to delete documents by type: " + e.getMessage(), e);
        }
    }

    public boolean hasAgentData(String agentId) {
        return this.agentStores.containsKey(agentId);
    }

    public int getDocumentCount(String agentId) {
        SimpleVectorStore store = this.agentStores.get(agentId);
        if (store == null) {
            return 0;
        }
        try {
            List allDocs = store.similaritySearch(SearchRequest.builder().query("").topK(Integer.MAX_VALUE).build());
            return allDocs.size();
        }
        catch (Exception e) {
            log.warn("Failed to get document count for agent: {}", (Object)agentId, (Object)e);
            return 0;
        }
    }

    public Set<String> getAllAgentIds() {
        return Set.copyOf(this.agentStores.keySet());
    }

    public Map<String, Object> getStatistics() {
        ConcurrentHashMap<String, Object> stats = new ConcurrentHashMap<String, Object>();
        stats.put("totalAgents", this.agentStores.size());
        stats.put("agentIds", this.getAllAgentIds());
        ConcurrentHashMap agentDocCounts = new ConcurrentHashMap();
        this.agentStores.forEach((agentId, store) -> agentDocCounts.put(agentId, this.getDocumentCount((String)agentId)));
        stats.put("documentCounts", agentDocCounts);
        return stats;
    }
}

