/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.cloud.ai.config;

import com.alibaba.cloud.ai.config.Nl2sqlConfiguration;
import com.alibaba.cloud.ai.connector.accessor.Accessor;
import com.alibaba.cloud.ai.connector.config.DbConfig;
import com.alibaba.cloud.ai.service.LlmService;
import com.alibaba.cloud.ai.service.base.BaseNl2SqlService;
import com.alibaba.cloud.ai.service.base.BaseSchemaService;
import com.alibaba.cloud.ai.service.base.BaseVectorStoreService;
import com.alibaba.cloud.ai.service.simple.SimpleNl2SqlService;
import com.alibaba.cloud.ai.service.simple.SimpleSchemaService;
import com.google.gson.Gson;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration(proxyBeanMethods=false)
public class BaseDefaultConfiguration {
    private static final Logger logger = LoggerFactory.getLogger(Nl2sqlConfiguration.class);
    private final Accessor dbAccessor;
    private final DbConfig dbConfig;

    private BaseDefaultConfiguration(@Qualifier(value="mysqlAccessor") Accessor accessor, DbConfig dbConfig) {
        this.dbAccessor = accessor;
        this.dbConfig = dbConfig;
    }

    @Bean(value={"nl2SqlServiceImpl"})
    @ConditionalOnMissingBean(name={"nl2SqlServiceImpl"})
    public BaseNl2SqlService defaultNl2SqlService(@Qualifier(value="simpleVectorStoreService") BaseVectorStoreService vectorStoreService, @Qualifier(value="simpleSchemaService") BaseSchemaService schemaService, LlmService aiService) {
        logger.info("Creating default BaseNl2SqlService implementation");
        return new SimpleNl2SqlService(vectorStoreService, schemaService, aiService, this.dbAccessor, this.dbConfig);
    }

    @Bean(value={"schemaServiceImpl"})
    @ConditionalOnMissingBean(name={"schemaServiceImpl"})
    public BaseSchemaService defaultSchemaService(@Qualifier(value="simpleVectorStoreService") BaseVectorStoreService vectorStoreService, DbConfig dbConfig, Gson gson) {
        logger.info("Creating default BaseSchemaService implementation");
        return new SimpleSchemaService(dbConfig, gson, vectorStoreService);
    }
}

