/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.cloud.ai.mcp.register.utils;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;

public class JsonSchemaUtil {
    private static final ObjectMapper objectMapper = new ObjectMapper();

    public static boolean compare(String origin, String target) {
        try {
            JsonNode originNode = objectMapper.readTree(origin);
            JsonNode targetNode = objectMapper.readTree(target);
            return JsonSchemaUtil.compare(originNode, targetNode);
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    public static boolean compare(JsonNode originNode, JsonNode targetNode) {
        if (originNode == null && targetNode == null) {
            return true;
        }
        if (originNode == null || targetNode == null) {
            return false;
        }
        JsonNode originProperties = originNode.get("properties");
        JsonNode targetProperties = targetNode.get("properties");
        if (targetProperties == null && originProperties != null) {
            return false;
        }
        if (targetProperties != null && originProperties == null) {
            return false;
        }
        if (originProperties != null && targetProperties != null) {
            String key;
            Map.Entry entry;
            Iterator it = originProperties.fields();
            while (it.hasNext()) {
                String targetType;
                JsonNode typeNode;
                entry = (Map.Entry)it.next();
                key = (String)entry.getKey();
                JsonNode valueNode = (JsonNode)entry.getValue();
                if (!valueNode.isObject() || (typeNode = valueNode.get("type")) == null || !typeNode.isTextual()) continue;
                String type = typeNode.asText();
                if (!targetProperties.has(key)) {
                    return false;
                }
                JsonNode targetValueNode = targetProperties.get(key);
                JsonNode targetTypeNode = targetValueNode.get("type");
                String string = targetType = targetTypeNode != null && targetTypeNode.isTextual() ? targetTypeNode.asText() : "";
                if (!type.equals(targetType)) {
                    return false;
                }
                if ("object".equals(type)) {
                    if (JsonSchemaUtil.compare(valueNode, targetValueNode)) continue;
                    return false;
                }
                if (!"array".equals(type)) continue;
                JsonNode originItems = valueNode.get("items");
                JsonNode targetItems = targetValueNode.get("items");
                if (originItems == null || targetItems == null || JsonSchemaUtil.compare(originItems, targetItems)) continue;
                return false;
            }
            it = targetProperties.fields();
            while (it.hasNext()) {
                entry = (Map.Entry)it.next();
                key = (String)entry.getKey();
                if (originProperties.has(key)) continue;
                return false;
            }
        }
        JsonNode originRequired = originNode.get("required");
        JsonNode targetRequired = targetNode.get("required");
        if (originRequired != null && targetRequired != null) {
            if (!originRequired.isArray() || !targetRequired.isArray()) {
                return false;
            }
            if (originRequired.size() != targetRequired.size()) {
                return false;
            }
            HashSet<String> originSet = new HashSet<String>();
            for (JsonNode node : originRequired) {
                if (node.isTextual()) {
                    originSet.add(node.asText());
                    continue;
                }
                return false;
            }
            HashSet<String> targetSet = new HashSet<String>();
            for (JsonNode node : targetRequired) {
                if (node.isTextual()) {
                    targetSet.add(node.asText());
                    continue;
                }
                return false;
            }
            return originSet.equals(targetSet);
        }
        return originRequired == null && targetRequired == null;
    }
}

