/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.cloud.ai.util;

import com.alibaba.cloud.ai.dashscope.api.DashScopeApi;
import com.alibaba.cloud.ai.dashscope.embedding.DashScopeEmbeddingModel;
import com.alibaba.cloud.ai.dashscope.embedding.DashScopeEmbeddingOptions;
import org.springframework.ai.chat.client.ChatClient;
import org.springframework.ai.chat.model.ChatModel;
import org.springframework.ai.document.MetadataMode;
import org.springframework.ai.embedding.EmbeddingModel;
import org.springframework.ai.openai.OpenAiChatModel;
import org.springframework.ai.openai.OpenAiChatOptions;
import org.springframework.ai.openai.OpenAiEmbeddingModel;
import org.springframework.ai.openai.OpenAiEmbeddingOptions;
import org.springframework.ai.openai.api.OpenAiApi;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Primary;
import org.springframework.util.StringUtils;

@Configuration
public class AiConfiguration {
    @Value(value="${spring.ai.openai.api-key}")
    private String openAiApiKey;
    @Value(value="${spring.ai.openai.base-url:}")
    private String baseUrl;
    @Value(value="${spring.ai.openai.model:}")
    private String model;
    @Value(value="${spring.ai.dashscope.api-key:}")
    private String dashScopeApiKey;
    @Value(value="${spring.ai.dashscope.embedding.model:text-embedding-v2}")
    private String dashScopeEmbeddingModel;
    @Value(value="${spring.ai.openai.embedding.model:text-embedding-ada-002}")
    private String openAiEmbeddingModel;
    @Value(value="${spring.ai.openai.embedding.embeddings-path:}")
    private String openAiEmbeddingsPath;
    @Value(value="${spring.ai.openai.completions-path:}")
    private String openAiCompletionsPath;

    @Bean
    public ChatModel chatModel() {
        OpenAiApi openAiApi = OpenAiApi.builder().apiKey(this.openAiApiKey).baseUrl(this.baseUrl).build();
        OpenAiChatOptions openAiChatOptions = OpenAiChatOptions.builder().model(this.model).temperature(Double.valueOf(0.7)).build();
        return OpenAiChatModel.builder().openAiApi(openAiApi).defaultOptions(openAiChatOptions).build();
    }

    @Bean
    public ChatClient chatClient(@Qualifier(value="chatModel") ChatModel chatModel) {
        return ChatClient.create((ChatModel)chatModel);
    }

    @Bean(value={"embeddingModel"})
    @Primary
    @ConditionalOnProperty(name={"spring.ai.dashscope.api-key"})
    @ConditionalOnMissingBean(value={EmbeddingModel.class})
    public EmbeddingModel dashScopeEmbeddingModel() {
        DashScopeApi dashScopeApi = DashScopeApi.builder().apiKey(this.dashScopeApiKey).build();
        DashScopeEmbeddingOptions options = DashScopeEmbeddingOptions.builder().withModel(this.dashScopeEmbeddingModel).build();
        return new DashScopeEmbeddingModel(dashScopeApi, MetadataMode.EMBED, options);
    }

    @Bean(value={"embeddingModel"})
    @Primary
    @ConditionalOnProperty(name={"spring.ai.dashscope.api-key"}, havingValue="", matchIfMissing=true)
    @ConditionalOnMissingBean(value={EmbeddingModel.class})
    public EmbeddingModel customOpenAiEmbeddingModel() {
        if (!StringUtils.hasText((String)this.openAiApiKey)) {
            throw new IllegalStateException("Either spring.ai.dashscope.api-key or spring.ai.openai.api-key must be configured");
        }
        OpenAiApi.Builder builder = OpenAiApi.builder().apiKey(this.openAiApiKey).baseUrl(this.baseUrl);
        if (StringUtils.hasText((String)this.openAiEmbeddingsPath)) {
            builder.embeddingsPath(this.openAiEmbeddingsPath);
        }
        if (StringUtils.hasText((String)this.openAiCompletionsPath)) {
            builder.completionsPath(this.openAiCompletionsPath);
        }
        OpenAiApi openAiApi = builder.build();
        OpenAiEmbeddingOptions options = OpenAiEmbeddingOptions.builder().model(this.openAiEmbeddingModel).build();
        return new OpenAiEmbeddingModel(openAiApi, MetadataMode.EMBED, options);
    }
}

