/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.cloud.ai.service.code;

import com.alibaba.cloud.ai.config.CodeExecutorProperties;
import com.alibaba.cloud.ai.service.code.CodePoolExecutorEnum;
import com.alibaba.cloud.ai.service.code.CodePoolExecutorService;
import com.alibaba.cloud.ai.service.code.impl.AiSimulationCodeExecutorService;
import com.alibaba.cloud.ai.service.code.impl.DockerCodePoolExecutorService;
import com.alibaba.cloud.ai.service.code.impl.LocalCodePoolExecutorService;
import org.springframework.ai.chat.client.ChatClient;

public final class CodePoolExecutorServiceFactory {
    private CodePoolExecutorServiceFactory() {
    }

    public static CodePoolExecutorService newInstance(CodeExecutorProperties properties, ChatClient.Builder chatClientBuilder) {
        return switch (properties.getCodePoolExecutor()) {
            case CodePoolExecutorEnum.DOCKER -> new DockerCodePoolExecutorService(properties);
            case CodePoolExecutorEnum.LOCAL -> new LocalCodePoolExecutorService(properties);
            case CodePoolExecutorEnum.AI_SIMULATION -> new AiSimulationCodeExecutorService(chatClientBuilder);
            default -> throw new UnsupportedOperationException("This option does not have a corresponding implementation class yet.");
        };
    }
}

