/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.cloud.ai.service;

import com.alibaba.cloud.ai.connector.DBConnectionPool;
import com.alibaba.cloud.ai.connector.DBConnectionPoolContext;
import com.alibaba.cloud.ai.connector.config.DbConfig;
import com.alibaba.cloud.ai.entity.AgentDatasource;
import com.alibaba.cloud.ai.entity.Datasource;
import com.alibaba.cloud.ai.enums.ErrorCodeEnum;
import com.alibaba.cloud.ai.mapper.AgentDatasourceMapper;
import com.alibaba.cloud.ai.mapper.DatasourceMapper;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class DatasourceService {
    private static final Logger log = LoggerFactory.getLogger(DatasourceService.class);
    @Autowired
    private DatasourceMapper datasourceMapper;
    @Autowired
    private AgentDatasourceMapper agentDatasourceMapper;
    @Autowired
    private DBConnectionPoolContext dbConnectionPoolContext;

    public List<Datasource> getAllDatasources() {
        return this.datasourceMapper.selectList((Wrapper)Wrappers.lambdaQuery().orderByDesc(Datasource::getCreateTime));
    }

    public List<Datasource> getDatasourcesByStatus(String status) {
        return this.datasourceMapper.selectByStatus(status);
    }

    public List<Datasource> getDatasourcesByType(String type) {
        return this.datasourceMapper.selectByType(type);
    }

    public Datasource getDatasourceById(Integer id) {
        return (Datasource)this.datasourceMapper.selectById(id);
    }

    public Datasource createDatasource(Datasource datasource) {
        datasource.generateConnectionUrl();
        if (datasource.getStatus() == null) {
            datasource.setStatus("active");
        }
        if (datasource.getTestStatus() == null) {
            datasource.setTestStatus("unknown");
        }
        this.datasourceMapper.insert(datasource);
        return datasource;
    }

    public Datasource updateDatasource(Integer id, Datasource datasource) {
        datasource.generateConnectionUrl();
        datasource.setId(id);
        this.datasourceMapper.updateById(datasource);
        return datasource;
    }

    @Transactional
    public void deleteDatasource(Integer id) {
        this.agentDatasourceMapper.delete((Wrapper)Wrappers.lambdaQuery().eq(AgentDatasource::getDatasourceId, (Object)id));
        this.datasourceMapper.deleteById(id);
    }

    public void updateTestStatus(Integer id, String testStatus) {
        this.datasourceMapper.update(null, (Wrapper)((LambdaUpdateWrapper)Wrappers.lambdaUpdate().eq(Datasource::getId, (Object)id)).set(Datasource::getTestStatus, (Object)testStatus));
    }

    public boolean testConnection(Integer id) {
        Datasource datasource = this.getDatasourceById(id);
        if (datasource == null) {
            return false;
        }
        try {
            boolean connectionSuccess = this.realConnectionTest(datasource);
            log.info(datasource.getName() + " test connection result: " + connectionSuccess);
            this.updateTestStatus(id, connectionSuccess ? "success" : "failed");
            return connectionSuccess;
        }
        catch (Exception e) {
            this.updateTestStatus(id, "failed");
            log.error("Error testing connection for datasource ID " + id + ": " + e.getMessage(), (Throwable)e);
            return false;
        }
    }

    private boolean realConnectionTest(Datasource datasource) {
        DbConfig config = new DbConfig();
        Object originalUrl = datasource.getConnectionUrl();
        if (StringUtils.isNotBlank((CharSequence)originalUrl)) {
            String lowerUrl = ((String)originalUrl).toLowerCase();
            if (!lowerUrl.contains("servertimezone=")) {
                originalUrl = ((String)originalUrl).contains("?") ? (String)originalUrl + "&serverTimezone=Asia/Shanghai" : (String)originalUrl + "?serverTimezone=Asia/Shanghai";
            }
            if (!lowerUrl.contains("usessl=")) {
                originalUrl = ((String)originalUrl).contains("?") ? (String)originalUrl + "&useSSL=false" : (String)originalUrl + "?useSSL=false";
            }
        }
        config.setUrl((String)originalUrl);
        config.setUsername(datasource.getUsername());
        config.setPassword(datasource.getPassword());
        DBConnectionPool pool = this.dbConnectionPoolContext.getPoolByType(datasource.getType());
        if (pool == null) {
            return false;
        }
        ErrorCodeEnum result = pool.ping(config);
        return result == ErrorCodeEnum.SUCCESS;
    }

    public List<AgentDatasource> getAgentDatasources(Integer agentId) {
        List<AgentDatasource> agentDatasources = this.agentDatasourceMapper.selectByAgentIdWithDatasource(agentId);
        for (AgentDatasource agentDatasource : agentDatasources) {
            if (agentDatasource.getDatasourceId() == null) continue;
            Datasource datasource = (Datasource)this.datasourceMapper.selectById(agentDatasource.getDatasourceId());
            agentDatasource.setDatasource(datasource);
        }
        return agentDatasources;
    }

    @Transactional
    public AgentDatasource addDatasourceToAgent(Integer agentId, Integer datasourceId) {
        this.agentDatasourceMapper.disableAllByAgentId(agentId);
        AgentDatasource existing = this.agentDatasourceMapper.selectByAgentIdAndDatasourceId(agentId, datasourceId);
        if (existing != null) {
            this.agentDatasourceMapper.update(null, (Wrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)Wrappers.lambdaUpdate().eq(AgentDatasource::getAgentId, (Object)agentId)).eq(AgentDatasource::getDatasourceId, (Object)datasourceId)).set(AgentDatasource::getIsActive, (Object)1));
            return this.agentDatasourceMapper.selectByAgentIdAndDatasourceId(agentId, datasourceId);
        }
        AgentDatasource agentDatasource = new AgentDatasource(agentId, datasourceId);
        agentDatasource.setIsActive(1);
        this.agentDatasourceMapper.insert(agentDatasource);
        return agentDatasource;
    }

    public void removeDatasourceFromAgent(Integer agentId, Integer datasourceId) {
        this.agentDatasourceMapper.delete((Wrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().eq(AgentDatasource::getAgentId, (Object)agentId)).eq(AgentDatasource::getDatasourceId, (Object)datasourceId));
    }

    public AgentDatasource toggleDatasourceForAgent(Integer agentId, Integer datasourceId, Boolean isActive) {
        int activeCount;
        if (isActive.booleanValue() && (activeCount = this.agentDatasourceMapper.countActiveByAgentIdExcluding(agentId, datasourceId)) > 0) {
            throw new RuntimeException("\u540c\u4e00\u667a\u80fd\u4f53\u4e0b\u53ea\u80fd\u542f\u7528\u4e00\u4e2a\u6570\u636e\u6e90\uff0c\u8bf7\u5148\u7981\u7528\u5176\u4ed6\u6570\u636e\u6e90\u540e\u518d\u542f\u7528\u6b64\u6570\u636e\u6e90");
        }
        int updated = this.agentDatasourceMapper.update(null, (Wrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)Wrappers.lambdaUpdate().eq(AgentDatasource::getAgentId, (Object)agentId)).eq(AgentDatasource::getDatasourceId, (Object)datasourceId)).set(AgentDatasource::getIsActive, (Object)(isActive != false ? 1 : 0)));
        if (updated == 0) {
            throw new RuntimeException("\u672a\u627e\u5230\u76f8\u5173\u7684\u6570\u636e\u6e90\u5173\u8054\u8bb0\u5f55");
        }
        return this.agentDatasourceMapper.selectByAgentIdAndDatasourceId(agentId, datasourceId);
    }

    public Map<String, Object> getDatasourceStats() {
        HashMap<String, Object> stats = new HashMap<String, Object>();
        Long total = this.datasourceMapper.selectCount(null);
        stats.put("total", total);
        List<Map<String, Object>> statusStats = this.datasourceMapper.selectStatusStats();
        stats.put("byStatus", statusStats);
        List<Map<String, Object>> typeStats = this.datasourceMapper.selectTypeStats();
        stats.put("byType", typeStats);
        List<Map<String, Object>> testStats = this.datasourceMapper.selectTestStatusStats();
        stats.put("byTestStatus", testStats);
        return stats;
    }
}

