/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.cloud.ai.node;

import com.alibaba.cloud.ai.enums.StreamResponseType;
import com.alibaba.cloud.ai.graph.GraphResponse;
import com.alibaba.cloud.ai.graph.OverAllState;
import com.alibaba.cloud.ai.graph.action.NodeAction;
import com.alibaba.cloud.ai.graph.streaming.StreamingOutput;
import com.alibaba.cloud.ai.node.AbstractPlanBasedNode;
import com.alibaba.cloud.ai.service.code.CodePoolExecutorService;
import com.alibaba.cloud.ai.util.ChatResponseUtil;
import com.alibaba.cloud.ai.util.StateUtils;
import com.alibaba.cloud.ai.util.StreamingChatGeneratorUtil;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.ai.chat.model.ChatResponse;
import reactor.core.publisher.Flux;

public class PythonExecuteNode
extends AbstractPlanBasedNode
implements NodeAction {
    private static final Logger log = LoggerFactory.getLogger(PythonExecuteNode.class);
    private final CodePoolExecutorService codePoolExecutor;
    private final ObjectMapper objectMapper;

    public PythonExecuteNode(CodePoolExecutorService codePoolExecutor) {
        this.codePoolExecutor = codePoolExecutor;
        this.objectMapper = new ObjectMapper();
    }

    public Map<String, Object> apply(OverAllState state) throws Exception {
        this.logNodeEntry();
        try {
            String pythonCode = StateUtils.getStringValue(state, "PYTHON_GENERATE_NODE_OUTPUT");
            List sqlResults = StateUtils.getListValue(state, "SQL_RESULT_LIST_MEMORY");
            CodePoolExecutorService.TaskRequest taskRequest = new CodePoolExecutorService.TaskRequest(pythonCode, this.objectMapper.writeValueAsString(sqlResults), null);
            CodePoolExecutorService.TaskResponse taskResponse = this.codePoolExecutor.runTask(taskRequest);
            if (!taskResponse.isSuccess()) {
                String errorMsg = "Python Execute Failed!\nStdOut: " + taskResponse.stdOut() + "\nStdErr: " + taskResponse.stdErr() + "\nExceptionMsg: " + taskResponse.exceptionMsg();
                log.error(errorMsg);
                throw new RuntimeException(errorMsg);
            }
            String stdout = taskResponse.stdOut();
            try {
                Object value = this.objectMapper.readValue(stdout, Object.class);
                stdout = this.objectMapper.writeValueAsString(value);
            }
            catch (Exception e) {
                stdout = taskResponse.stdOut();
            }
            String finalStdout = stdout;
            log.info("Python Execute Success! StdOut: {}", (Object)finalStdout);
            Flux displayFlux = Flux.create(emitter -> {
                emitter.next((Object)ChatResponseUtil.createStatusResponse("\u5f00\u59cb\u6267\u884cPython\u4ee3\u7801..."));
                emitter.next((Object)ChatResponseUtil.createStatusResponse("\u6807\u51c6\u8f93\u51fa\uff1a\n```"));
                emitter.next((Object)ChatResponseUtil.createStatusResponse(finalStdout));
                emitter.next((Object)ChatResponseUtil.createStatusResponse("\n```"));
                emitter.next((Object)ChatResponseUtil.createStatusResponse("Python\u4ee3\u7801\u6267\u884c\u6210\u529f\uff01"));
                emitter.complete();
            });
            Flux<GraphResponse<StreamingOutput>> generator = StreamingChatGeneratorUtil.createStreamingGeneratorWithMessages(this.getClass(), state, v -> Map.of("PYTHON_EXECUTE_NODE_OUTPUT", finalStdout, "PYTHON_IS_SUCCESS", true), (Flux<ChatResponse>)displayFlux, StreamResponseType.PYTHON_EXECUTE);
            return Map.of("PYTHON_EXECUTE_NODE_OUTPUT", generator);
        }
        catch (Exception e) {
            String errorMessage = e.getMessage();
            log.error("Python Execute Exception: {}", (Object)errorMessage);
            Map<String, Boolean> errorResult = Map.of("PYTHON_EXECUTE_NODE_OUTPUT", errorMessage, "PYTHON_IS_SUCCESS", false);
            Flux errorDisplayFlux = Flux.create(emitter -> {
                emitter.next((Object)ChatResponseUtil.createCustomStatusResponse("\u5f00\u59cb\u6267\u884cPython\u4ee3\u7801..."));
                emitter.next((Object)ChatResponseUtil.createCustomStatusResponse("Python\u4ee3\u7801\u6267\u884c\u5931\u8d25: " + errorMessage));
                emitter.complete();
            });
            Flux<GraphResponse<StreamingOutput>> generator = StreamingChatGeneratorUtil.createStreamingGeneratorWithMessages(this.getClass(), state, v -> errorResult, (Flux<ChatResponse>)errorDisplayFlux, StreamResponseType.PYTHON_EXECUTE);
            return Map.of("PYTHON_EXECUTE_NODE_OUTPUT", generator);
        }
    }
}

