/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.cloud.ai.node;

import com.alibaba.cloud.ai.graph.OverAllState;
import com.alibaba.cloud.ai.graph.action.NodeAction;
import com.alibaba.cloud.ai.util.StateUtils;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.StringUtils;

public class HumanFeedbackNode
implements NodeAction {
    private static final Logger logger = LoggerFactory.getLogger(HumanFeedbackNode.class);

    public Map<String, Object> apply(OverAllState state) throws Exception {
        logger.info("Processing human feedback");
        HashMap<String, Object> updated = new HashMap<String, Object>();
        int repairCount = StateUtils.getObjectValue(state, "PLAN_REPAIR_COUNT", Integer.class, 0);
        if (repairCount >= 3) {
            logger.warn("Max repair attempts (3) exceeded, ending process");
            updated.put("human_next_node", "END");
            return updated;
        }
        OverAllState.HumanFeedback humanFeedback = state.humanFeedback();
        if (humanFeedback == null) {
            updated.put("human_next_node", "WAIT_FOR_FEEDBACK");
            return updated;
        }
        Map feedbackData = humanFeedback.data();
        boolean approved = feedbackData.getOrDefault("feedback", true);
        if (approved) {
            logger.info("Plan approved \u2192 execution");
            updated.put("human_next_node", "PLAN_EXECUTOR_NODE");
            updated.put("HUMAN_REVIEW_ENABLED", false);
        } else {
            logger.info("Plan rejected \u2192 regeneration (attempt {})", (Object)(repairCount + 1));
            updated.put("human_next_node", "PLANNER_NODE");
            updated.put("PLAN_REPAIR_COUNT", repairCount + 1);
            updated.put("PLAN_CURRENT_STEP", 1);
            updated.put("HUMAN_REVIEW_ENABLED", true);
            String feedbackContent = feedbackData.getOrDefault("feedback_content", "").toString();
            updated.put("PLAN_VALIDATION_ERROR", StringUtils.hasLength((String)feedbackContent) ? feedbackContent : "Plan rejected by user");
            updated.put("PLANNER_NODE_OUTPUT", "");
            state.withoutResume();
        }
        return updated;
    }
}

