/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.cloud.ai.dispatcher;

import com.alibaba.cloud.ai.graph.OverAllState;
import com.alibaba.cloud.ai.graph.action.EdgeAction;
import com.alibaba.cloud.ai.util.StateUtils;
import java.util.Optional;

public class TableRelationDispatcher
implements EdgeAction {
    private static final int MAX_RETRY_COUNT = 3;

    public String apply(OverAllState state) throws Exception {
        String errorFlag = StateUtils.getStringValue(state, "TABLE_RELATION_EXCEPTION_OUTPUT", null);
        Integer retryCount = StateUtils.getObjectValue(state, "TABLE_RELATION_RETRY_COUNT", Integer.class, 0);
        if (errorFlag != null && !errorFlag.isEmpty()) {
            if (this.isRetryableError(errorFlag) && retryCount < 3) {
                return "TABLE_RELATION_NODE";
            }
            return "__END__";
        }
        Optional tableRelationOutput = state.value("TABLE_RELATION_OUTPUT");
        if (tableRelationOutput.isPresent()) {
            return "PLANNER_NODE";
        }
        return "__END__";
    }

    private boolean isRetryableError(String errorMessage) {
        return errorMessage.startsWith("RETRYABLE:");
    }
}

