/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.cloud.ai.dashscope.rag;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class DashScopeDocumentTransformerOptions {
    @JsonProperty(value="chunk_size")
    private int chunkSize = 500;
    @JsonProperty(value="overlap_size")
    private int overlapSize = 100;
    @JsonProperty(value="separator")
    private String separator = "|,|\uff0c|\u3002|\uff1f|\uff01|\\n|\\\\?|\\\\!";
    @JsonProperty(value="file_type")
    private String fileType = "idp";
    @JsonProperty(value="input_type")
    private String language = "cn";

    public static Builder builder() {
        return new Builder();
    }

    public int getChunkSize() {
        return this.chunkSize;
    }

    public void setChunkSize(int chunkSize) {
        this.chunkSize = chunkSize;
    }

    public int getOverlapSize() {
        return this.overlapSize;
    }

    public void setOverlapSize(int overlapSize) {
        this.overlapSize = overlapSize;
    }

    public String getSeparator() {
        return this.separator;
    }

    public void setSeparator(String separator) {
        this.separator = separator;
    }

    public String getFileType() {
        return this.fileType;
    }

    public void setFileType(String fileType) {
        this.fileType = fileType;
    }

    public String getLanguage() {
        return this.language;
    }

    public void setLanguage(String language) {
        this.language = language;
    }

    public static class Builder {
        protected DashScopeDocumentTransformerOptions options = new DashScopeDocumentTransformerOptions();

        public Builder chunkSize(int chunkSize) {
            this.options.setChunkSize(chunkSize);
            return this;
        }

        @Deprecated
        public Builder withChunkSize(int chunkSize) {
            return this.chunkSize(chunkSize);
        }

        public Builder overlapSize(int overlapSize) {
            this.options.setOverlapSize(overlapSize);
            return this;
        }

        @Deprecated
        public Builder withOverlapSize(int overlapSize) {
            return this.overlapSize(overlapSize);
        }

        public Builder separator(String separator) {
            this.options.setSeparator(separator);
            return this;
        }

        @Deprecated
        public Builder withSeparator(String separator) {
            return this.separator(separator);
        }

        public Builder fileType(String fileType) {
            this.options.setFileType(fileType);
            return this;
        }

        @Deprecated
        public Builder withFileType(String fileType) {
            return this.fileType(fileType);
        }

        public Builder language(String language) {
            this.options.setLanguage(language);
            return this;
        }

        @Deprecated
        public Builder withLanguage(String language) {
            return this.language(language);
        }

        public DashScopeDocumentTransformerOptions build() {
            return this.options;
        }
    }
}

