/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.cloud.ai.dashscope.embedding;

import com.alibaba.cloud.ai.dashscope.api.DashScopeApi;
import com.alibaba.cloud.ai.dashscope.common.DashScopeApiConstants;
import com.alibaba.cloud.ai.dashscope.embedding.DashScopeEmbeddingOptions;
import com.alibaba.cloud.ai.dashscope.spec.DashScopeApiSpec;
import io.micrometer.observation.ObservationConvention;
import io.micrometer.observation.ObservationRegistry;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.ai.chat.metadata.DefaultUsage;
import org.springframework.ai.chat.metadata.EmptyUsage;
import org.springframework.ai.chat.metadata.Usage;
import org.springframework.ai.document.Document;
import org.springframework.ai.document.MetadataMode;
import org.springframework.ai.embedding.AbstractEmbeddingModel;
import org.springframework.ai.embedding.BatchingStrategy;
import org.springframework.ai.embedding.Embedding;
import org.springframework.ai.embedding.EmbeddingOptions;
import org.springframework.ai.embedding.EmbeddingRequest;
import org.springframework.ai.embedding.EmbeddingResponse;
import org.springframework.ai.embedding.EmbeddingResponseMetadata;
import org.springframework.ai.embedding.observation.DefaultEmbeddingModelObservationConvention;
import org.springframework.ai.embedding.observation.EmbeddingModelObservationContext;
import org.springframework.ai.embedding.observation.EmbeddingModelObservationConvention;
import org.springframework.ai.embedding.observation.EmbeddingModelObservationDocumentation;
import org.springframework.ai.model.ModelOptionsUtils;
import org.springframework.ai.retry.RetryUtils;
import org.springframework.retry.support.RetryTemplate;
import org.springframework.util.Assert;

public class DashScopeEmbeddingModel
extends AbstractEmbeddingModel {
    private static final Logger logger = LoggerFactory.getLogger(DashScopeEmbeddingModel.class);
    private static final EmbeddingModelObservationConvention DEFAULT_OBSERVATION_CONVENTION = new DefaultEmbeddingModelObservationConvention();
    private final DashScopeEmbeddingOptions defaultOptions;
    private final RetryTemplate retryTemplate;
    private final DashScopeApi dashScopeApi;
    private final MetadataMode metadataMode;
    private final ObservationRegistry observationRegistry;
    private EmbeddingModelObservationConvention observationConvention = DEFAULT_OBSERVATION_CONVENTION;

    public DashScopeEmbeddingModel(DashScopeApi dashScopeApi) {
        this(dashScopeApi, MetadataMode.EMBED);
    }

    public DashScopeEmbeddingModel(DashScopeApi dashScopeApi, MetadataMode metadataMode) {
        this(dashScopeApi, metadataMode, DashScopeEmbeddingOptions.builder().model(DashScopeApi.DEFAULT_EMBEDDING_MODEL).textType(DashScopeApi.DEFAULT_EMBEDDING_TEXT_TYPE).build());
    }

    public DashScopeEmbeddingModel(DashScopeApi dashScopeApi, MetadataMode metadataMode, DashScopeEmbeddingOptions dashScopeEmbeddingOptions) {
        this(dashScopeApi, metadataMode, dashScopeEmbeddingOptions, RetryUtils.DEFAULT_RETRY_TEMPLATE);
    }

    public DashScopeEmbeddingModel(DashScopeApi dashScopeApi, MetadataMode metadataMode, DashScopeEmbeddingOptions dashScopeEmbeddingOptions, RetryTemplate retryTemplate) {
        this(dashScopeApi, metadataMode, dashScopeEmbeddingOptions, retryTemplate, ObservationRegistry.NOOP);
    }

    public DashScopeEmbeddingModel(DashScopeApi dashScopeApi, MetadataMode metadataMode, DashScopeEmbeddingOptions options, RetryTemplate retryTemplate, ObservationRegistry observationRegistry) {
        Assert.notNull((Object)dashScopeApi, (String)"DashScopeApi must not be null");
        Assert.notNull((Object)metadataMode, (String)"metadataMode must not be null");
        Assert.notNull((Object)options, (String)"options must not be null");
        Assert.notNull((Object)retryTemplate, (String)"retryTemplate must not be null");
        Assert.notNull((Object)observationRegistry, (String)"observationRegistry must not be null");
        this.dashScopeApi = dashScopeApi;
        this.metadataMode = metadataMode;
        this.defaultOptions = options;
        this.retryTemplate = retryTemplate;
        this.observationRegistry = observationRegistry;
    }

    public float[] embed(Document document) {
        Assert.notNull((Object)document, (String)"Document must not be null");
        return this.embed(document.getFormattedContent(this.metadataMode));
    }

    public EmbeddingResponse call(EmbeddingRequest request) {
        EmbeddingRequest embeddingRequest = this.buildEmbeddingRequest(request);
        DashScopeApiSpec.EmbeddingRequest apiRequest = this.createRequest(embeddingRequest);
        EmbeddingModelObservationContext observationContext = EmbeddingModelObservationContext.builder().embeddingRequest(embeddingRequest).provider(DashScopeApiConstants.PROVIDER_NAME).build();
        return Objects.requireNonNull((EmbeddingResponse)EmbeddingModelObservationDocumentation.EMBEDDING_MODEL_OPERATION.observation((ObservationConvention)this.observationConvention, (ObservationConvention)DEFAULT_OBSERVATION_CONVENTION, () -> observationContext, this.observationRegistry).observe(() -> {
            DashScopeApiSpec.EmbeddingList apiEmbeddingResponse = (DashScopeApiSpec.EmbeddingList)this.retryTemplate.execute(ctx -> {
                try {
                    return (DashScopeApiSpec.EmbeddingList)this.dashScopeApi.embeddings(apiRequest).getBody();
                }
                catch (Exception e) {
                    logger.error("Error embedding request: {}", (Object)request.getInstructions(), (Object)e);
                    throw e;
                }
            });
            if (apiEmbeddingResponse == null) {
                logger.warn("No embeddings returned for request: {}", (Object)request);
                return new EmbeddingResponse(List.of());
            }
            if (apiEmbeddingResponse.message() != null) {
                logger.error("Error message returned for request: {}", (Object)apiEmbeddingResponse.message());
                throw new RuntimeException("Embedding failed: error code:" + apiEmbeddingResponse.code() + ", message:" + apiEmbeddingResponse.message());
            }
            DashScopeApiSpec.EmbeddingUsage usage = apiEmbeddingResponse.usage();
            EmptyUsage embeddingUsage = usage != null ? this.getDefaultUsage(usage) : new EmptyUsage();
            EmbeddingResponseMetadata metadata = this.generateResponseMetadata(apiRequest.model(), (Usage)embeddingUsage);
            List<Embedding> embeddings = apiEmbeddingResponse.output().embeddings().stream().map(e -> new Embedding(e.embedding(), e.textIndex())).toList();
            EmbeddingResponse embeddingResponse = new EmbeddingResponse(embeddings, metadata);
            observationContext.setResponse((Object)embeddingResponse);
            return embeddingResponse;
        }));
    }

    private DefaultUsage getDefaultUsage(DashScopeApiSpec.EmbeddingUsage usage) {
        return new DefaultUsage(usage.getPromptTokens(), usage.getCompletionTokens(), usage.getTotalTokens(), (Object)usage);
    }

    private EmbeddingRequest buildEmbeddingRequest(EmbeddingRequest embeddingRequest) {
        DashScopeEmbeddingOptions runtimeOptions = null;
        if (embeddingRequest.getOptions() != null) {
            runtimeOptions = (DashScopeEmbeddingOptions)ModelOptionsUtils.copyToTarget((Object)embeddingRequest.getOptions(), EmbeddingOptions.class, DashScopeEmbeddingOptions.class);
        }
        DashScopeEmbeddingOptions requestOptions = runtimeOptions == null ? this.defaultOptions : DashScopeEmbeddingOptions.builder().model((String)ModelOptionsUtils.mergeOption((Object)runtimeOptions.getModel(), (Object)this.defaultOptions.getModel())).dimensions((Integer)ModelOptionsUtils.mergeOption((Object)runtimeOptions.getDimensions(), (Object)this.defaultOptions.getDimensions())).textType((String)ModelOptionsUtils.mergeOption((Object)runtimeOptions.getTextType(), (Object)this.defaultOptions.getTextType())).build();
        return new EmbeddingRequest(embeddingRequest.getInstructions(), (EmbeddingOptions)requestOptions);
    }

    private DashScopeApiSpec.EmbeddingRequest createRequest(EmbeddingRequest request) {
        DashScopeEmbeddingOptions requestOptions = (DashScopeEmbeddingOptions)request.getOptions();
        return DashScopeApiSpec.EmbeddingRequest.builder().model(requestOptions.getModel()).texts(request.getInstructions()).textType(requestOptions.getTextType()).dimension(requestOptions.getDimensions()).build();
    }

    private EmbeddingResponseMetadata generateResponseMetadata(String model, Usage usage) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("model", model);
        map.put("total-tokens", usage.getTotalTokens());
        return new EmbeddingResponseMetadata(model, usage, map);
    }

    public void setObservationConvention(EmbeddingModelObservationConvention observationConvention) {
        Assert.notNull((Object)observationConvention, (String)"observationConvention cannot be null");
        this.observationConvention = observationConvention;
    }

    public List<float[]> embed(List<String> texts) {
        Assert.notNull(texts, (String)"Texts must not be null");
        return this.call(new EmbeddingRequest(texts, (EmbeddingOptions)this.defaultOptions)).getResults().stream().map(Embedding::getOutput).toList();
    }

    public List<float[]> embed(List<Document> documents, EmbeddingOptions options, BatchingStrategy batchingStrategy) {
        if (options.getModel() == null && options.getDimensions() == null && this.defaultOptions != null) {
            options = this.defaultOptions;
        }
        return super.embed(documents, options, batchingStrategy);
    }

    public EmbeddingResponse embedForResponse(List<String> texts) {
        Assert.notNull(texts, (String)"Texts must not be null");
        return this.call(new EmbeddingRequest(texts, (EmbeddingOptions)this.defaultOptions));
    }
}

