/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.cloud.ai.dashscope.api;

import com.alibaba.cloud.ai.dashscope.spec.DashScopeApiSpec;
import com.alibaba.cloud.ai.dashscope.spec.DashScopeModel;
import java.util.function.Consumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.ai.model.ApiKey;
import org.springframework.ai.model.NoopApiKey;
import org.springframework.ai.model.SimpleApiKey;
import org.springframework.ai.retry.RetryUtils;
import org.springframework.http.HttpHeaders;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.util.Assert;
import org.springframework.web.client.ResponseErrorHandler;
import org.springframework.web.client.RestClient;

public class DashScopeVideoApi {
    private static final Logger logger = LoggerFactory.getLogger(DashScopeVideoApi.class);
    public static final String DEFAULT_VIDEO_MODEL = DashScopeModel.VideoModel.WANX2_1_T2V_TURBO.getValue();
    private final String baseUrl;
    private final ApiKey apiKey;
    private final RestClient restClient;
    private final ResponseErrorHandler responseErrorHandler;

    public Builder mutate() {
        return new Builder(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    public DashScopeVideoApi(String baseUrl, ApiKey apiKey, RestClient.Builder restClientBuilder, ResponseErrorHandler responseErrorHandler) {
        this.baseUrl = baseUrl;
        this.apiKey = apiKey;
        this.responseErrorHandler = responseErrorHandler;
        Consumer<HttpHeaders> finalHeaders = h -> {
            if (!(apiKey instanceof NoopApiKey)) {
                h.setBearerAuth(apiKey.getValue());
            }
            h.setContentType(MediaType.APPLICATION_JSON);
        };
        this.restClient = restClientBuilder.clone().baseUrl(baseUrl).defaultHeaders(finalHeaders).defaultStatusHandler(responseErrorHandler).build();
    }

    public ResponseEntity<DashScopeApiSpec.VideoGenerationResponse> submitVideoGenTask(DashScopeApiSpec.VideoGenerationRequest request) {
        logger.debug("Submitting video generation task with options: {}", (Object)request);
        String uri = request.getInput().getFirstFrameUrl() != null || request.getInput().getLastFrameUrl() != null ? "/api/v1/services/aigc/image2video/video-synthesis" : "/api/v1/services/aigc/video-generation/video-synthesis";
        return ((RestClient.RequestBodySpec)((RestClient.RequestBodySpec)this.restClient.post().uri(uri, new Object[0])).body((Object)request).header("X-DashScope-Async", new String[]{"enable"})).retrieve().toEntity(DashScopeApiSpec.VideoGenerationResponse.class);
    }

    public ResponseEntity<DashScopeApiSpec.VideoGenerationResponse> queryVideoGenTask(String taskId) {
        return this.restClient.get().uri("/api/v1/tasks/{task_id}", new Object[]{taskId}).retrieve().toEntity(DashScopeApiSpec.VideoGenerationResponse.class);
    }

    String getBaseUrl() {
        return this.baseUrl;
    }

    ApiKey getApiKey() {
        return this.apiKey;
    }

    RestClient getRestClient() {
        return this.restClient;
    }

    ResponseErrorHandler getResponseErrorHandler() {
        return this.responseErrorHandler;
    }

    public static class Builder {
        private String baseUrl = "https://dashscope.aliyuncs.com";
        private ApiKey apiKey;
        private RestClient.Builder restClientBuilder = RestClient.builder();
        private ResponseErrorHandler responseErrorHandler = RetryUtils.DEFAULT_RESPONSE_ERROR_HANDLER;

        public Builder() {
        }

        public Builder(DashScopeVideoApi api) {
            this.baseUrl = api.getBaseUrl();
            this.apiKey = api.getApiKey();
            this.restClientBuilder = api.restClient != null ? api.restClient.mutate() : RestClient.builder();
            this.responseErrorHandler = api.getResponseErrorHandler();
        }

        public Builder baseUrl(String baseUrl) {
            Assert.notNull((Object)baseUrl, (String)"Base URL cannot be null");
            this.baseUrl = baseUrl;
            return this;
        }

        public Builder apiKey(String simpleApiKey) {
            Assert.notNull((Object)simpleApiKey, (String)"Simple api key cannot be null");
            this.apiKey = new SimpleApiKey(simpleApiKey);
            return this;
        }

        public Builder restClientBuilder(RestClient.Builder restClientBuilder) {
            Assert.notNull((Object)restClientBuilder, (String)"Rest client builder cannot be null");
            this.restClientBuilder = restClientBuilder;
            return this;
        }

        public Builder responseErrorHandler(ResponseErrorHandler responseErrorHandler) {
            Assert.notNull((Object)responseErrorHandler, (String)"Response error handler cannot be null");
            this.responseErrorHandler = responseErrorHandler;
            return this;
        }

        public DashScopeVideoApi build() {
            Assert.notNull((Object)this.apiKey, (String)"API key cannot be null");
            return new DashScopeVideoApi(this.baseUrl, this.apiKey, this.restClientBuilder, this.responseErrorHandler);
        }
    }
}

