/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.cloud.ai.dashscope.agent;

import com.alibaba.cloud.ai.agent.Agent;
import com.alibaba.cloud.ai.dashscope.agent.DashScopeAgentOptions;
import com.alibaba.cloud.ai.dashscope.agent.DashScopeAgentRagOptions;
import com.alibaba.cloud.ai.dashscope.api.DashScopeAgentApi;
import java.util.HashMap;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.ai.chat.messages.AssistantMessage;
import org.springframework.ai.chat.messages.Message;
import org.springframework.ai.chat.messages.MessageType;
import org.springframework.ai.chat.metadata.ChatGenerationMetadata;
import org.springframework.ai.chat.model.ChatResponse;
import org.springframework.ai.chat.model.Generation;
import org.springframework.ai.chat.prompt.ChatOptions;
import org.springframework.ai.chat.prompt.Prompt;
import org.springframework.ai.model.ModelOptionsUtils;
import org.springframework.http.ResponseEntity;
import reactor.core.publisher.Flux;
import reactor.core.scheduler.Schedulers;

public final class DashScopeAgent
extends Agent {
    private static final Logger logger = LoggerFactory.getLogger(DashScopeAgent.class);
    private final DashScopeAgentOptions options;
    private final DashScopeAgentApi dashScopeAgentApi;

    public DashScopeAgent(DashScopeAgentApi dashScopeAgentApi) {
        this.dashScopeAgentApi = dashScopeAgentApi;
        this.options = DashScopeAgentOptions.builder().sessionId(null).memoryId(null).incrementalOutput(false).hasThoughts(false).images(null).bizParams(null).build();
    }

    public DashScopeAgent(DashScopeAgentApi dashScopeAgentApi, DashScopeAgentOptions options) {
        this.dashScopeAgentApi = dashScopeAgentApi;
        this.options = options;
    }

    @Override
    public ChatResponse call(Prompt prompt) {
        DashScopeAgentApi.DashScopeAgentRequest request = this.toRequest(prompt, false);
        ResponseEntity<DashScopeAgentApi.DashScopeAgentResponse> response = this.dashScopeAgentApi.call(request);
        if (response == null || response.getBody() == null) {
            logger.warn("app call error: request: {}", (Object)request);
            return null;
        }
        return this.toChatResponse((DashScopeAgentApi.DashScopeAgentResponse)response.getBody());
    }

    @Override
    public Flux<ChatResponse> stream(Prompt prompt) {
        DashScopeAgentApi.DashScopeAgentRequest request = this.toRequest(prompt, true);
        Flux<DashScopeAgentApi.DashScopeAgentResponse> response = this.dashScopeAgentApi.stream(request);
        return Flux.from(response).flatMap(result -> Flux.just((Object)this.toChatResponse((DashScopeAgentApi.DashScopeAgentResponse)result))).publishOn(Schedulers.parallel());
    }

    private DashScopeAgentApi.DashScopeAgentRequest toRequest(Prompt prompt, Boolean stream) {
        boolean onlyOneUserMessage;
        if (prompt == null) {
            throw new IllegalArgumentException("option is null");
        }
        DashScopeAgentOptions runtimeOptions = this.mergeOptions(prompt.getOptions());
        String appId = runtimeOptions.getAppId();
        if (appId == null || appId.isEmpty()) {
            throw new IllegalArgumentException("appId must be set");
        }
        String requestPrompt = null;
        List<DashScopeAgentApi.DashScopeAgentRequest.DashScopeAgentRequestInput.DashScopeAgentRequestMessage> requestMessages = List.of();
        List messages = prompt.getInstructions();
        boolean bl = onlyOneUserMessage = messages.size() == 1 && ((Message)messages.get(0)).getMessageType() == MessageType.USER;
        if (onlyOneUserMessage) {
            requestPrompt = ((Message)messages.get(0)).getText();
        } else {
            requestMessages = messages.stream().map(msg -> new DashScopeAgentApi.DashScopeAgentRequest.DashScopeAgentRequestInput.DashScopeAgentRequestMessage(msg.getMessageType().getValue(), msg.getText())).toList();
        }
        DashScopeAgentRagOptions ragOptions = runtimeOptions.getRagOptions();
        return new DashScopeAgentApi.DashScopeAgentRequest(appId, new DashScopeAgentApi.DashScopeAgentRequest.DashScopeAgentRequestInput(requestPrompt, requestMessages, runtimeOptions.getSessionId(), runtimeOptions.getMemoryId(), runtimeOptions.getImages(), runtimeOptions.getBizParams()), new DashScopeAgentApi.DashScopeAgentRequest.DashScopeAgentRequestParameters(runtimeOptions.getFlowStreamMode(), runtimeOptions.getHasThoughts(), stream != false && runtimeOptions.getIncrementalOutput() != false, ragOptions == null ? null : new DashScopeAgentApi.DashScopeAgentRequest.DashScopeAgentRequestParameters.DashScopeAgentRequestRagOptions(ragOptions.getPipelineIds(), ragOptions.getFileIds(), ragOptions.getMetadataFilter(), ragOptions.getTags(), ragOptions.getStructuredFilter(), ragOptions.getSessionFileIds())));
    }

    private ChatResponse toChatResponse(DashScopeAgentApi.DashScopeAgentResponse response) {
        DashScopeAgentApi.DashScopeAgentResponse.DashScopeAgentResponseOutput output = response.output();
        DashScopeAgentApi.DashScopeAgentResponse.DashScopeAgentResponseUsage usage = response.usage();
        if (output == null) {
            throw new RuntimeException("output is null");
        }
        String text = output.text();
        if (text == null) {
            text = "";
        }
        HashMap<String, Object> metadata = new HashMap<String, Object>();
        metadata.put("request_id", response.requestId());
        metadata.put("usage", usage);
        metadata.put("output", output);
        AssistantMessage assistantMessage = AssistantMessage.builder().content(text).properties(metadata).build();
        ChatGenerationMetadata generationMetadata = ChatGenerationMetadata.builder().finishReason(output.finishReason()).build();
        Generation generation = new Generation(assistantMessage, generationMetadata);
        return new ChatResponse(List.of(generation));
    }

    private DashScopeAgentOptions mergeOptions(ChatOptions chatOptions) {
        DashScopeAgentOptions agentOptions = (DashScopeAgentOptions)ModelOptionsUtils.copyToTarget((Object)chatOptions, ChatOptions.class, DashScopeAgentOptions.class);
        return (DashScopeAgentOptions)ModelOptionsUtils.merge((Object)agentOptions, (Object)this.options, DashScopeAgentOptions.class);
    }
}

