/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.cloud.ai.advisor;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Map;
import java.util.function.Consumer;
import org.springframework.ai.chat.client.ChatClientRequest;
import org.springframework.ai.chat.client.ChatClientResponse;
import org.springframework.ai.chat.client.advisor.api.AdvisorChain;
import org.springframework.ai.chat.client.advisor.api.BaseAdvisor;
import org.springframework.ai.chat.model.ChatResponse;
import org.springframework.ai.chat.prompt.PromptTemplate;
import org.springframework.ai.model.ApiKey;
import org.springframework.ai.model.NoopApiKey;
import org.springframework.core.io.Resource;
import org.springframework.http.HttpHeaders;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.util.Assert;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.web.reactive.function.BodyInserter;
import org.springframework.web.reactive.function.BodyInserters;
import org.springframework.web.reactive.function.client.WebClient;

public class DashScopeDocumentAnalysisAdvisor
implements BaseAdvisor {
    public static final String UPLOAD_RESPONSE = "upload_response";
    public static final String RESOURCE = "resource";
    private static final PromptTemplate DEFAULT_PROMPT_TEMPLATE = new PromptTemplate("fileid://{id}");
    private final int order;
    WebClient webClient;

    public DashScopeDocumentAnalysisAdvisor(ApiKey apiKey) {
        this(0, apiKey);
    }

    public DashScopeDocumentAnalysisAdvisor(int order, ApiKey apiKey) {
        Assert.notNull((Object)apiKey, (String)"Invalid api key");
        this.order = order;
        Consumer<HttpHeaders> finalHeaders = h -> {
            if (!(apiKey instanceof NoopApiKey)) {
                h.setBearerAuth(apiKey.getValue());
            }
            h.setContentType(MediaType.MULTIPART_FORM_DATA);
        };
        this.webClient = WebClient.builder().baseUrl("https://dashscope.aliyuncs.com").defaultHeaders(finalHeaders).build();
    }

    public ChatClientRequest before(ChatClientRequest chatClientRequest, AdvisorChain advisorChain) {
        Map context = chatClientRequest.context();
        Resource resource = (Resource)context.get(RESOURCE);
        if (resource != null) {
            ResponseEntity<UploadResponse> uploadResponse = this.upload(resource);
            context.put(UPLOAD_RESPONSE, uploadResponse);
            Assert.notNull((Object)uploadResponse.getBody(), (String)"upload response body is null");
            String augmentSystemMessage = DEFAULT_PROMPT_TEMPLATE.render(Map.of("id", ((UploadResponse)uploadResponse.getBody()).id));
            return chatClientRequest.mutate().prompt(chatClientRequest.prompt().augmentSystemMessage(augmentSystemMessage)).build();
        }
        return chatClientRequest;
    }

    public ChatClientResponse after(ChatClientResponse chatClientResponse, AdvisorChain advisorChain) {
        if (chatClientResponse.chatResponse() == null || chatClientResponse.chatResponse().getResults() == null) {
            return chatClientResponse;
        }
        ChatResponse.Builder chatResponseBuilder = ChatResponse.builder().from(chatClientResponse.chatResponse());
        if (chatClientResponse.context().containsKey(UPLOAD_RESPONSE)) {
            chatResponseBuilder.metadata(UPLOAD_RESPONSE, chatClientResponse.context().get(UPLOAD_RESPONSE));
        }
        return ChatClientResponse.builder().chatResponse(chatResponseBuilder.build()).context(chatClientResponse.context()).build();
    }

    public ResponseEntity<UploadResponse> upload(Resource resource) {
        LinkedMultiValueMap formData = new LinkedMultiValueMap();
        formData.add((Object)"file", (Object)resource);
        formData.add((Object)"purpose", (Object)"file-extract");
        return (ResponseEntity)((WebClient.RequestBodySpec)this.webClient.post().uri("/compatible-mode/v1/files", new Object[0])).body((BodyInserter)BodyInserters.fromMultipartData((MultiValueMap)formData)).retrieve().toEntity(UploadResponse.class).block();
    }

    public int getOrder() {
        return this.order;
    }

    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public record UploadResponse(@JsonProperty(value="id") String id, @JsonProperty(value="object") String object, @JsonProperty(value="bytes") int bytes, @JsonProperty(value="filename") String filename, @JsonProperty(value="purpose") String purpose, @JsonProperty(value="status") String status, @JsonProperty(value="created_at") String createdAt) {
    }
}

