/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.cloud.ai.dashscope.api;

import com.alibaba.cloud.ai.dashscope.audio.DashScopeAudioTranscriptionOptions;
import com.alibaba.cloud.ai.dashscope.common.DashScopeException;
import com.alibaba.cloud.ai.dashscope.protocol.DashScopeWebSocketClient;
import com.alibaba.cloud.ai.dashscope.protocol.DashScopeWebSocketClientOptions;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.InputStream;
import java.net.URI;
import java.nio.ByteBuffer;
import java.util.List;
import java.util.function.Consumer;
import org.springframework.ai.model.ApiKey;
import org.springframework.ai.model.NoopApiKey;
import org.springframework.ai.model.SimpleApiKey;
import org.springframework.ai.retry.RetryUtils;
import org.springframework.http.HttpHeaders;
import org.springframework.http.ResponseEntity;
import org.springframework.util.Assert;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.ResponseErrorHandler;
import org.springframework.web.client.RestClient;
import reactor.core.publisher.Flux;

public class DashScopeAudioTranscriptionApi {
    private final String baseUrl;
    private final String model;
    private final ApiKey apiKey;
    private final String workSpaceId;
    private final String webSocketUrl;
    private final MultiValueMap<String, String> headers;
    private final DashScopeWebSocketClient webSocketClient;
    private final RestClient restClient;
    private final ResponseErrorHandler responseErrorHandler;

    public DashScopeAudioTranscriptionApi(String baseUrl, ApiKey apiKey, String model, String workSpaceId, MultiValueMap<String, String> headers, String webSocketUrl, RestClient.Builder restClientBuilder, ResponseErrorHandler responseErrorHandler) {
        this.baseUrl = baseUrl;
        this.model = model;
        this.apiKey = apiKey;
        this.workSpaceId = workSpaceId;
        this.webSocketUrl = webSocketUrl;
        this.headers = headers;
        this.responseErrorHandler = responseErrorHandler;
        Consumer<HttpHeaders> authHeaders = h -> {
            h.addAll(headers);
            if (!(apiKey instanceof NoopApiKey)) {
                h.setBearerAuth(apiKey.getValue());
                h.set("X-DashScope-Async", "enable");
            }
        };
        this.restClient = restClientBuilder.clone().baseUrl(baseUrl).defaultHeaders(authHeaders).defaultStatusHandler(responseErrorHandler).build();
        this.webSocketClient = new DashScopeWebSocketClient(DashScopeWebSocketClientOptions.builder().withApiKey(apiKey.getValue()).withWorkSpaceId(workSpaceId).withUrl(webSocketUrl).build());
    }

    public Builder mutate() {
        return new Builder(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    public ResponseEntity<Response> submitTask(Request request) {
        return ((RestClient.RequestBodySpec)this.restClient.post().uri("/api/v1/services/audio/asr/transcription", new Object[0])).body((Object)request).retrieve().toEntity(Response.class);
    }

    public ResponseEntity<Response> queryTaskResult(String taskId) {
        String uri = "/api/v1/tasks/" + taskId;
        return ((RestClient.RequestBodySpec)this.restClient.post().uri(uri, new Object[0])).retrieve().toEntity(Response.class);
    }

    public void realtimeControl(RealtimeRequest request) {
        try {
            String message = new ObjectMapper().writeValueAsString((Object)request);
            this.webSocketClient.sendText(message);
        }
        catch (JsonProcessingException e) {
            throw new RuntimeException(e);
        }
    }

    public Flux<RealtimeResponse> realtimeStream(Flux<ByteBuffer> audio) {
        return this.webSocketClient.streamTextOut(audio).handle((msg, sink) -> {
            try {
                sink.next((Object)((RealtimeResponse)new ObjectMapper().readValue(msg, RealtimeResponse.class)));
            }
            catch (JsonProcessingException e) {
                sink.error((Throwable)new DashScopeException(String.valueOf((Object)e)));
            }
        });
    }

    public Outcome getOutcome(String transcriptionUrl) {
        ObjectMapper objectMapper = new ObjectMapper();
        try {
            InputStream inputStream = URI.create(transcriptionUrl).toURL().openStream();
            Outcome outcome = (Outcome)objectMapper.readValue(inputStream, Outcome.class);
            inputStream.close();
            return outcome;
        }
        catch (Exception e) {
            throw new DashScopeException("get transcription outcome failed", e);
        }
    }

    public String getBaseUrl() {
        return this.baseUrl;
    }

    public String getModel() {
        return this.model;
    }

    public ApiKey getApiKey() {
        return this.apiKey;
    }

    public String getWorkSpaceId() {
        return this.workSpaceId;
    }

    public String getWebSocketUrl() {
        return this.webSocketUrl;
    }

    public MultiValueMap<String, String> getHeaders() {
        return this.headers;
    }

    ResponseErrorHandler getResponseErrorHandler() {
        return this.responseErrorHandler;
    }

    public static class Builder {
        private String baseUrl = "https://dashscope.aliyuncs.com";
        private String workSpaceId;
        private String model;
        private ApiKey apiKey;
        private MultiValueMap<String, String> headers = new LinkedMultiValueMap();
        private String webSocketUrl = "wss://dashscope.aliyuncs.com/api-ws/v1/inference";
        private RestClient.Builder restClientBuilder = RestClient.builder();
        private ResponseErrorHandler responseErrorHandler = RetryUtils.DEFAULT_RESPONSE_ERROR_HANDLER;

        public Builder() {
        }

        public Builder(DashScopeAudioTranscriptionApi api) {
            this.baseUrl = api.getBaseUrl();
            this.apiKey = api.getApiKey();
            this.model = api.getModel();
            this.headers = new LinkedMultiValueMap(api.getHeaders());
            this.webSocketUrl = api.webSocketUrl;
            this.restClientBuilder = api.restClient != null ? api.restClient.mutate() : RestClient.builder();
            this.responseErrorHandler = api.getResponseErrorHandler();
        }

        public Builder baseUrl(String baseUrl) {
            this.baseUrl = baseUrl;
            return this;
        }

        public Builder workSpaceId(String workSpaceId) {
            this.workSpaceId = workSpaceId;
            return this;
        }

        public Builder apiKey(ApiKey apiKey) {
            this.apiKey = apiKey;
            return this;
        }

        public Builder apiKey(String simpleApiKey) {
            this.apiKey = new SimpleApiKey(simpleApiKey);
            return this;
        }

        public Builder model(String model) {
            this.model = model;
            return this;
        }

        public Builder webSocketUrl(String webSocketUrl) {
            this.webSocketUrl = webSocketUrl;
            return this;
        }

        public Builder headers(MultiValueMap<String, String> headers) {
            this.headers = headers;
            return this;
        }

        public Builder restClientBuilder(RestClient.Builder restClientBuilder) {
            this.restClientBuilder = restClientBuilder;
            return this;
        }

        public Builder responseErrorHandler(ResponseErrorHandler responseErrorHandler) {
            this.responseErrorHandler = responseErrorHandler;
            return this;
        }

        public DashScopeAudioTranscriptionApi build() {
            Assert.hasText((String)this.baseUrl, (String)"baseUrl cannot be null or empty");
            Assert.notNull((Object)this.apiKey, (String)"apiKey must be set");
            Assert.notNull((Object)this.model, (String)"model must be set");
            Assert.notNull(this.headers, (String)"headers cannot be null");
            Assert.notNull((Object)this.restClientBuilder, (String)"restClientBuilder cannot be null");
            Assert.notNull((Object)this.responseErrorHandler, (String)"responseErrorHandler cannot be null");
            return new DashScopeAudioTranscriptionApi(this.baseUrl, this.apiKey, this.model, this.workSpaceId, this.headers, this.webSocketUrl, this.restClientBuilder, this.responseErrorHandler);
        }
    }

    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public record Response(@JsonProperty(value="request_id") String requestId, @JsonProperty(value="usage") Usage usage, @JsonProperty(value="output") Output output) {

        public record Usage(@JsonProperty(value="duration") Integer duration) {
        }

        public record Output(@JsonProperty(value="task_id") String taskId, @JsonProperty(value="task_status") TaskStatus taskStatus, @JsonProperty(value="submit_time") String submitTime, @JsonProperty(value="scheduled_time") String scheduledTime, @JsonProperty(value="end_time") String endTime, @JsonProperty(value="results") List<Result> results, @JsonProperty(value="task_metrics") TaskMetrics taskMetrics) {

            public record TaskMetrics(@JsonProperty(value="TOTAL") Integer total, @JsonProperty(value="SUCCEEDED") Integer succeeded, @JsonProperty(value="FAILED") Integer failed) {
            }

            public record Result(@JsonProperty(value="file_url") String fileUrl, @JsonProperty(value="transcription_url") String transcriptionUrl, @JsonProperty(value="subtask_status") String subtaskStatus) {
            }
        }
    }

    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public record Outcome(@JsonProperty(value="file_url") String fileUrl, @JsonProperty(value="properties") Properties properties, @JsonProperty(value="transcripts") List<Transcript> transcripts) {

        public record Properties(@JsonProperty(value="audio_format") String audioFormat, @JsonProperty(value="channels") List<Integer> channels, @JsonProperty(value="original_sampling_rate") Integer originalSamplingRate, @JsonProperty(value="original_duration_in_milliseconds") Integer originalDurationInMilliseconds) {
        }

        public record Transcript(@JsonProperty(value="channel_id") Integer channelId, @JsonProperty(value="content_duration_in_milliseconds") Integer contentDurationInMilliseconds, @JsonProperty(value="text") String text, @JsonProperty(value="sentences") List<Sentence> sentences) {

            public record Sentence(@JsonProperty(value="begin_time") Integer beginTime, @JsonProperty(value="end_time") Integer endTime, @JsonProperty(value="text") String text, @JsonProperty(value="sentence_id") String sentenceId, @JsonProperty(value="speaker_id") String speakerId, @JsonProperty(value="words") List<Word> words) {

                public record Word(@JsonProperty(value="begin_time") Integer beginTime, @JsonProperty(value="end_time") Integer endTime, @JsonProperty(value="text") String text, @JsonProperty(value="punctuation") String punctuation) {
                }
            }
        }
    }

    public record RealtimeResponse(@JsonProperty(value="header") Header header, @JsonProperty(value="payload") Payload payload) {

        public record Header(@JsonProperty(value="task_id") String taskId, @JsonProperty(value="event") DashScopeWebSocketClient.EventType event, @JsonProperty(value="attributes") Attributes attributes) {

            public record Attributes() {
            }
        }

        public record Payload(@JsonProperty(value="output") Output output, @JsonProperty(value="usage") Usage usage) {

            public record Output(@JsonProperty(value="sentence") Sentence sentence) {

                public record Sentence(@JsonProperty(value="sentence_id") String sentenceId, @JsonProperty(value="begin_time") Integer beginTime, @JsonProperty(value="end_time") Integer endTime, @JsonProperty(value="text") String text, @JsonProperty(value="channel_id") Integer channelId, @JsonProperty(value="speaker_id") String speakerId, @JsonProperty(value="sentence_end") Boolean sentenceEnd, @JsonProperty(value="words") List<Word> words, @JsonProperty(value="stash") Stash stash) {

                    public record Stash(@JsonProperty(value="sentence_id") String sentenceId, @JsonProperty(value="text") String text, @JsonProperty(value="begin_time") Integer beginTime, @JsonProperty(value="current_time") Integer currentTime, @JsonProperty(value="words") List<Word> words) {
                    }

                    public record Word(@JsonProperty(value="begin_time") Integer beginTime, @JsonProperty(value="end_time") Integer endTime, @JsonProperty(value="text") String text, @JsonProperty(value="punctuation") String punctuation, @JsonProperty(value="fixed") Boolean fixed, @JsonProperty(value="speaker_id") String speakerId) {
                    }
                }
            }

            public record Usage(@JsonProperty(value="duration") Integer duration) {
            }
        }
    }

    public static enum TaskStatus {
        PENDING("PENDING"),
        SUSPENDED("SUSPENDED"),
        SUCCEEDED("SUCCEEDED"),
        CANCELED("CANCELED"),
        RUNNING("RUNNING"),
        FAILED("FAILED"),
        UNKNOWN("UNKNOWN");

        private final String status;

        private TaskStatus(String status) {
            this.status = status;
        }

        public String getValue() {
            return this.status;
        }
    }

    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public record RealtimeRequest(@JsonProperty(value="header") Header header, @JsonProperty(value="payload") Payload payload) {

        public record Header(@JsonProperty(value="action") DashScopeWebSocketClient.EventType action, @JsonProperty(value="task_id") String taskId, @JsonProperty(value="streaming") String streaming) {
        }

        public record Payload(@JsonProperty(value="model") String model, @JsonProperty(value="task_group") String taskGroup, @JsonProperty(value="task") String task, @JsonProperty(value="function") String function, @JsonProperty(value="input") Input input, @JsonProperty(value="parameters") Parameters parameters) {

            public record Input() {
            }

            public record Parameters(@JsonProperty(value="sample_rate") Integer sampleRate, @JsonProperty(value="format") DashScopeAudioTranscriptionOptions.AudioFormat format, @JsonProperty(value="disfluency_removal_enabled") Boolean disfluencyRemovalEnabled) {
            }
        }
    }

    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public record Request(@JsonProperty(value="model") String model, @JsonProperty(value="input") Input input, @JsonProperty(value="resources") List<Resource> resources, @JsonProperty(value="parameters") Parameters parameters) {

        public record Input(@JsonProperty(value="file_urls") List<String> fileUrls) {
        }

        public record Parameters(@JsonProperty(value="vocabulary_id") String vocabularyId, @JsonProperty(value="channel_id") List<Integer> channelId, @JsonProperty(value="disfluency_removal_enabled") Boolean disfluencyRemovalEnabled, @JsonProperty(value="timestamp_alignment_enabled") Boolean timestampAlignmentEnabled, @JsonProperty(value="special_word_filter") String specialWordFilter, @JsonProperty(value="language_hints") List<String> languageHints, @JsonProperty(value="diarization_enabled") Boolean diarizationEnabled, @JsonProperty(value="speaker_count") Integer speakerCount) {
        }

        public record Resource(@JsonProperty(value="resource_id") String resourceId, @JsonProperty(value="resource_type") String resourceType) {
        }
    }
}

