/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.cloud.ai.autoconfigure.memory.redis;

import com.alibaba.cloud.ai.autoconfigure.memory.redis.RedisChatMemoryClusterConfiguration;
import com.alibaba.cloud.ai.autoconfigure.memory.redis.RedisChatMemoryConnectionDetails;
import com.alibaba.cloud.ai.autoconfigure.memory.redis.RedisChatMemoryProperties;
import com.alibaba.cloud.ai.autoconfigure.memory.redis.RedisChatMemoryStandaloneConfiguration;
import com.alibaba.cloud.ai.autoconfigure.memory.redis.RedisMemoryConnectionDetails;
import java.util.ArrayList;
import java.util.List;
import org.springframework.ai.chat.memory.ChatMemoryRepository;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.boot.ssl.SslBundles;
import org.springframework.util.CollectionUtils;

public abstract class RedisChatMemoryConnectionAutoConfiguration<T extends ChatMemoryRepository> {
    private final RedisChatMemoryProperties properties;
    private final RedisChatMemoryConnectionDetails connectionDetails;
    private final SslBundles sslBundles;

    public RedisChatMemoryConnectionAutoConfiguration(RedisChatMemoryProperties properties, RedisChatMemoryConnectionDetails connectionDetails, ObjectProvider<SslBundles> sslBundles) {
        this.properties = properties;
        this.connectionDetails = connectionDetails;
        this.sslBundles = (SslBundles)sslBundles.getIfAvailable();
    }

    protected abstract T createStandaloneChatMemoryRepository(RedisChatMemoryStandaloneConfiguration var1);

    protected abstract T createClusterChatMemoryRepository(RedisChatMemoryClusterConfiguration var1);

    protected T buildRedisChatMemoryRepository() {
        RedisChatMemoryProperties.Mode redisChatMemoryMode = this.getRedisChatMemoryMode();
        if (redisChatMemoryMode == RedisChatMemoryProperties.Mode.STANDALONE) {
            RedisChatMemoryStandaloneConfiguration standaloneConfiguration = this.getStandaloneConfiguration();
            return this.createStandaloneChatMemoryRepository(standaloneConfiguration);
        }
        if (redisChatMemoryMode == RedisChatMemoryProperties.Mode.CLUSTER) {
            RedisChatMemoryClusterConfiguration clusterConfiguration = this.getClusterConfiguration();
            return this.createClusterChatMemoryRepository(clusterConfiguration);
        }
        throw new IllegalArgumentException("Unsupported Redis Chat Memory mode: " + redisChatMemoryMode);
    }

    protected RedisChatMemoryProperties.Mode getRedisChatMemoryMode() {
        RedisChatMemoryProperties.Mode mode = this.properties.getMode();
        if (mode == null) {
            return RedisChatMemoryProperties.Mode.STANDALONE;
        }
        return this.properties.getMode();
    }

    protected final RedisChatMemoryStandaloneConfiguration getStandaloneConfiguration() {
        RedisMemoryConnectionDetails.Standalone standalone = this.connectionDetails.getStandalone();
        return new RedisChatMemoryStandaloneConfiguration(standalone.getHost(), standalone.getPort(), this.connectionDetails.getUsername(), this.connectionDetails.getPassword(), this.properties.getTimeout(), this.properties.getSsl(), this.sslBundles);
    }

    protected final RedisChatMemoryClusterConfiguration getClusterConfiguration() {
        if (this.properties.getCluster() == null || CollectionUtils.isEmpty(this.properties.getCluster().getNodes())) {
            throw new IllegalStateException("Cluster nodes configuration is required for CLUSTER mode");
        }
        List<String> nodes = this.getNodes(this.connectionDetails.getCluster());
        return new RedisChatMemoryClusterConfiguration(nodes, this.connectionDetails.getUsername(), this.connectionDetails.getPassword(), this.properties.getTimeout(), this.properties.getSsl(), this.sslBundles);
    }

    private List<String> getNodes(RedisMemoryConnectionDetails.Cluster cluster) {
        ArrayList<String> clusterNodes = new ArrayList<String>();
        for (RedisMemoryConnectionDetails.Node node : cluster.getNodes()) {
            clusterNodes.add(node.host() + ":" + node.port());
        }
        return clusterNodes;
    }
}

