/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.cloud.ai.autoconfigure.memory.redis;

import com.alibaba.cloud.ai.autoconfigure.memory.ChatMemoryAutoConfiguration;
import com.alibaba.cloud.ai.autoconfigure.memory.redis.RedisChatMemoryClusterConfiguration;
import com.alibaba.cloud.ai.autoconfigure.memory.redis.RedisChatMemoryConnectionAutoConfiguration;
import com.alibaba.cloud.ai.autoconfigure.memory.redis.RedisChatMemoryConnectionDetails;
import com.alibaba.cloud.ai.autoconfigure.memory.redis.RedisChatMemoryProperties;
import com.alibaba.cloud.ai.autoconfigure.memory.redis.RedisChatMemoryStandaloneConfiguration;
import com.alibaba.cloud.ai.memory.redis.LettuceRedisChatMemoryRepository;
import io.lettuce.core.RedisClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.boot.ssl.SslBundles;
import org.springframework.context.annotation.Bean;

@AutoConfiguration(before={ChatMemoryAutoConfiguration.class})
@ConditionalOnClass(value={LettuceRedisChatMemoryRepository.class, RedisClient.class})
@EnableConfigurationProperties(value={RedisChatMemoryProperties.class})
@ConditionalOnProperty(name={"spring.ai.memory.redis.client-type"}, havingValue="lettuce")
public class LettuceRedisChatMemoryConnectionAutoConfiguration
extends RedisChatMemoryConnectionAutoConfiguration<LettuceRedisChatMemoryRepository> {
    private static final Logger logger = LoggerFactory.getLogger(LettuceRedisChatMemoryConnectionAutoConfiguration.class);

    public LettuceRedisChatMemoryConnectionAutoConfiguration(RedisChatMemoryProperties properties, RedisChatMemoryConnectionDetails connectionDetails, ObjectProvider<SslBundles> sslBundles) {
        super(properties, connectionDetails, sslBundles);
    }

    @Override
    @Bean
    @ConditionalOnMissingBean
    protected LettuceRedisChatMemoryRepository buildRedisChatMemoryRepository() {
        return (LettuceRedisChatMemoryRepository)super.buildRedisChatMemoryRepository();
    }

    @Override
    protected LettuceRedisChatMemoryRepository createStandaloneChatMemoryRepository(RedisChatMemoryStandaloneConfiguration standaloneConfiguration) {
        logger.info("Configuring Redis Standalone chat memory repository using Lettuce");
        return ((LettuceRedisChatMemoryRepository.RedisBuilder)((LettuceRedisChatMemoryRepository.RedisBuilder)((LettuceRedisChatMemoryRepository.RedisBuilder)((LettuceRedisChatMemoryRepository.RedisBuilder)((LettuceRedisChatMemoryRepository.RedisBuilder)((LettuceRedisChatMemoryRepository.RedisBuilder)((LettuceRedisChatMemoryRepository.RedisBuilder)((LettuceRedisChatMemoryRepository.RedisBuilder)LettuceRedisChatMemoryRepository.builder().host(standaloneConfiguration.hostName())).port(standaloneConfiguration.port())).username(standaloneConfiguration.username())).password(standaloneConfiguration.password())).timeout(standaloneConfiguration.timeout())).sslBundles(standaloneConfiguration.sslBundles())).useSsl(standaloneConfiguration.ssl().isEnabled())).bundle(standaloneConfiguration.ssl().getBundle())).build();
    }

    @Override
    protected LettuceRedisChatMemoryRepository createClusterChatMemoryRepository(RedisChatMemoryClusterConfiguration clusterConfiguration) {
        logger.info("Configuring Redis Cluster chat memory repository using Lettuce");
        return ((LettuceRedisChatMemoryRepository.RedisBuilder)((LettuceRedisChatMemoryRepository.RedisBuilder)((LettuceRedisChatMemoryRepository.RedisBuilder)((LettuceRedisChatMemoryRepository.RedisBuilder)((LettuceRedisChatMemoryRepository.RedisBuilder)((LettuceRedisChatMemoryRepository.RedisBuilder)((LettuceRedisChatMemoryRepository.RedisBuilder)LettuceRedisChatMemoryRepository.builder().nodes(clusterConfiguration.nodeAddresses())).username(clusterConfiguration.username())).password(clusterConfiguration.password())).timeout(clusterConfiguration.timeout())).sslBundles(clusterConfiguration.sslBundles())).useSsl(clusterConfiguration.ssl().isEnabled())).bundle(clusterConfiguration.ssl().getBundle())).build();
    }
}

